/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectorMonitor;
import org.opennms.netmgt.provision.support.AsyncAbstractDetector;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.BaseDetectorHandler;
import org.opennms.netmgt.provision.support.ConnectionFactory;
import org.opennms.netmgt.provision.support.DefaultDetectFuture;
import org.opennms.netmgt.provision.support.trustmanager.RelaxedX509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncBasicDetector<Request, Response>
extends AsyncAbstractDetector {
    protected static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private BaseDetectorHandler<Request, Response> m_detectorHandler = new BaseDetectorHandler();
    private IoFilterAdapter m_filterLogging;
    private ProtocolCodecFilter m_protocolCodecFilter = new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(CHARSET_UTF8));
    private int m_idleTime = 1;
    private AsyncClientConversation<Request, Response> m_conversation = new AsyncClientConversation();
    private boolean useSSLFilter = false;
    private ConnectFuture m_connection;
    private ConnectionFactory m_connectionFactory;

    public AsyncBasicDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    public AsyncBasicDetector(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    @Override
    protected abstract void onInit();

    @Override
    public DetectFuture isServiceDetected(InetAddress address, DetectorMonitor monitor) throws Exception {
        final DefaultDetectFuture detectFuture = new DefaultDetectFuture(this);
        final SSLContext c = this.createClientSSLContext();
        IoSessionInitializer<ConnectFuture> init = new IoSessionInitializer<ConnectFuture>(){

            public void initializeSession(IoSession session, ConnectFuture future) {
                if (AsyncBasicDetector.this.isUseSSLFilter()) {
                    SslFilter filter = new SslFilter(c);
                    filter.setUseClientMode(true);
                    session.getFilterChain().addFirst("SSL", (IoFilter)filter);
                }
                session.getFilterChain().addLast("logger", (IoFilter)(AsyncBasicDetector.this.getLoggingFilter() != null ? AsyncBasicDetector.this.getLoggingFilter() : new LoggingFilter()));
                session.getFilterChain().addLast("codec", (IoFilter)AsyncBasicDetector.this.getProtocolCodecFilter());
                session.getConfig().setIdleTime(IdleStatus.READER_IDLE, AsyncBasicDetector.this.getIdleTime());
                session.setAttribute(IoHandler.class, (Object)AsyncBasicDetector.this.createDetectorHandler(detectFuture));
            }
        };
        InetSocketAddress socketAddress = new InetSocketAddress(address, this.getPort());
        this.m_connectionFactory = ConnectionFactory.getFactory(this.getTimeout());
        ConnectFuture cf = this.m_connectionFactory.connect(socketAddress, (IoSessionInitializer<? extends ConnectFuture>)init);
        cf.addListener(this.retryAttemptListener(this.m_connectionFactory, detectFuture, socketAddress, init, this.getRetries()));
        return detectFuture;
    }

    @Override
    public void dispose() {
        LogUtils.debugf((Object)this, (String)"calling dispose on detector %s", (Object[])new Object[]{this.getServiceName()});
        ConnectionFactory.dispose(this.m_connectionFactory, this.m_connection);
        this.m_connectionFactory = null;
        this.m_connection = null;
    }

    private SSLContext createClientSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tm, new SecureRandom());
        return sslContext;
    }

    private IoFutureListener<ConnectFuture> retryAttemptListener(final ConnectionFactory connector, final DetectFuture detectFuture, final InetSocketAddress address, final IoSessionInitializer<ConnectFuture> init, final int retryAttempt) {
        return new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                Throwable cause = future.getException();
                if (cause instanceof ConnectException) {
                    if (retryAttempt == 0) {
                        LogUtils.infof((Object)this, (String)"service %s detected false", (Object[])new Object[]{AsyncBasicDetector.this.getServiceName()});
                        detectFuture.setServiceDetected(false);
                    } else {
                        LogUtils.infof((Object)this, (String)"Connection exception occurred %s for service %s retrying attempt: ", (Object[])new Object[]{cause, AsyncBasicDetector.this.getServiceName()});
                        future = connector.reConnect(address, (IoSessionInitializer<? extends ConnectFuture>)init);
                        future.addListener(AsyncBasicDetector.this.retryAttemptListener(connector, detectFuture, address, (IoSessionInitializer<ConnectFuture>)init, retryAttempt - 1));
                    }
                } else if (cause instanceof Throwable) {
                    LogUtils.infof((Object)this, (String)"Threw a Throwable and detection is false for service %s", (Object[])new Object[]{AsyncBasicDetector.this.getServiceName()});
                    detectFuture.setServiceDetected(false);
                }
            }
        };
    }

    protected void expectBanner(AsyncClientConversation.ResponseValidator<Response> bannerValidator) {
        this.getConversation().setHasBanner(true);
        this.getConversation().addExchange(new AsyncClientConversation.AsyncExchangeImpl<Object, Response>(null, bannerValidator));
    }

    protected void send(Request request, AsyncClientConversation.ResponseValidator<Response> responseValidator) {
        this.getConversation().addExchange(new AsyncClientConversation.AsyncExchangeImpl<Request, Response>(request, responseValidator));
    }

    protected void setDetectorHandler(BaseDetectorHandler<Request, Response> detectorHandler) {
        this.m_detectorHandler = detectorHandler;
    }

    protected IoHandler createDetectorHandler(DetectFuture future) {
        this.m_detectorHandler.setConversation(this.getConversation());
        this.m_detectorHandler.setFuture(future);
        return this.m_detectorHandler;
    }

    protected void setLoggingFilter(IoFilterAdapter filterLogging) {
        this.m_filterLogging = filterLogging;
    }

    protected IoFilterAdapter getLoggingFilter() {
        return this.m_filterLogging;
    }

    protected void setProtocolCodecFilter(ProtocolCodecFilter protocolCodecFilter) {
        this.m_protocolCodecFilter = protocolCodecFilter;
    }

    protected ProtocolCodecFilter getProtocolCodecFilter() {
        return this.m_protocolCodecFilter;
    }

    public void setIdleTime(int idleTime) {
        this.m_idleTime = idleTime;
    }

    public int getIdleTime() {
        return this.m_idleTime;
    }

    protected IoHandler getDetectorHandler() {
        return this.m_detectorHandler;
    }

    protected void setConversation(AsyncClientConversation<Request, Response> conversation) {
        this.m_conversation = conversation;
    }

    protected AsyncClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }

    protected Request request(Request request) {
        return request;
    }

    protected AsyncClientConversation.ResponseValidator<Response> startsWith(final String prefix) {
        return new AsyncClientConversation.ResponseValidator<Response>(){

            @Override
            public boolean validate(Object message) {
                String str = message.toString().trim();
                return str.startsWith(prefix);
            }
        };
    }

    public AsyncClientConversation.ResponseValidator<Response> find(final String regex) {
        return new AsyncClientConversation.ResponseValidator<Response>(){

            @Override
            public boolean validate(Object message) {
                String str = message.toString().trim();
                return Pattern.compile(regex).matcher(str).find();
            }
        };
    }

    public void setUseSSLFilter(boolean useSSLFilter) {
        this.useSSLFilter = useSSLFilter;
    }

    public boolean isUseSSLFilter() {
        return this.useSSLFilter;
    }
}

