/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class SimplerQueuedProvisioningAdapter
extends SimpleQueuedProvisioningAdapter {
    private String m_name;
    protected long m_delay = 1L;
    protected TimeUnit m_timeUnit = TimeUnit.SECONDS;
    protected TransactionTemplate m_template;

    public TransactionTemplate getTemplate() {
        return this.m_template;
    }

    public void setTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    public SimplerQueuedProvisioningAdapter(String name) {
        this.m_name = name;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.m_timeUnit = timeUnit;
    }

    public void setDelay(long delay) {
        this.m_delay = delay;
    }

    public String getName() {
        return this.m_name;
    }

    SimpleQueuedProvisioningAdapter.AdapterOperationSchedule createScheduleForNode(int nodeId, SimpleQueuedProvisioningAdapter.AdapterOperationType adapterOperationType) {
        return new SimpleQueuedProvisioningAdapter.AdapterOperationSchedule(this.m_delay, 0L, 1, this.m_timeUnit);
    }

    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        return true;
    }

    public final void processPendingOperationForNode(final SimpleQueuedProvisioningAdapter.AdapterOperation op) throws ProvisioningAdapterException {
        if (SimplerQueuedProvisioningAdapter.log().isDebugEnabled()) {
            SimplerQueuedProvisioningAdapter.log().debug("processPendingOperationForNode: " + (Object)((Object)op.getType()) + " for node: " + op.getNodeId());
        }
        switch (op.getType()) {
            case ADD: {
                this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus arg0) {
                        SimplerQueuedProvisioningAdapter.log().debug("processPendingOperationForNode: calling doAddNode() for node: " + op.getNodeId());
                        SimplerQueuedProvisioningAdapter.this.doAddNode(op.getNodeId());
                        return null;
                    }
                });
                break;
            }
            case UPDATE: {
                this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus arg0) {
                        SimplerQueuedProvisioningAdapter.log().debug("processPendingOperationForNode: calling doUpdateNode() for node: " + op.getNodeId());
                        SimplerQueuedProvisioningAdapter.this.doUpdateNode(op.getNodeId());
                        return null;
                    }
                });
                break;
            }
            case DELETE: {
                this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus arg0) {
                        SimplerQueuedProvisioningAdapter.log().debug("processPendingOperationForNode: calling doDeleteNode() for node: " + op.getNodeId());
                        SimplerQueuedProvisioningAdapter.this.doDeleteNode(op.getNodeId());
                        return null;
                    }
                });
                break;
            }
            case CONFIG_CHANGE: {
                this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus arg0) {
                        SimplerQueuedProvisioningAdapter.log().debug("processPendingOperationForNode: calling doNotifyConfigChange() for node: " + op.getNodeId());
                        SimplerQueuedProvisioningAdapter.this.doNotifyConfigChange(op.getNodeId());
                        return null;
                    }
                });
                break;
            }
            default: {
                SimplerQueuedProvisioningAdapter.log().warn("unknown operation: " + (Object)((Object)op.getType()));
            }
        }
    }

    public void init() {
        this.assertNotNull((Object)this.m_timeUnit, "timeUnit must be set");
    }

    private void assertNotNull(Object o, String msg) {
        this.assertTrue(o != null, msg);
    }

    private void assertTrue(boolean b, String m) {
        if (!b) {
            throw new IllegalStateException(m);
        }
    }

    public void doAddNode(int nodeid) {
    }

    public void doUpdateNode(int nodeid) {
    }

    public void doDeleteNode(int nodeid) {
    }

    public void doNotifyConfigChange(int nodeid) {
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(SimplerQueuedProvisioningAdapter.class);
    }
}

