/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.annotations.Require;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.PropertyAccessorFactory;

public abstract class BasePolicy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BasePolicy.class);
    private Match m_match = Match.ANY_PARAMETER;
    private final LinkedHashMap<String, String> m_criteria = new LinkedHashMap();

    protected boolean match(String s, String matcher) {
        if (s == null) {
            return false;
        }
        if (matcher.startsWith("~")) {
            return s.matches(matcher.replaceFirst("~", ""));
        }
        return s.equals(matcher);
    }

    @Require(value={"ANY_PARAMETER", "ALL_PARAMETERS", "NO_PARAMETERS"})
    public String getMatchBehavior() {
        return this.getMatch().toString();
    }

    public void setMatchBehavior(String matchBehavior) {
        String upperMatchBehavior = matchBehavior.toUpperCase();
        if (matchBehavior != null && upperMatchBehavior.contains("ALL")) {
            this.setMatch(Match.ALL_PARAMETERS);
        } else if (matchBehavior != null && upperMatchBehavior.contains("NO")) {
            this.setMatch(Match.NO_PARAMETERS);
        } else {
            this.setMatch(Match.ANY_PARAMETER);
        }
    }

    protected void setMatch(Match match) {
        this.m_match = match;
    }

    protected Match getMatch() {
        return this.m_match;
    }

    protected String getCriteria(String key) {
        return this.getCriteria().get(key);
    }

    protected String putCriteria(String key, String expression) {
        return this.getCriteria().put(key, expression);
    }

    protected LinkedHashMap<String, String> getCriteria() {
        return this.m_criteria;
    }

    protected boolean matches(T iface) {
        switch (this.getMatch()) {
            case ALL_PARAMETERS: {
                return this.matchAll(iface);
            }
            case NO_PARAMETERS: {
                return this.matchNone(iface);
            }
        }
        return this.matchAny(iface);
    }

    private boolean matchAll(T iface) {
        BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess(iface);
        for (Map.Entry<String, String> term : this.getCriteria().entrySet()) {
            String matchExpression;
            String val = BasePolicy.getPropertyValueAsString(bean, term.getKey());
            if (this.match(val, matchExpression = term.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean matchAny(T iface) {
        BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess(iface);
        for (Map.Entry<String, String> term : this.getCriteria().entrySet()) {
            String matchExpression;
            String val = BasePolicy.getPropertyValueAsString(bean, term.getKey());
            if (!this.match(val, matchExpression = term.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean matchNone(T iface) {
        return !this.matchAny(iface);
    }

    private static String getPropertyValueAsString(BeanWrapper bean, String propertyName) {
        Object value = null;
        try {
            value = bean.getPropertyValue(propertyName);
        }
        catch (BeansException e) {
            LOG.warn("Could not find property \"{}\" on object of type {}, returning null", new Object[]{propertyName, bean.getWrappedClass().getName(), e});
            return null;
        }
        try {
            return (String)bean.convertIfNecessary(value, String.class);
        }
        catch (ConversionNotSupportedException e) {
            if (value instanceof InetAddress) {
                return InetAddressUtils.toIpAddrString((InetAddress)((InetAddress)value));
            }
            throw e;
        }
    }

    public abstract T act(T var1);

    public T apply(T iface) {
        if (iface == null) {
            return null;
        }
        if (this.matches(iface)) {
            LOG.debug("Found Match {} for {}", iface, (Object)this);
            return this.act(iface);
        }
        LOG.debug("No Match Found: {} for {}", iface, (Object)this);
        return iface;
    }

    public static enum Match {
        ANY_PARAMETER,
        ALL_PARAMETERS,
        NO_PARAMETERS;

    }
}

