/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.ConnectionFactory;

public class ConnectionFactoryConnectorPoolImpl
extends ConnectionFactory {
    private NioSocketConnector m_connector;
    private final Object m_connectorMutex = new Object();
    private Integer m_port = null;
    private final Object m_portMutex = new Object();

    protected ConnectionFactoryConnectorPoolImpl(int timeoutInMillis) {
        super(timeoutInMillis);
    }

    private static final NioSocketConnector getSocketConnector(long timeout, IoHandler handler) {
        NioSocketConnector connector = new NioSocketConnector();
        connector.setHandler(handler);
        connector.setConnectTimeoutMillis(timeout);
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectFuture connect(SocketAddress remoteAddress, IoSessionInitializer<? extends ConnectFuture> init, IoHandler handler) {
        for (int retries = 0; retries < 3; ++retries) {
            Object object = this.m_connectorMutex;
            synchronized (object) {
                if (this.m_connector == null) {
                    LogUtils.debugf((Object)this, (String)"Found a null NioSocketConnector, creating a new one with timeout %d", (Object[])new Object[]{this.getTimeout()});
                    this.m_connector = ConnectionFactoryConnectorPoolImpl.getSocketConnector(this.getTimeout(), handler);
                }
                try {
                    this.m_connector.setHandler(handler);
                    InetSocketAddress localAddress = null;
                    Object object2 = this.m_portMutex;
                    synchronized (object2) {
                        if (this.m_port == null) {
                            localAddress = new InetSocketAddress(InetAddressUtils.getLocalHostAddress(), 0);
                            this.m_port = localAddress.getPort();
                        } else {
                            localAddress = new InetSocketAddress(InetAddressUtils.getLocalHostAddress(), (int)this.m_port);
                        }
                    }
                    ConnectFuture cf = this.m_connector.connect(remoteAddress, (SocketAddress)localAddress, init);
                    cf.addListener(this.portSwitcher((SocketConnector)this.m_connector, remoteAddress, init, handler));
                    return cf;
                }
                catch (Throwable e) {
                    LogUtils.debugf((Object)this, (Throwable)e, (String)"Caught exception on factory %s, retrying: %s", (Object[])new Object[]{this, e});
                    this.m_connector.dispose();
                    this.m_connector = ConnectionFactoryConnectorPoolImpl.getSocketConnector(this.getTimeout(), handler);
                    continue;
                }
            }
        }
        throw new IllegalStateException("Could not connect to socket because of excessive RejectedExecutionExceptions");
    }

    private IoFutureListener<ConnectFuture> portSwitcher(final SocketConnector connector, final SocketAddress remoteAddress, final IoSessionInitializer<? extends ConnectFuture> init, final IoHandler handler) {
        return new IoFutureListener<ConnectFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ConnectFuture future) {
                block5: {
                    try {
                        Throwable e = future.getException();
                        if (e == null || !(e instanceof BindException)) break block5;
                        Object object = ConnectionFactoryConnectorPoolImpl.this.m_portMutex;
                        synchronized (object) {
                            ConnectionFactoryConnectorPoolImpl.this.m_port = null;
                        }
                        ConnectionFactoryConnectorPoolImpl.this.connect(remoteAddress, (IoSessionInitializer<? extends ConnectFuture>)init, handler);
                    }
                    catch (RuntimeIoException e) {
                        LogUtils.debugf((Object)this, (Throwable)e, (String)"Exception of type %s caught, disposing of connector: %s", (Object[])new Object[]{((Object)((Object)e)).getClass().getName(), Thread.currentThread().getName()});
                        connector.dispose();
                    }
                }
            }
        };
    }

    @Override
    public ConnectFuture reConnect(SocketAddress remoteAddress, IoSessionInitializer<? extends ConnectFuture> init, IoHandler handler) {
        return this.connect(remoteAddress, init, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose() {
        Object object = this.m_connectorMutex;
        synchronized (object) {
            this.m_connector.dispose();
        }
    }
}

