/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.opennms.netmgt.provision.support.RequestBuilder;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;

public abstract class BasicDetector<Request, Response>
extends SyncAbstractDetector {
    private ClientConversation<Request, Response> m_conversation = new ClientConversation();

    protected BasicDetector(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    protected BasicDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isServiceDetected(InetAddress address) {
        String ipAddr = InetAddressUtils.str((InetAddress)address);
        int port = this.getPort();
        int retries = this.getRetries();
        int timeout = this.getTimeout();
        LogUtils.infof((Object)this, (String)"isServiceDetected: Checking address: %s for %s capability on port %s", (Object[])new Object[]{ipAddr, this.getServiceName(), this.getPort()});
        Client<Request, Response> client = this.getClient();
        for (int attempts = 0; attempts <= retries; ++attempts) {
            try {
                client.connect(address, port, timeout);
                LogUtils.infof((Object)this, (String)"isServiceDetected: Attempting to connect to address: %s, port: %d, attempt: #%s", (Object[])new Object[]{ipAddr, port, attempts});
                if (!this.attemptConversation(client)) continue;
                boolean bl = true;
                return bl;
            }
            catch (ConnectException e) {
                LogUtils.infof((Object)this, (Throwable)e, (String)"isServiceDetected: %s: Unable to connect to address: %s port %d, attempt #%s", (Object[])new Object[]{this.getServiceName(), ipAddr, port, attempts});
                continue;
            }
            catch (NoRouteToHostException e) {
                LogUtils.infof((Object)this, (Throwable)e, (String)"isServiceDetected: %s: No route to address %s was available", (Object[])new Object[]{this.getServiceName(), ipAddr});
                continue;
            }
            catch (InterruptedIOException e) {
                LogUtils.infof((Object)this, (Throwable)e, (String)"isServiceDetected: %s: Did not connect to to address %s port %d within timeout: %d attempt: %d", (Object[])new Object[]{this.getServiceName(), ipAddr, port, timeout, attempts});
                continue;
            }
            catch (IOException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"isServiceDetected: %s: An unexpected I/O exception occured contacting address %s port %d", (Object[])new Object[]{this.getServiceName(), ipAddr, port});
                continue;
            }
            catch (Throwable t) {
                LogUtils.errorf((Object)this, (Throwable)t, (String)"isServiceDetected: %s: Unexpected error trying to detect %s on address %s port %d", (Object[])new Object[]{this.getServiceName(), this.getServiceName(), ipAddr, port});
                continue;
            }
            finally {
                client.close();
            }
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    protected abstract Client<Request, Response> getClient();

    private boolean attemptConversation(Client<Request, Response> client) throws IOException, Exception {
        return this.getConversation().attemptConversation(client);
    }

    protected final void expectBanner(ResponseValidator<Response> bannerValidator) {
        this.getConversation().expectBanner(bannerValidator);
    }

    protected final void send(RequestBuilder<Request> requestBuilder, ResponseValidator<Response> responseValidator) {
        this.getConversation().addExchange(requestBuilder, responseValidator);
    }

    protected void send(Request request, ResponseValidator<Response> responseValidator) {
        this.getConversation().addExchange(request, responseValidator);
    }

    protected final ClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }
}

