/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ConversationExchange;
import org.opennms.netmgt.provision.support.ConversationExchangeDefaultImpl;
import org.opennms.netmgt.provision.support.RequestBuilder;
import org.opennms.netmgt.provision.support.ResponseValidator;

public class ClientConversation<Request, Response> {
    private ResponseValidator<Response> m_bannerValidator;
    private final List<ConversationExchange<Request, Response>> m_conversation = new ArrayList<ConversationExchange<Request, Response>>();

    public void expectBanner(ResponseValidator<Response> bannerValidator) {
        this.m_bannerValidator = bannerValidator;
    }

    public void addExchange(final Request request, ResponseValidator<Response> validator) {
        RequestBuilder builder = new RequestBuilder<Request>(){

            @Override
            public Request getRequest() {
                return request;
            }
        };
        this.addExchange(builder, validator);
    }

    public void addExchange(RequestBuilder<Request> requestBuilder, ResponseValidator<Response> validator) {
        this.addExchange(new ConversationExchangeDefaultImpl<Request, Response>(requestBuilder, validator));
    }

    public void addExchange(ConversationExchange<Request, Response> exchange) {
        this.m_conversation.add(exchange);
    }

    public boolean attemptConversation(Client<Request, Response> client) throws IOException, Exception {
        Response banner;
        if (this.m_bannerValidator != null && !this.m_bannerValidator.validate(banner = client.receiveBanner())) {
            LogUtils.infof((Object)this, (String)"False on Banner", (Object[])new Object[0]);
            return false;
        }
        for (ConversationExchange<Request, Response> ex : this.m_conversation) {
            Object request = ex.getRequest();
            LogUtils.infof((Object)this, (String)"Sending Request %s\n", (Object[])new Object[]{request});
            Response response = client.sendRequest(request);
            LogUtils.infof((Object)this, (String)"Received Response %s\n", (Object[])new Object[]{response});
            if (ex.validate(response)) continue;
            return false;
        }
        return true;
    }
}

