/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.events.api.EventDatabaseConstants;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.xml.event.Parm;

@Entity
@IdClass(value=OnmsEventParameterId.class)
@Table(name="event_parameters")
@XmlRootElement(name="parameter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnmsEventParameter
implements Serializable {
    private static final long serialVersionUID = 4530678411898489175L;
    @Id
    @XmlTransient
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="eventID")
    private OnmsEvent event;
    @Id
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="value")
    private String value;
    @XmlAttribute(name="type")
    private String type;
    @XmlTransient
    private int position;

    public OnmsEventParameter() {
    }

    public OnmsEventParameter(OnmsEvent event, Parm parm) {
        this.event = event;
        this.name = parm.getParmName();
        this.value = EventDatabaseConstants.escape((String)(parm.getValue().getContent() == null ? "" : parm.getValue().getContent()), (char)'=');
        this.type = parm.getValue().getType();
    }

    public OnmsEventParameter(OnmsEvent event, String name, String value, String type) {
        this.event = event;
        this.name = name;
        this.value = EventDatabaseConstants.escape((String)(value == null ? "" : value), (char)'=');
        this.type = type;
    }

    public OnmsEvent getEvent() {
        return this.event;
    }

    public void setEvent(OnmsEvent event) {
        this.event = event;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return EventDatabaseConstants.escape((String)this.value, (char)'=');
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = EventDatabaseConstants.escape((String)value, (char)'=');
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    int getPosition() {
        return this.position;
    }

    void setPosition(int position) {
        this.position = position;
    }

    public static class OnmsEventParameterId
    implements Serializable {
        private OnmsEvent event;
        private String name;

        public OnmsEventParameterId() {
        }

        public OnmsEventParameterId(OnmsEvent event, String name) {
            this.event = event;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OnmsEventParameterId)) {
                return false;
            }
            return Objects.equals(this.event, ((OnmsEventParameterId)obj).event) && Objects.equals(this.name, ((OnmsEventParameterId)obj).name);
        }

        public int hashCode() {
            return Objects.hash(this.event, this.name);
        }

        public OnmsEvent getEvent() {
            return this.event;
        }

        public void setEvent(OnmsEvent event) {
            this.event = event;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

