/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import com.google.common.base.Strings;
import java.util.Date;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

public class NodeLabelChangedEventBuilder
extends EventBuilder {
    public NodeLabelChangedEventBuilder(String source) {
        super("uei.opennms.org/nodes/nodeLabelChanged", source, new Date());
    }

    @Override
    public Event getEvent() {
        Event event = super.getEvent();
        this.checkParam(event, "oldNodeLabel");
        this.checkParam(event, "newNodeLabel");
        return event;
    }

    private void checkParam(Event event, String name) {
        Parm param = event.getParm(name);
        if (param == null || param.getValue() == null || Strings.isNullOrEmpty((String)Strings.nullToEmpty((String)param.getValue().toString()).trim())) {
            throw new IllegalStateException("NodeLabelChangedEvent is not ready to be build, parameter " + name + " is missing.");
        }
    }

    public NodeLabelChangedEventBuilder setOldNodeLabel(String oldNodeLabel) {
        this.setParam("oldNodeLabel", oldNodeLabel);
        return this;
    }

    public NodeLabelChangedEventBuilder setNewNodeLabel(String newNodeLabel) {
        this.setParam("newNodeLabel", newNodeLabel);
        return this;
    }

    public NodeLabelChangedEventBuilder setOldNodeLabelSource(String oldNodeLabelSource) {
        this.setParam("oldNodeLabelSource", oldNodeLabelSource);
        return this;
    }

    public NodeLabelChangedEventBuilder setNewNodeLabelSource(String newNodeLabelSource) {
        this.setParam("newNodeLabelSource", newNodeLabelSource);
        return this;
    }

    @Override
    protected void checkForIllegalUei() {
    }
}

