/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Type;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.NodeIdAdapter;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.events.AddEventVisitor;
import org.opennms.netmgt.model.events.DeleteEventVisitor;

@XmlRootElement(name="ipInterface")
@Entity
@Table(name="ipInterface")
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsIpInterface
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = 8463903013592837114L;
    private Integer m_id;
    private InetAddress m_ipAddress;
    private InetAddress m_netMask;
    private String m_ipHostName;
    private String m_isManaged;
    private PrimaryType m_isSnmpPrimary = PrimaryType.NOT_ELIGIBLE;
    private Date m_ipLastCapsdPoll;
    private OnmsNode m_node;
    private Set<OnmsMonitoredService> m_monitoredServices = new LinkedHashSet<OnmsMonitoredService>();
    private OnmsSnmpInterface m_snmpInterface;
    private List<OnmsMetaData> m_metaData = new ArrayList<OnmsMetaData>();

    public OnmsIpInterface() {
    }

    public OnmsIpInterface(String ipAddr, OnmsNode node) {
        this(InetAddressUtils.getInetAddress((String)ipAddr), node);
    }

    public OnmsIpInterface(InetAddress ipAddr, OnmsNode node) {
        this.m_ipAddress = ipAddr;
        this.m_node = node;
        if (node != null) {
            node.getIpInterfaces().add(this);
        }
    }

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId() == null ? null : this.getId().toString();
    }

    public void setInterfaceId(String id) {
        this.setId(Integer.valueOf(id));
    }

    @Transient
    @XmlAttribute(name="hasFlows")
    public boolean getHasFlows() {
        if (this.m_snmpInterface == null) {
            return false;
        }
        return this.m_snmpInterface.getHasFlows();
    }

    @Transient
    @XmlTransient
    public String getIpAddressAsString() {
        return InetAddressUtils.toIpAddrString((InetAddress)this.m_ipAddress);
    }

    @Transient
    @XmlAttribute(name="ifIndex")
    public Integer getIfIndex() {
        if (this.m_snmpInterface == null) {
            return null;
        }
        return this.m_snmpInterface.getIfIndex();
    }

    public void setIfIndex(Integer ifindex) {
        if (this.m_snmpInterface == null) {
            throw new IllegalStateException("Cannot set ifIndex if snmpInterface relation isn't setup");
        }
        this.m_snmpInterface.setIfIndex(ifindex);
    }

    @Column(name="ipHostName", length=256)
    @XmlElement(name="hostName")
    public String getIpHostName() {
        return this.m_ipHostName;
    }

    public void setIpHostName(String iphostname) {
        this.m_ipHostName = iphostname;
    }

    @Column(name="isManaged", length=1)
    @XmlAttribute(name="isManaged")
    public String getIsManaged() {
        return this.m_isManaged;
    }

    public void setIsManaged(String ismanaged) {
        this.m_isManaged = ismanaged;
    }

    @Transient
    @XmlTransient
    public boolean isManaged() {
        return "M".equals(this.getIsManaged());
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ipLastCapsdPoll")
    @XmlElement(name="lastCapsdPoll")
    public Date getIpLastCapsdPoll() {
        return this.m_ipLastCapsdPoll;
    }

    public void setIpLastCapsdPoll(Date iplastcapsdpoll) {
        this.m_ipLastCapsdPoll = iplastcapsdpoll;
    }

    @Transient
    @XmlAttribute(name="snmpPrimary")
    public String getPrimaryString() {
        return this.m_isSnmpPrimary == null ? null : this.m_isSnmpPrimary.toString();
    }

    public void setPrimaryString(String primaryType) {
        this.m_isSnmpPrimary = new PrimaryType(primaryType.charAt(0));
    }

    @Column(name="isSnmpPrimary", length=1)
    @XmlTransient
    public PrimaryType getIsSnmpPrimary() {
        return this.m_isSnmpPrimary;
    }

    public void setIsSnmpPrimary(PrimaryType issnmpprimary) {
        this.m_isSnmpPrimary = issnmpprimary;
    }

    @Transient
    @XmlTransient
    public boolean isPrimary() {
        return this.m_isSnmpPrimary.equals(PrimaryType.PRIMARY);
    }

    @JsonIgnore
    @XmlTransient
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="ipInterface_metadata", joinColumns={@JoinColumn(name="id")})
    public List<OnmsMetaData> getMetaData() {
        return this.m_metaData;
    }

    public void setMetaData(List<OnmsMetaData> metaData) {
        this.m_metaData = metaData;
    }

    public void addMetaData(String context, String key, String value) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Optional<OnmsMetaData> entry = this.getMetaData().stream().filter(m -> m.getContext().equals(context)).filter(m -> m.getKey().equals(key)).findFirst();
        if (entry.isPresent()) {
            entry.get().setValue(value);
        } else {
            this.getMetaData().add(new OnmsMetaData(context, key, value));
        }
    }

    public void removeMetaData(String context, String key) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(key);
        Iterator<OnmsMetaData> iterator = this.getMetaData().iterator();
        while (iterator.hasNext()) {
            OnmsMetaData onmsNodeMetaData = iterator.next();
            if (!context.equals(onmsNodeMetaData.getContext()) || !key.equals(onmsNodeMetaData.getKey())) continue;
            iterator.remove();
        }
    }

    public void removeMetaData(String context) {
        Objects.requireNonNull(context);
        Iterator<OnmsMetaData> iterator = this.getMetaData().iterator();
        while (iterator.hasNext()) {
            OnmsMetaData onmsNodeMetaData = iterator.next();
            if (!context.equals(onmsNodeMetaData.getContext())) continue;
            iterator.remove();
        }
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlJavaTypeAdapter(value=NodeIdAdapter.class)
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Transient
    @XmlTransient
    public Integer getNodeId() {
        if (this.m_node != null) {
            return this.m_node.getId();
        }
        return null;
    }

    @XmlTransient
    @OneToMany(mappedBy="ipInterface", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    public Set<OnmsMonitoredService> getMonitoredServices() {
        return this.m_monitoredServices;
    }

    public void setMonitoredServices(Set<OnmsMonitoredService> ifServices) {
        this.m_monitoredServices = ifServices;
    }

    @Transient
    @JsonIgnore
    public void addMonitoredService(OnmsMonitoredService svc) {
        this.m_monitoredServices.add(svc);
    }

    public void removeMonitoredService(OnmsMonitoredService svc) {
        this.m_monitoredServices.remove(svc);
    }

    @XmlElement(name="snmpInterface")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="snmpInterfaceId")
    public OnmsSnmpInterface getSnmpInterface() {
        return this.m_snmpInterface;
    }

    public void setSnmpInterface(OnmsSnmpInterface snmpInterface) {
        this.m_snmpInterface = snmpInterface;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.m_id).add("ipAddr", (Object)InetAddressUtils.str((InetAddress)this.m_ipAddress)).add("netMask", (Object)InetAddressUtils.str((InetAddress)this.m_netMask)).add("ipHostName", (Object)this.m_ipHostName).add("isManaged", (Object)this.m_isManaged).add("isSnmpPrimary", (Object)this.m_isSnmpPrimary).add("ipLastCapsdPoll", (Object)this.m_ipLastCapsdPoll).add("nodeId", (Object)this.getNodeId()).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        visitor.visitIpInterface(this);
        for (OnmsMonitoredService monSvc : this.getMonitoredServices()) {
            monSvc.visit(visitor);
        }
        visitor.visitIpInterfaceComplete(this);
    }

    @Column(name="ipAddr")
    @XmlElement(name="ipAddress")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(InetAddress ipaddr) {
        this.m_ipAddress = ipaddr;
    }

    @Column(name="netmask")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getNetMask() {
        return this.m_netMask;
    }

    public void setNetMask(InetAddress netMask) {
        this.m_netMask = netMask;
    }

    @Transient
    @XmlAttribute(name="isDown")
    public boolean isDown() {
        boolean down = true;
        for (OnmsMonitoredService svc : this.m_monitoredServices) {
            if (svc.isDown()) continue;
            return !down;
        }
        return down;
    }

    @Transient
    @XmlAttribute
    public int getMonitoredServiceCount() {
        return this.m_monitoredServices.size();
    }

    @JsonIgnore
    public OnmsMonitoredService getMonitoredServiceByServiceType(String svcName) {
        for (OnmsMonitoredService monSvc : this.getMonitoredServices()) {
            if (!monSvc.getServiceType().getName().equals(svcName)) continue;
            return monSvc;
        }
        return null;
    }

    public void mergeInterfaceAttributes(OnmsIpInterface scannedIface) {
        if (OnmsIpInterface.hasNewValue(scannedIface.getIfIndex(), this.getIfIndex())) {
            this.setIfIndex(scannedIface.getIfIndex());
        }
        if (OnmsIpInterface.hasNewValue(scannedIface.getNetMask(), this.getNetMask())) {
            this.setNetMask(scannedIface.getNetMask());
        }
        if (OnmsIpInterface.hasNewValue(scannedIface.getIsManaged(), this.getIsManaged())) {
            this.setIsManaged(scannedIface.getIsManaged());
        }
        if (OnmsIpInterface.hasNewCollectionTypeValue(scannedIface.getIsSnmpPrimary(), this.getIsSnmpPrimary())) {
            this.setIsSnmpPrimary(scannedIface.getIsSnmpPrimary());
        }
        if (OnmsIpInterface.hasNewValue(scannedIface.getIpHostName(), this.getIpHostName())) {
            this.setIpHostName(scannedIface.getIpHostName());
        }
        if (OnmsIpInterface.hasNewValue(scannedIface.getIpLastCapsdPoll(), this.getIpLastCapsdPoll())) {
            this.setIpLastCapsdPoll(scannedIface.getIpLastCapsdPoll());
        }
    }

    protected static boolean hasNewCollectionTypeValue(PrimaryType newVal, PrimaryType existingVal) {
        return newVal != null && !newVal.equals(existingVal) && newVal != PrimaryType.NOT_ELIGIBLE;
    }

    public void mergeMonitoredServices(OnmsIpInterface scannedIface, EventForwarder eventForwarder, boolean deleteMissing) {
        HashMap<OnmsServiceType, OnmsMonitoredService> serviceTypeMap = new HashMap<OnmsServiceType, OnmsMonitoredService>();
        for (OnmsMonitoredService svc : scannedIface.getMonitoredServices()) {
            serviceTypeMap.put(svc.getServiceType(), svc);
        }
        Iterator<OnmsMonitoredService> it = this.getMonitoredServices().iterator();
        while (it.hasNext()) {
            OnmsMonitoredService svc;
            svc = it.next();
            OnmsMonitoredService imported = (OnmsMonitoredService)serviceTypeMap.get(svc.getServiceType());
            if (imported == null) {
                if (deleteMissing) {
                    it.remove();
                    svc.visit(new DeleteEventVisitor(eventForwarder));
                }
            } else {
                svc.mergeServiceAttributes(imported);
                svc.mergeMetaData(imported);
            }
            serviceTypeMap.remove(svc.getServiceType());
        }
        Collection newServices = serviceTypeMap.values();
        for (OnmsMonitoredService svc : newServices) {
            svc.setIpInterface(this);
            this.getMonitoredServices().add(svc);
            svc.visit(new AddEventVisitor(eventForwarder));
        }
    }

    public void mergeMetaData(OnmsIpInterface scanned) {
        if (!this.getMetaData().equals(scanned.getMetaData())) {
            this.setMetaData(scanned.getMetaData());
        }
    }

    public void updateSnmpInterface(OnmsIpInterface scannedIface) {
        if (!OnmsIpInterface.hasNewValue(scannedIface.getIfIndex(), this.getIfIndex())) {
            return;
        }
        if (scannedIface.getSnmpInterface() == null) {
            this.setSnmpInterface(null);
        } else {
            OnmsSnmpInterface snmpIface = this.getNode().getSnmpInterfaceWithIfIndex(scannedIface.getIfIndex());
            this.setSnmpInterface(snmpIface);
        }
    }

    public void mergeInterface(OnmsIpInterface scannedIface, EventForwarder eventForwarder, boolean deleteMissing) {
        this.updateSnmpInterface(scannedIface);
        this.mergeInterfaceAttributes(scannedIface);
        this.mergeMonitoredServices(scannedIface, eventForwarder, deleteMissing);
        this.mergeMetaData(scannedIface);
    }

    @Transient
    @XmlTransient
    @JsonIgnore
    public String getForeignSource() {
        if (this.getNode() != null) {
            return this.getNode().getForeignSource();
        }
        return null;
    }

    @Transient
    @XmlTransient
    @JsonIgnore
    public String getForeignId() {
        if (this.getNode() != null) {
            return this.getNode().getForeignId();
        }
        return null;
    }
}

