/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.opennms.netmgt.model.HwEntityAttributeType;
import org.opennms.netmgt.model.OnmsHwEntity;

@XmlRootElement(name="hwEntityAttribute")
@Entity
@Table(name="hwEntityAttribute")
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsHwEntityAttribute
implements Serializable,
Comparable<OnmsHwEntityAttribute> {
    private static final long serialVersionUID = 468469978315437731L;
    private Integer m_id;
    private HwEntityAttributeType m_attributeType = new HwEntityAttributeType();
    private String m_attributeValue;
    private OnmsHwEntity m_hwEntity;

    public OnmsHwEntityAttribute() {
    }

    public OnmsHwEntityAttribute(HwEntityAttributeType type, String value) {
        this.m_attributeType = type;
        this.m_attributeValue = value;
    }

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="hwEntityId")
    @XmlTransient
    public OnmsHwEntity getHwEntity() {
        return this.m_hwEntity;
    }

    public void setHwEntity(OnmsHwEntity hwEntity) {
        this.m_hwEntity = hwEntity;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="hwAttribTypeId")
    @XmlTransient
    public HwEntityAttributeType getType() {
        return this.m_attributeType;
    }

    public void setType(HwEntityAttributeType attributeType) {
        this.m_attributeType = attributeType;
    }

    @Transient
    @XmlAttribute(name="name")
    public String getTypeName() {
        return this.m_attributeType.getName();
    }

    public void setTypeName(String typeName) {
        this.m_attributeType.setName(typeName);
    }

    @Transient
    @XmlAttribute(name="oid")
    public String getTypeOid() {
        return this.m_attributeType.getOid();
    }

    public void setTypeOid(String typeOid) {
        this.m_attributeType.setOid(typeOid);
    }

    @Transient
    @XmlAttribute(name="class")
    public String getTypeClass() {
        return this.m_attributeType.getAttributeClass();
    }

    public void setTypeClass(String typeClass) {
        this.m_attributeType.setAttributeClass(typeClass);
    }

    @Column(name="attribValue")
    @XmlAttribute(name="value")
    public String getValue() {
        return this.m_attributeValue;
    }

    public void setValue(String attributeValue) {
        this.m_attributeValue = attributeValue;
    }

    public String toString() {
        return new ToStringBuilder((Object)this.getClass().getSimpleName(), ToStringStyle.SHORT_PREFIX_STYLE).append("entPhysicalIndex", this.m_hwEntity == null ? null : this.m_hwEntity.getEntPhysicalIndex()).append("type", (Object)this.m_attributeType).append("value", (Object)this.m_attributeValue).toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof OnmsHwEntityAttribute) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    @Override
    public int compareTo(OnmsHwEntityAttribute o) {
        return this.getTypeName().compareTo(o.getTypeName());
    }
}

