/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.OnmsMonitoringSystem;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="event")
@Entity
@Table(name="events")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsEvent
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = -7412025003474162992L;
    private Integer m_eventId;
    private String m_eventUei;
    private Date m_eventTime;
    private String m_eventHost;
    private String m_eventSource;
    private InetAddress m_ipAddr;
    private OnmsMonitoringSystem m_distPoller;
    private String m_eventSnmpHost;
    private OnmsServiceType m_serviceType;
    private String m_eventSnmp;
    private List<OnmsEventParameter> m_eventParameters;
    private Date m_eventCreateTime;
    private String m_eventDescr;
    private String m_eventLogGroup;
    private String m_eventLogMsg;
    private Integer m_eventSeverity;
    private Integer m_ifIndex;
    private String m_eventPathOutage;
    private String m_eventCorrelation;
    private Integer m_eventSuppressedCount;
    private String m_eventOperInstruct;
    private String m_eventAutoAction;
    private String m_eventOperAction;
    private String m_eventOperActionMenuText;
    private String m_eventNotification;
    private String m_eventTTicket;
    private Integer m_eventTTicketState;
    private String m_eventForward;
    private String m_eventMouseOverText;
    private String m_eventLog;
    private String m_eventDisplay;
    private String m_eventAckUser;
    private Date m_eventAckTime;
    private OnmsAlarm m_alarm;
    private OnmsNode m_node;
    private Set<OnmsNotification> m_notifications = new HashSet<OnmsNotification>();
    private Set<OnmsOutage> m_associatedServiceRegainedOutages = new HashSet<OnmsOutage>();
    private Set<OnmsOutage> m_associatedServiceLostOutages = new HashSet<OnmsOutage>();

    @Id
    @XmlAttribute(name="id")
    @Column(name="eventId", nullable=false)
    @SequenceGenerator(name="eventSequence", sequenceName="eventsNxtId")
    @GeneratedValue(generator="eventSequence")
    public Integer getId() {
        return this.m_eventId;
    }

    public void setId(Integer eventid) {
        this.m_eventId = eventid;
    }

    @XmlElement(name="uei")
    @Column(name="eventUei", length=256, nullable=false)
    public String getEventUei() {
        return this.m_eventUei;
    }

    public void setEventUei(String eventuei) {
        this.m_eventUei = eventuei;
    }

    @XmlElement(name="time")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="eventTime", nullable=false)
    public Date getEventTime() {
        return this.m_eventTime;
    }

    public void setEventTime(Date eventtime) {
        this.m_eventTime = eventtime;
    }

    @XmlElement(name="host")
    @Column(name="eventHost", length=256)
    public String getEventHost() {
        return this.m_eventHost;
    }

    public void setEventHost(String eventhost) {
        this.m_eventHost = eventhost;
    }

    @XmlElement(name="source")
    @Column(name="eventSource", length=128, nullable=false)
    public String getEventSource() {
        return this.m_eventSource;
    }

    public void setEventSource(String eventsource) {
        this.m_eventSource = eventsource;
    }

    @Column(name="ipAddr")
    @XmlElement(name="ipAddress")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getIpAddr() {
        return this.m_ipAddr;
    }

    public void setIpAddr(InetAddress ipaddr) {
        this.m_ipAddr = ipaddr;
    }

    @XmlTransient
    @ManyToOne
    @JoinColumn(name="systemId", nullable=false)
    public OnmsMonitoringSystem getDistPoller() {
        return this.m_distPoller;
    }

    public void setDistPoller(OnmsMonitoringSystem distPoller) {
        this.m_distPoller = distPoller;
    }

    @XmlElement(name="snmpHost")
    @Column(name="eventSnmpHost", length=256)
    public String getEventSnmpHost() {
        return this.m_eventSnmpHost;
    }

    public void setEventSnmpHost(String eventsnmphost) {
        this.m_eventSnmpHost = eventsnmphost;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="serviceId", nullable=true)
    public OnmsServiceType getServiceType() {
        return this.m_serviceType;
    }

    public void setServiceType(OnmsServiceType serviceType) {
        this.m_serviceType = serviceType;
    }

    @XmlElement(name="snmp")
    @Column(name="eventSnmp", length=256)
    public String getEventSnmp() {
        return this.m_eventSnmp;
    }

    public void setEventSnmp(String eventsnmp) {
        this.m_eventSnmp = eventsnmp;
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    @OneToMany(mappedBy="event", cascade={CascadeType.ALL})
    public List<OnmsEventParameter> getEventParameters() {
        return this.m_eventParameters;
    }

    public void setEventParameters(List<OnmsEventParameter> eventParameters) {
        this.m_eventParameters = eventParameters;
    }

    public void setEventParametersFromEvent(Event event) {
        this.m_eventParameters = EventParameterUtils.normalize((List)event.getParmCollection()).values().stream().map(p -> new OnmsEventParameter(this, (Parm)p)).collect(Collectors.toList());
    }

    public void addEventParameter(OnmsEventParameter parameter) {
        if (this.m_eventParameters == null) {
            this.m_eventParameters = new ArrayList<OnmsEventParameter>();
        }
        if (this.m_eventParameters.contains(parameter)) {
            this.m_eventParameters.remove(parameter);
        }
        this.m_eventParameters.add(parameter);
    }

    @XmlElement(name="createTime")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="eventCreateTime", nullable=false)
    public Date getEventCreateTime() {
        return this.m_eventCreateTime;
    }

    public void setEventCreateTime(Date eventcreatetime) {
        this.m_eventCreateTime = eventcreatetime;
    }

    @XmlElement(name="description")
    @Column(name="eventDescr", length=4000)
    public String getEventDescr() {
        return this.m_eventDescr;
    }

    public void setEventDescr(String eventdescr) {
        this.m_eventDescr = eventdescr;
    }

    @XmlElement(name="logGroup")
    @Column(name="eventLogGroup", length=32)
    public String getEventLogGroup() {
        return this.m_eventLogGroup;
    }

    public void setEventLogGroup(String eventloggroup) {
        this.m_eventLogGroup = eventloggroup;
    }

    @XmlElement(name="logMessage")
    @Column(name="eventLogMsg", length=1024)
    public String getEventLogMsg() {
        return this.m_eventLogMsg;
    }

    public void setEventLogMsg(String eventlogmsg) {
        this.m_eventLogMsg = eventlogmsg;
    }

    @XmlTransient
    @Column(name="eventSeverity", nullable=false)
    public Integer getEventSeverity() {
        return this.m_eventSeverity;
    }

    public void setEventSeverity(Integer severity) {
        this.m_eventSeverity = severity;
    }

    @Transient
    @XmlAttribute(name="severity")
    public String getSeverityLabel() {
        return OnmsSeverity.get(this.m_eventSeverity).name();
    }

    public void setSeverityLabel(String label) {
        this.m_eventSeverity = OnmsSeverity.get(label).getId();
    }

    @XmlElement(name="pathOutage")
    @Column(name="eventPathOutage", length=1024)
    public String getEventPathOutage() {
        return this.m_eventPathOutage;
    }

    public void setEventPathOutage(String eventpathoutage) {
        this.m_eventPathOutage = eventpathoutage;
    }

    @XmlElement(name="correlation")
    @Column(name="eventCorrelation", length=1024)
    public String getEventCorrelation() {
        return this.m_eventCorrelation;
    }

    public void setEventCorrelation(String eventcorrelation) {
        this.m_eventCorrelation = eventcorrelation;
    }

    @XmlElement(name="suppressedCount")
    @Column(name="eventSuppressedCount")
    public Integer getEventSuppressedCount() {
        return this.m_eventSuppressedCount;
    }

    public void setEventSuppressedCount(Integer eventsuppressedcount) {
        this.m_eventSuppressedCount = eventsuppressedcount;
    }

    @XmlElement(name="operatorInstructions")
    @Column(name="eventOperInstruct")
    public String getEventOperInstruct() {
        return this.m_eventOperInstruct;
    }

    public void setEventOperInstruct(String eventoperinstruct) {
        this.m_eventOperInstruct = eventoperinstruct;
    }

    @XmlElement(name="autoAction")
    @Column(name="eventAutoAction", length=256)
    public String getEventAutoAction() {
        return this.m_eventAutoAction;
    }

    public void setEventAutoAction(String eventautoaction) {
        this.m_eventAutoAction = eventautoaction;
    }

    @XmlElement(name="operatorAction")
    @Column(name="eventOperAction", length=256)
    public String getEventOperAction() {
        return this.m_eventOperAction;
    }

    public void setEventOperAction(String eventoperaction) {
        this.m_eventOperAction = eventoperaction;
    }

    @XmlElement(name="operationActionMenuText")
    @Column(name="eventOperActionMenuText", length=64)
    public String getEventOperActionMenuText() {
        return this.m_eventOperActionMenuText;
    }

    public void setEventOperActionMenuText(String eventOperActionMenuText) {
        this.m_eventOperActionMenuText = eventOperActionMenuText;
    }

    @XmlElement(name="notification")
    @Column(name="eventNotification", length=128)
    public String getEventNotification() {
        return this.m_eventNotification;
    }

    public void setEventNotification(String eventnotification) {
        this.m_eventNotification = eventnotification;
    }

    @XmlElement(name="troubleTicket")
    @Column(name="eventTTicket", length=128)
    public String getEventTTicket() {
        return this.m_eventTTicket;
    }

    public void setEventTTicket(String eventtticket) {
        this.m_eventTTicket = eventtticket;
    }

    @XmlElement(name="troubleTicketState")
    @Column(name="eventTTicketState")
    public Integer getEventTTicketState() {
        return this.m_eventTTicketState;
    }

    public void setEventTTicketState(Integer eventtticketstate) {
        this.m_eventTTicketState = eventtticketstate;
    }

    @XmlTransient
    @Column(name="eventForward", length=256)
    public String getEventForward() {
        return this.m_eventForward;
    }

    public void setEventForward(String eventforward) {
        this.m_eventForward = eventforward;
    }

    @XmlElement(name="mouseOverText")
    @Column(name="eventMouseOverText", length=64)
    public String getEventMouseOverText() {
        return this.m_eventMouseOverText;
    }

    public void setEventMouseOverText(String eventmouseovertext) {
        this.m_eventMouseOverText = eventmouseovertext;
    }

    @XmlAttribute(name="log")
    @Column(name="eventLog", length=1, nullable=false)
    public String getEventLog() {
        return this.m_eventLog;
    }

    public void setEventLog(String eventlog) {
        this.m_eventLog = eventlog;
    }

    @XmlAttribute(name="display")
    @Column(name="eventDisplay", length=1, nullable=false)
    public String getEventDisplay() {
        return this.m_eventDisplay;
    }

    public void setEventDisplay(String eventdisplay) {
        this.m_eventDisplay = eventdisplay;
    }

    @XmlElement(name="ackUser")
    @Column(name="eventAckUser", length=256)
    public String getEventAckUser() {
        return this.m_eventAckUser;
    }

    public void setEventAckUser(String eventackuser) {
        this.m_eventAckUser = eventackuser;
    }

    @XmlElement(name="ackTime")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="eventAckTime")
    public Date getEventAckTime() {
        return this.m_eventAckTime;
    }

    public void setEventAckTime(Date eventacktime) {
        this.m_eventAckTime = eventacktime;
    }

    @XmlTransient
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="alarmId")
    public OnmsAlarm getAlarm() {
        return this.m_alarm;
    }

    public void setAlarm(OnmsAlarm alarm) {
        this.m_alarm = alarm;
    }

    @XmlTransient
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    @Transient
    @XmlElement(name="nodeId")
    public Integer getNodeId() {
        try {
            return this.m_node != null ? this.m_node.getId() : null;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    @Transient
    @XmlElement(name="nodeLabel", required=false)
    public String getNodeLabel() {
        try {
            if (this.m_node == null) {
                return null;
            }
            return this.m_node.getLabel();
        }
        catch (ObjectNotFoundException e) {
            return "";
        }
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlTransient
    @OneToMany(mappedBy="event", fetch=FetchType.LAZY)
    public Set<OnmsNotification> getNotifications() {
        return this.m_notifications;
    }

    public void setNotifications(Set<OnmsNotification> notifications) {
        this.m_notifications = notifications;
    }

    @XmlTransient
    @OneToMany(mappedBy="serviceRegainedEvent", fetch=FetchType.LAZY)
    public Set<OnmsOutage> getAssociatedServiceRegainedOutages() {
        return this.m_associatedServiceRegainedOutages;
    }

    public void setAssociatedServiceRegainedOutages(Set<OnmsOutage> outagesBySvcregainedeventid) {
        this.m_associatedServiceRegainedOutages = outagesBySvcregainedeventid;
    }

    @XmlTransient
    @OneToMany(mappedBy="serviceLostEvent", fetch=FetchType.LAZY)
    public Set<OnmsOutage> getAssociatedServiceLostOutages() {
        return this.m_associatedServiceLostOutages;
    }

    public void setAssociatedServiceLostOutages(Set<OnmsOutage> outagesBySvclosteventid) {
        this.m_associatedServiceLostOutages = outagesBySvclosteventid;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("eventid", (Object)this.getId()).append("eventuei", (Object)this.getEventUei()).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        throw new RuntimeException("visitor method not implemented");
    }

    @Column(name="ifIndex")
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.m_ifIndex = ifIndex;
    }
}

