/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BridgeForwardingTable;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BridgePortWithMacs;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.opennms.netmgt.model.topology.Topology;

public class BroadcastDomain
implements Topology {
    public static int maxlevel = 30;
    public static final int DOMAIN_MATCH_MIN_SIZE = 20;
    public static final float DOMAIN_MATCH_MIN_RATIO = 0.5f;
    private volatile Set<Bridge> m_bridges = new HashSet<Bridge>();
    private volatile List<SharedSegment> m_topology = new ArrayList<SharedSegment>();
    private volatile Set<BridgePortWithMacs> m_forwarding = new HashSet<BridgePortWithMacs>();

    public static void addforwarders(BroadcastDomain domain, BridgeForwardingTable bridgeFT) {
        HashSet<String> macs = new HashSet<String>(domain.getMacsOnSegments());
        domain.cleanForwarders(bridgeFT.getNodeId());
        for (String forward : bridgeFT.getMactoport().keySet()) {
            if (macs.contains(forward)) continue;
            domain.addForwarding(bridgeFT.getMactoport().get(forward), forward);
        }
    }

    public static boolean checkMacSets(Set<String> setA, Set<String> setB) {
        HashSet<String> retainedSet = new HashSet<String>(setB);
        retainedSet.retainAll(setA);
        return retainedSet.size() > 20 || (float)retainedSet.size() > (float)setA.size() * 0.5f || (float)retainedSet.size() > (float)setB.size() * 0.5f;
    }

    public static Bridge electRootBridge(BroadcastDomain domain) throws BridgeTopologyException {
        if (domain.getBridges().size() == 1) {
            return domain.getBridges().iterator().next();
        }
        for (Bridge electable : domain.getBridges()) {
            if (electable.getDesignated() == null) continue;
            return BroadcastDomain.getUpperBridge(domain, electable, 0);
        }
        return null;
    }

    public static Bridge getUpperBridge(BroadcastDomain domain, Bridge electableroot, int level) throws BridgeTopologyException {
        if (level == maxlevel) {
            throw new BridgeTopologyException("getUpperBridge, too many iterations", electableroot);
        }
        for (Bridge electable : domain.getBridges()) {
            if (!electable.getIdentifiers().contains(electableroot.getDesignated())) continue;
            return BroadcastDomain.getUpperBridge(domain, electable, ++level);
        }
        return electableroot;
    }

    public static Map<Integer, Integer> getUpperForwardingBridgePorts(BroadcastDomain domain, Bridge bridge, Map<Integer, Integer> downports, int level) throws BridgeTopologyException {
        if (level == maxlevel) {
            throw new BridgeTopologyException("getUpperForwardingBridgePorts: too many iteration", bridge);
        }
        if (bridge.isRootBridge()) {
            return downports;
        }
        SharedSegment upSegment = domain.getSharedSegment(bridge.getNodeId(), bridge.getRootPort());
        if (upSegment == null) {
            throw new BridgeTopologyException("getUpperForwardingBridgePorts: no up segment", bridge);
        }
        Bridge upBridge = domain.getBridge(upSegment.getDesignatedBridge());
        if (upBridge == null) {
            throw new BridgeTopologyException("getUpperForwardingBridgePorts: no designated bridge on segment", bridge);
        }
        BridgePort bp = upSegment.getBridgePort(upBridge.getNodeId());
        downports.put(bp.getNodeId(), bp.getBridgePort());
        return BroadcastDomain.getUpperForwardingBridgePorts(domain, upBridge, downports, ++level);
    }

    public static Set<BridgeForwardingTableEntry> calculateBFT(BroadcastDomain domain, Bridge bridge) throws BridgeTopologyException {
        if (domain == null) {
            throw new BridgeTopologyException("calculateBFT: domain cannot be null");
        }
        if (bridge == null) {
            throw new BridgeTopologyException("calculateBFT: bridge cannot be null", domain);
        }
        Integer bridgeId = bridge.getNodeId();
        if (bridgeId == null) {
            throw new BridgeTopologyException("calculateBFT: bridge Id cannot be null", bridge);
        }
        HashMap bft = new HashMap();
        HashMap<Integer, BridgePort> portifindexmap = new HashMap<Integer, BridgePort>();
        Map<Integer, Integer> upperForwardingBridgePorts = BroadcastDomain.getUpperForwardingBridgePorts(domain, bridge, new HashMap<Integer, Integer>(), 0);
        HashMap<Integer, Integer> bridgeIdtobridgePortOnBridge = new HashMap<Integer, Integer>();
        for (Integer n : upperForwardingBridgePorts.keySet()) {
            bridgeIdtobridgePortOnBridge.put(n, bridge.getRootPort());
        }
        for (SharedSegment sharedSegment : domain.getSharedSegments()) {
            Integer bridgeport = null;
            if (sharedSegment.getBridgeIdsOnSegment().contains(bridgeId)) {
                BridgePort bport = sharedSegment.getBridgePort(bridgeId);
                portifindexmap.put(bport.getBridgePort(), bport);
                bridgeport = bport.getBridgePort();
            } else {
                bridgeport = BroadcastDomain.getCalculateBFT(domain, sharedSegment, bridge, bridgeIdtobridgePortOnBridge, new HashSet<Integer>(), 0);
            }
            if (!bft.containsKey(bridgeport)) {
                bft.put(bridgeport, new HashSet());
            }
            ((Set)bft.get(bridgeport)).addAll(sharedSegment.getMacsOnSegment());
        }
        ArrayList<BridgePortWithMacs> links = new ArrayList<BridgePortWithMacs>(domain.getForwarders(bridgeId));
        for (Integer bridgePort : bft.keySet()) {
            BridgePortWithMacs link = BridgePortWithMacs.create((BridgePort)portifindexmap.get(bridgePort), (Set)bft.get(bridgePort));
            links.add(link);
        }
        HashSet<BridgeForwardingTableEntry> hashSet = new HashSet<BridgeForwardingTableEntry>();
        links.stream().filter(bfti -> bfti.getMacs().size() > 0).forEach(bfti -> entries.addAll(BridgeForwardingTableEntry.get(bfti)));
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer getCalculateBFT(BroadcastDomain domain, SharedSegment segment, Bridge bridge, Map<Integer, Integer> bridgetobridgeport, Set<Integer> downBridgeIds, int level) throws BridgeTopologyException {
        void var7_12;
        if (level == maxlevel) {
            throw new BridgeTopologyException("getCalculateBFT: too many iteration", domain);
        }
        for (Integer n : segment.getBridgeIdsOnSegment()) {
            if (!bridgetobridgeport.containsKey(n)) continue;
            Integer bridgeport = bridgetobridgeport.get(n);
            for (Integer bridgeidonsegment : downBridgeIds) {
                bridgetobridgeport.put(bridgeidonsegment, bridgeport);
            }
            return bridgeport;
        }
        Integer upBridgeId = segment.getDesignatedBridge();
        if (upBridgeId.intValue() == bridge.getNodeId().intValue()) {
            for (Integer bridgeidonsegment : downBridgeIds) {
                bridgetobridgeport.put(bridgeidonsegment, segment.getDesignatedPort().getBridgePort());
            }
            return segment.getDesignatedPort().getBridgePort();
        }
        if (upBridgeId.intValue() == domain.getRootBridge().getNodeId().intValue()) {
            for (Integer bridgeidonsegment : downBridgeIds) {
                bridgetobridgeport.put(bridgeidonsegment, bridge.getRootPort());
            }
            return bridge.getRootPort();
        }
        downBridgeIds.addAll(segment.getBridgeIdsOnSegment());
        Object var7_10 = null;
        for (Bridge cbridge : domain.getBridges()) {
            if (cbridge.getNodeId().intValue() == bridge.getNodeId().intValue() || cbridge.getNodeId().intValue() != upBridgeId.intValue()) continue;
            Bridge bridge2 = cbridge;
            break;
        }
        if (var7_12 == null) {
            throw new BridgeTopologyException("getCalculateBFT: cannot find up bridge on domain", domain);
        }
        SharedSegment up = domain.getSharedSegment(var7_12.getNodeId(), var7_12.getRootPort());
        if (up == null) {
            throw new BridgeTopologyException("getCalculateBFT: cannot find up segment on domain", domain);
        }
        return BroadcastDomain.getCalculateBFT(domain, up, bridge, bridgetobridgeport, downBridgeIds, ++level);
    }

    public static void hierarchySetUp(BroadcastDomain domain, Bridge root) throws BridgeTopologyException {
        if (root == null || root.isRootBridge()) {
            return;
        }
        root.setRootBridge();
        if (domain.getBridges().size() == 1) {
            return;
        }
        for (SharedSegment segment : domain.getSharedSegments(root.getNodeId())) {
            segment.setDesignatedBridge(root.getNodeId());
            BroadcastDomain.tier(domain, segment, root.getNodeId(), 0);
        }
    }

    private static void tier(BroadcastDomain domain, SharedSegment segment, Integer rootid, int level) throws BridgeTopologyException {
        if (segment == null) {
            return;
        }
        if (++level == maxlevel) {
            return;
        }
        for (Integer bridgeid : segment.getBridgeIdsOnSegment()) {
            if (bridgeid.intValue() == rootid.intValue()) continue;
            Bridge bridge = domain.getBridge(bridgeid);
            if (bridge == null) {
                return;
            }
            bridge.setRootPort(segment.getBridgePort(bridgeid).getBridgePort());
            for (SharedSegment s2 : domain.getSharedSegments(bridgeid)) {
                if (s2.getDesignatedBridge() != null && s2.getDesignatedBridge().intValue() == rootid.intValue()) continue;
                s2.setDesignatedBridge(bridgeid);
                BroadcastDomain.tier(domain, s2, bridgeid, level);
            }
        }
    }

    public static boolean loadTopologyEntry(BroadcastDomain domain, SharedSegment segment) {
        for (BridgePort port : segment.getBridgePortsOnSegment()) {
            for (Bridge bridge : domain.getBridges()) {
                if (port.getNodeId().intValue() != bridge.getNodeId().intValue()) continue;
                domain.getSharedSegments().add(segment);
                return true;
            }
        }
        return false;
    }

    public static void clearTopologyForBridge(BroadcastDomain domain, Integer bridgeid) throws BridgeTopologyException {
        Bridge bridge = domain.getBridge(bridgeid);
        if (bridge == null) {
            throw new BridgeTopologyException("clearTopologyForBridge: Bridge must be not null:", domain);
        }
        if (bridge.getNodeId() == null) {
            throw new BridgeTopologyException("clearTopologyForBridge: Bridge Nodeid must be not null:", domain);
        }
        if (bridge.isNewTopology()) {
            return;
        }
        HashSet<Bridge> notnew = new HashSet<Bridge>();
        for (Bridge bridge2 : domain.getBridges()) {
            if (bridge2.isNewTopology()) continue;
            notnew.add(bridge2);
        }
        if (notnew.size() == 1) {
            domain.clearTopology();
            return;
        }
        SharedSegment topsegment = null;
        if (bridge.isRootBridge()) {
            for (SharedSegment segment : domain.getSharedSegments(bridge.getNodeId())) {
                Bridge newRootBridge;
                Object newRootId = null;
                for (BridgePort bridgePort : segment.getBridgePortsOnSegment()) {
                    if (bridgePort == null || bridgePort.getNodeId() == null || bridgePort.getBridgePort() == null || segment.getDesignatedBridge() != null && bridgePort.getNodeId().intValue() == segment.getDesignatedBridge().intValue()) continue;
                    newRootId = bridgePort.getNodeId();
                }
                if (newRootId == null || (newRootBridge = domain.getBridge((Integer)newRootId)) == null) continue;
                topsegment = domain.getSharedSegment((Integer)newRootId, newRootBridge.getRootPort());
                BroadcastDomain.hierarchySetUp(domain, newRootBridge);
                break;
            }
        } else {
            topsegment = domain.getSharedSegment(bridge.getNodeId(), bridge.getRootPort());
        }
        if (topsegment == null) {
            return;
        }
        BridgePort bridgePort = topsegment.getBridgePort(bridge.getNodeId());
        domain.getForwarding().remove(bridge.getNodeId());
        bridge.setRootPort(null);
        if (bridgePort == null) {
            return;
        }
        topsegment.getBridgePortsOnSegment().remove(bridgePort);
        ArrayList<SharedSegment> topology = new ArrayList<SharedSegment>();
        for (SharedSegment segment : domain.getSharedSegments()) {
            if (segment.getBridgeIdsOnSegment().contains(bridge.getNodeId())) {
                for (BridgePort bridgePort2 : segment.getBridgePortsOnSegment()) {
                    if (bridgePort2.getNodeId().intValue() == bridge.getNodeId().intValue()) continue;
                    topsegment.getBridgePortsOnSegment().add(bridgePort2);
                }
                topsegment.getMacsOnSegment().addAll(segment.getMacsOnSegment());
                continue;
            }
            topology.add(segment);
        }
        domain.m_topology = topology;
        HashMap forwardermap = new HashMap();
        for (BridgePortWithMacs bridgePortWithMacs : domain.getForwarding()) {
            for (String mac : bridgePortWithMacs.getMacs()) {
                if (!forwardermap.containsKey(mac)) {
                    forwardermap.put(mac, new HashSet());
                }
                ((Set)forwardermap.get(mac)).add(bridgePortWithMacs.getPort());
            }
        }
        for (String string : forwardermap.keySet()) {
            SharedSegment sharedSegment = domain.getSharedSegment((BridgePort)((Set)forwardermap.get(string)).iterator().next());
            if (sharedSegment == null || !((Set)forwardermap.get(string)).containsAll(sharedSegment.getBridgePortsOnSegment())) continue;
            sharedSegment.getMacsOnSegment().add(string);
        }
        domain.cleanForwarders();
    }

    public static void removeBridge(BroadcastDomain domain, int bridgeId) throws BridgeTopologyException {
        Bridge bridge = null;
        for (Bridge curbridge : domain.getBridges()) {
            if (curbridge.getNodeId() != bridgeId) continue;
            bridge = curbridge;
            break;
        }
        if (bridge == null) {
            return;
        }
        if (domain.getBridges().size() == 1) {
            domain.getSharedSegments().clear();
            domain.getBridges().clear();
            return;
        }
        BroadcastDomain.clearTopologyForBridge(domain, bridgeId);
        HashSet<Bridge> bridges = new HashSet<Bridge>();
        for (Bridge cur : domain.getBridges()) {
            if (cur.getNodeId() == bridgeId) continue;
            bridges.add(cur);
        }
        domain.m_bridges = bridges;
    }

    public void cleanForwarders() {
        this.cleanForwarders(this.getMacsOnSegments());
    }

    public void cleanForwarders(Set<String> macs) {
        this.m_forwarding.stream().forEach(bpm -> bpm.getMacs().removeAll(macs));
    }

    public BridgePortWithMacs getForwarder(BridgePort port) {
        HashSet links = new HashSet();
        this.m_forwarding.stream().filter(bp -> {
            if (bp == null || bp.getPort() == null) {
                return false;
            }
            return bp.getPort().equals(port);
        }).forEach(bpmi -> links.add(bpmi));
        return (BridgePortWithMacs)links.iterator().next();
    }

    public void addForwarding(BridgePort forwardport, String forwardmac) {
        BridgePortWithMacs bpm;
        for (BridgePortWithMacs bpm2 : this.m_forwarding) {
            if (!bpm2.getPort().equals(forwardport)) continue;
            bpm2.getMacs().add(forwardmac);
            return;
        }
        try {
            bpm = BridgePortWithMacs.create(forwardport, new HashSet<String>());
        }
        catch (BridgeTopologyException e) {
            return;
        }
        bpm.getMacs().add(forwardmac);
        this.m_forwarding.add(bpm);
    }

    public void setForwarders(Set<BridgePortWithMacs> forwarders) {
        this.m_forwarding.addAll(forwarders);
    }

    public Set<BridgePortWithMacs> getForwarding() {
        return this.m_forwarding;
    }

    public Set<BridgePortWithMacs> getForwarders(Integer bridgeId) {
        HashSet<BridgePortWithMacs> bridgeforwarders = new HashSet<BridgePortWithMacs>();
        this.m_forwarding.stream().filter(bfm -> bfm.getPort().getNodeId() == bridgeId).forEach(bfm -> bridgeforwarders.add((BridgePortWithMacs)bfm));
        return bridgeforwarders;
    }

    public Set<BridgePortWithMacs> cleanForwarders(Integer bridgeId) {
        Set<BridgePortWithMacs> bridgeforwarders = this.getForwarders(bridgeId);
        this.m_forwarding.removeAll(bridgeforwarders);
        return bridgeforwarders;
    }

    public void clearTopology() {
        this.m_topology.clear();
        this.m_forwarding.clear();
        for (Bridge bridge : this.m_bridges) {
            bridge.setRootPort(null);
        }
    }

    public boolean isEmpty() {
        return this.m_bridges.isEmpty();
    }

    public Set<Integer> getBridgeNodesOnDomain() {
        HashSet<Integer> bridgeIds = new HashSet<Integer>();
        for (Bridge bridge : this.m_bridges) {
            bridgeIds.add(bridge.getNodeId());
        }
        return bridgeIds;
    }

    public Set<Bridge> getBridges() {
        return this.m_bridges;
    }

    public List<SharedSegment> getSharedSegments() {
        return this.m_topology;
    }

    public Bridge getRootBridge() {
        for (Bridge bridge : this.m_bridges) {
            if (!bridge.isRootBridge()) continue;
            return bridge;
        }
        return null;
    }

    public Bridge getBridge(int bridgeId) {
        for (Bridge bridge : this.m_bridges) {
            if (bridge.getNodeId() != bridgeId) continue;
            return bridge;
        }
        return null;
    }

    public Set<String> getMacsOnSegments() {
        HashSet<String> macs = new HashSet<String>();
        for (SharedSegment segment : this.m_topology) {
            macs.addAll(segment.getMacsOnSegment());
        }
        return macs;
    }

    public List<SharedSegment> getSharedSegments(Integer bridgeId) {
        ArrayList<SharedSegment> segmentsOnBridge = new ArrayList<SharedSegment>();
        for (SharedSegment segment : this.m_topology) {
            if (!segment.getBridgeIdsOnSegment().contains(bridgeId)) continue;
            segmentsOnBridge.add(segment);
        }
        return segmentsOnBridge;
    }

    public Set<Bridge> getBridgeOnSharedSegment(SharedSegment segment) {
        HashSet<Integer> nodeidsOnSegment = new HashSet<Integer>(segment.getBridgeIdsOnSegment());
        HashSet<Bridge> bridgesOn = new HashSet<Bridge>();
        for (Bridge bridge : this.m_bridges) {
            if (!nodeidsOnSegment.contains(bridge.getNodeId())) continue;
            bridgesOn.add(bridge);
        }
        return bridgesOn;
    }

    public SharedSegment getSharedSegment(Integer bridgeid, Integer bridgePort) {
        BridgePort bp = new BridgePort();
        bp.setNodeId(bridgeid);
        bp.setBridgePort(bridgePort);
        return this.getSharedSegment(bp);
    }

    public SharedSegment getSharedSegment(BridgePort bridgePort) {
        if (bridgePort == null) {
            return null;
        }
        for (SharedSegment segment : this.m_topology) {
            if (!segment.getBridgePortsOnSegment().contains(bridgePort)) continue;
            return segment;
        }
        return null;
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("<--- broadcast domain ....-----");
        this.getBridges().stream().forEach(bridge -> {
            strbfr.append("\n");
            strbfr.append(bridge.printTopology());
        });
        Bridge rootBridge = this.getRootBridge();
        if (rootBridge != null && !this.m_topology.isEmpty()) {
            HashSet<Integer> rootids = new HashSet<Integer>();
            rootids.add(rootBridge.getNodeId());
            strbfr.append(this.printTopologyFromLevel(rootids, 0));
        } else {
            this.m_topology.stream().forEach(shared -> strbfr.append(shared.printTopology()));
        }
        strbfr.append("\n----forwarders----");
        this.m_forwarding.stream().forEach(bfte -> {
            strbfr.append("\nforward -> ");
            strbfr.append(bfte.printTopology());
        });
        strbfr.append("\n.... broadcast domain .....--->");
        return strbfr.toString();
    }

    public String printTopologyFromLevel(Set<Integer> bridgeIds, int level) {
        HashSet<Integer> bridgesDownLevel = new HashSet<Integer>();
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("\n------level ");
        strbfr.append(level);
        strbfr.append(" -----\n");
        strbfr.append("bridges on level:");
        strbfr.append(bridgeIds);
        bridgeIds.stream().map(id -> this.getBridge((int)id)).filter(bridge -> bridge != null).forEach(bridge -> {
            for (SharedSegment segment : this.getSharedSegments(bridge.getNodeId())) {
                if (segment.getDesignatedBridge().intValue() != bridge.getNodeId().intValue()) continue;
                strbfr.append("\n");
                strbfr.append(segment.printTopology());
                bridgesDownLevel.addAll(segment.getBridgeIdsOnSegment());
            }
        });
        bridgesDownLevel.removeAll(bridgeIds);
        if (!bridgesDownLevel.isEmpty()) {
            strbfr.append(this.printTopologyFromLevel(bridgesDownLevel, level + 1));
        }
        return strbfr.toString();
    }
}

