/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonBackReference;
import org.opennms.netmgt.model.ScanReport;
import org.opennms.netmgt.poller.PollStatus;

@Entity
@Table(name="scanReportPollResults")
@XmlRootElement(name="poll-result")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ScanReportPollResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="id")
    @XmlID
    private String m_id = UUID.randomUUID().toString();
    @XmlIDREF
    @XmlAttribute(name="scan-report-id")
    @JsonBackReference
    private ScanReport m_scanReport;
    @XmlAttribute(name="service-name")
    private String m_service;
    @XmlAttribute(name="service-id")
    private Integer m_serviceId;
    @XmlAttribute(name="node-label")
    private String m_nodeLabel;
    @XmlAttribute(name="node-id")
    private Integer m_nodeId;
    @XmlAttribute(name="ip-address")
    private String m_ipAddress;
    @XmlElement(name="poll-status")
    private PollStatus m_status;

    public ScanReportPollResult() {
    }

    public ScanReportPollResult(String serviceName, Integer serviceId, String nodeLabel, Integer nodeId, String ipAddress, PollStatus status) {
        this.m_service = serviceName;
        this.m_serviceId = serviceId;
        this.m_nodeLabel = nodeLabel;
        this.m_nodeId = nodeId;
        this.m_ipAddress = ipAddress;
        this.m_status = status;
    }

    public ScanReportPollResult(ScanReport scanReport, String serviceName, Integer serviceId, String nodeLabel, Integer nodeId, String ipAddress, PollStatus status) {
        this.m_scanReport = scanReport;
        this.m_service = serviceName;
        this.m_serviceId = serviceId;
        this.m_nodeLabel = nodeLabel;
        this.m_nodeId = nodeId;
        this.m_ipAddress = ipAddress;
        this.m_status = status;
    }

    @Id
    @Column(name="id", unique=true)
    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="scanReportId")
    public ScanReport getScanReport() {
        return this.m_scanReport;
    }

    public void setScanReport(ScanReport report) {
        this.m_scanReport = report;
    }

    public String getServiceName() {
        return this.m_service;
    }

    public void setServiceName(String serviceName) {
        this.m_service = serviceName;
    }

    public Integer getServiceId() {
        return this.m_serviceId;
    }

    public void setServiceId(Integer serviceId) {
        this.m_serviceId = serviceId;
    }

    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public void setNodeLabel(String nodeLabel) {
        this.m_nodeLabel = nodeLabel;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.m_nodeId = nodeId;
    }

    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    @Embedded
    public PollStatus getPollStatus() {
        return this.m_status;
    }

    public void setPollStatus(PollStatus ps) {
        this.m_status = ps;
    }

    @Transient
    @XmlTransient
    public String getResult() {
        if (this.m_status == null) {
            return "Unknown";
        }
        if (this.m_status.isUp()) {
            return "Success";
        }
        return "Failed: " + this.m_status.getReason();
    }

    @Transient
    @XmlTransient
    public boolean isUp() {
        if (this.m_status != null) {
            return this.m_status.isUp();
        }
        return true;
    }

    @Transient
    @XmlTransient
    public boolean isAvailable() {
        if (this.m_status != null) {
            return this.m_status.isAvailable();
        }
        return true;
    }

    public String toString() {
        return "ScanReportPollResult [service=" + this.m_service + ", serviceId=" + this.m_serviceId + ", nodeLabel=" + this.m_nodeLabel + ", nodeId=" + this.m_nodeId + ", ipAddress=" + this.m_ipAddress + ", status=" + this.m_status + "]";
    }
}

