/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SecondaryTable;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.MonitoringLocationIdAdapter;
import org.opennms.netmgt.model.MonitoringLocationJsonDeserializer;
import org.opennms.netmgt.model.MonitoringLocationJsonSerializer;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.PathElement;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.events.AddEventVisitor;
import org.opennms.netmgt.model.events.DeleteEventVisitor;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="node")
@Entity
@Table(name="node")
@SecondaryTable(name="pathOutage")
@XmlAccessorType(value=XmlAccessType.NONE)
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsNode
extends OnmsEntity
implements Serializable,
Comparable<OnmsNode> {
    private static final long serialVersionUID = 5326410037533354861L;
    private static final Logger LOG = LoggerFactory.getLogger(OnmsNode.class);
    private Integer m_id;
    private Date m_createTime = new Date();
    private OnmsNode m_parent;
    private NodeType m_type;
    private String m_sysObjectId;
    private String m_sysName;
    private String m_sysDescription;
    private String m_sysLocation;
    private String m_sysContact;
    private String m_label;
    @Transient
    @XmlTransient
    @JsonIgnore
    private String m_oldLabel;
    private NodeLabelSource m_labelSource;
    @Transient
    @XmlTransient
    @JsonIgnore
    private NodeLabelSource m_oldLabelSource;
    private String m_netBiosName;
    private String m_netBiosDomain;
    private String m_operatingSystem;
    private Date m_lastCapsdPoll;
    private String m_foreignSource;
    private String m_foreignId;
    private OnmsMonitoringLocation m_location;
    private OnmsAssetRecord m_assetRecord;
    private LldpElement m_lldpElement;
    private OspfElement m_ospfElement;
    private IsIsElement m_isisElement;
    private CdpElement m_cdpElement;
    private Set<OnmsIpInterface> m_ipInterfaces = new LinkedHashSet<OnmsIpInterface>();
    private Set<OnmsSnmpInterface> m_snmpInterfaces = new LinkedHashSet<OnmsSnmpInterface>();
    private Set<LldpLink> m_lldpLinks = new LinkedHashSet<LldpLink>();
    private Set<OnmsCategory> m_categories = new LinkedHashSet<OnmsCategory>();
    private Set<String> m_requisitionedCategories = new LinkedHashSet<String>();
    private PathElement m_pathElement;

    public OnmsNode() {
        this(null);
    }

    public OnmsNode(OnmsMonitoringLocation location) {
        this.setLocation(location);
    }

    public OnmsNode(OnmsMonitoringLocation location, String label) {
        this(location);
        this.setLabel(label);
    }

    @Id
    @Column(name="nodeId", nullable=false)
    @SequenceGenerator(name="nodeSequence", sequenceName="nodeNxtId")
    @GeneratedValue(generator="nodeSequence")
    @XmlTransient
    @JsonIgnore
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id", required=true)
    @Transient
    public String getNodeId() {
        if (this.getId() != null) {
            return this.getId().toString();
        }
        return null;
    }

    public void setId(Integer nodeid) {
        this.m_id = nodeid;
    }

    public void setNodeId(String nodeid) {
        this.setId(Integer.valueOf(nodeid));
    }

    @XmlElement(name="createTime")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="nodeCreateTime", nullable=false)
    public Date getCreateTime() {
        return this.m_createTime;
    }

    public void setCreateTime(Date nodecreatetime) {
        this.m_createTime = nodecreatetime;
    }

    @XmlTransient
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeParentID")
    public OnmsNode getParent() {
        return this.m_parent;
    }

    public void setParent(OnmsNode parent) {
        this.m_parent = parent;
    }

    @XmlAttribute(name="type")
    @Column(name="nodeType", length=1)
    @Type(type="org.opennms.netmgt.model.NodeTypeUserType")
    public NodeType getType() {
        return this.m_type;
    }

    public void setType(NodeType nodetype) {
        this.m_type = nodetype;
    }

    @XmlElement(name="sysObjectId")
    @Column(name="nodeSysOID", length=256)
    public String getSysObjectId() {
        return this.m_sysObjectId;
    }

    public void setSysObjectId(String nodesysoid) {
        this.m_sysObjectId = nodesysoid;
    }

    @XmlElement(name="sysName")
    @Column(name="nodeSysName", length=256)
    public String getSysName() {
        return this.m_sysName;
    }

    public void setSysName(String nodesysname) {
        this.m_sysName = nodesysname;
    }

    @XmlElement(name="sysDescription")
    @Column(name="nodeSysDescription", length=256)
    public String getSysDescription() {
        return this.m_sysDescription;
    }

    public void setSysDescription(String nodesysdescription) {
        this.m_sysDescription = nodesysdescription;
    }

    @XmlElement(name="sysLocation")
    @Column(name="nodeSysLocation", length=256)
    public String getSysLocation() {
        return this.m_sysLocation;
    }

    public void setSysLocation(String nodesyslocation) {
        this.m_sysLocation = nodesyslocation;
    }

    @XmlElement(name="sysContact")
    @Column(name="nodeSysContact", length=256)
    public String getSysContact() {
        return this.m_sysContact;
    }

    public void setSysContact(String nodesyscontact) {
        this.m_sysContact = nodesyscontact;
    }

    @XmlAttribute(name="label")
    @Column(name="nodeLabel", length=256, nullable=false)
    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String nodelabel) {
        if (this.m_label != null && this.m_oldLabel == null && !this.m_label.equals(nodelabel)) {
            this.m_oldLabel = this.m_label;
        }
        this.m_label = nodelabel;
    }

    @XmlElement(name="labelSource")
    @Column(name="nodeLabelSource", length=1)
    @Type(type="org.opennms.netmgt.model.NodeLabelSourceUserType")
    public NodeLabelSource getLabelSource() {
        return this.m_labelSource;
    }

    public void setLabelSource(NodeLabelSource nodelabelsource) {
        if (this.m_labelSource != nodelabelsource && this.m_labelSource != null && this.m_oldLabelSource == null) {
            this.m_oldLabelSource = this.m_labelSource;
        }
        this.m_labelSource = nodelabelsource;
    }

    @XmlElement(name="netBIOSName")
    @Column(name="nodeNetBIOSName", length=16)
    public String getNetBiosName() {
        return this.m_netBiosName;
    }

    public void setNetBiosName(String nodenetbiosname) {
        this.m_netBiosName = nodenetbiosname;
    }

    @XmlElement(name="netBIOSDomainName")
    @Column(name="nodeDomainName", length=16)
    public String getNetBiosDomain() {
        return this.m_netBiosDomain;
    }

    public void setNetBiosDomain(String nodedomainname) {
        this.m_netBiosDomain = nodedomainname;
    }

    @XmlElement(name="operatingSystem")
    @Column(name="operatingSystem", length=64)
    public String getOperatingSystem() {
        return this.m_operatingSystem;
    }

    public void setOperatingSystem(String operatingsystem) {
        this.m_operatingSystem = operatingsystem;
    }

    @XmlElement(name="lastCapsdPoll")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastCapsdPoll")
    public Date getLastCapsdPoll() {
        return this.m_lastCapsdPoll;
    }

    public void setLastCapsdPoll(Date lastcapsdpoll) {
        this.m_lastCapsdPoll = lastcapsdpoll;
    }

    @XmlAttribute(name="foreignId")
    @Column(name="foreignId")
    public String getForeignId() {
        return this.m_foreignId;
    }

    public void setForeignId(String foreignId) {
        this.m_foreignId = foreignId;
    }

    @XmlAttribute(name="foreignSource")
    @Column(name="foreignSource")
    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    @JsonSerialize(using=MonitoringLocationJsonSerializer.class)
    @JsonDeserialize(using=MonitoringLocationJsonDeserializer.class)
    @XmlElement(name="location")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="location")
    @XmlJavaTypeAdapter(value=MonitoringLocationIdAdapter.class)
    public OnmsMonitoringLocation getLocation() {
        return this.m_location;
    }

    public void setLocation(OnmsMonitoringLocation location) {
        this.m_location = location;
    }

    @OneToOne(mappedBy="node", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @XmlElement(name="assetRecord")
    public OnmsAssetRecord getAssetRecord() {
        if (this.m_assetRecord == null) {
            this.m_assetRecord = new OnmsAssetRecord();
            this.m_assetRecord.setNode(this);
        }
        return this.m_assetRecord;
    }

    public void setAssetRecord(OnmsAssetRecord asset) {
        this.m_assetRecord = asset;
    }

    @OneToOne(mappedBy="node", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    public LldpElement getLldpElement() {
        return this.m_lldpElement;
    }

    public void setLldpElement(LldpElement lldpElement) {
        this.m_lldpElement = lldpElement;
    }

    @OneToOne(mappedBy="node", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    public OspfElement getOspfElement() {
        return this.m_ospfElement;
    }

    public void setOspfElement(OspfElement ospfElement) {
        this.m_ospfElement = ospfElement;
    }

    @OneToOne(mappedBy="node", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    public IsIsElement getIsisElement() {
        return this.m_isisElement;
    }

    public void setIsisElement(IsIsElement isisElement) {
        this.m_isisElement = isisElement;
    }

    @OneToOne(mappedBy="node", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    public CdpElement getCdpElement() {
        return this.m_cdpElement;
    }

    public void setCdpElement(CdpElement cdpElement) {
        this.m_cdpElement = cdpElement;
    }

    @XmlTransient
    @JsonIgnore
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="ipAddress", column=@Column(name="criticalPathIp", table="pathOutage")), @AttributeOverride(name="serviceName", column=@Column(name="criticalPathServiceName", table="pathOutage"))})
    public PathElement getPathElement() {
        return this.m_pathElement;
    }

    public void setPathElement(PathElement pathElement) {
        this.m_pathElement = pathElement;
    }

    @XmlTransient
    @JsonIgnore
    @OneToMany(mappedBy="node", orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<OnmsIpInterface> getIpInterfaces() {
        return this.m_ipInterfaces;
    }

    public void setIpInterfaces(Set<OnmsIpInterface> ipinterfaces) {
        this.m_ipInterfaces = ipinterfaces;
    }

    public void addIpInterface(OnmsIpInterface iface) {
        iface.setNode(this);
        this.getIpInterfaces().add(iface);
    }

    public void removeIpInterface(OnmsIpInterface iface) {
        this.getIpInterfaces().remove(iface);
    }

    @XmlTransient
    @JsonIgnore
    @OneToMany(mappedBy="node", orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<LldpLink> getLldpLinks() {
        return this.m_lldpLinks;
    }

    public void setLldpLinks(Set<LldpLink> lldpLinks) {
        this.m_lldpLinks = lldpLinks;
    }

    public void addLldpLink(LldpLink lldpLink) {
        lldpLink.setNode(this);
        this.getLldpLinks().add(lldpLink);
    }

    @XmlTransient
    @JsonIgnore
    @OneToMany(mappedBy="node", orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<OnmsSnmpInterface> getSnmpInterfaces() {
        return this.m_snmpInterfaces;
    }

    public void setSnmpInterfaces(Set<OnmsSnmpInterface> snmpinterfaces) {
        this.m_snmpInterfaces = snmpinterfaces;
    }

    @XmlElement(name="categories")
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="category_node", joinColumns={@JoinColumn(name="nodeId")}, inverseJoinColumns={@JoinColumn(name="categoryId")})
    public Set<OnmsCategory> getCategories() {
        return this.m_categories;
    }

    public void setCategories(Set<OnmsCategory> categories) {
        this.m_categories = categories;
    }

    public boolean addCategory(OnmsCategory category) {
        return this.getCategories().add(category);
    }

    public boolean removeCategory(OnmsCategory category) {
        return this.getCategories().remove(category);
    }

    public boolean hasCategory(String categoryName) {
        for (OnmsCategory category : this.getCategories()) {
            if (!category.getName().equals(categoryName)) continue;
            return true;
        }
        return false;
    }

    @Transient
    @XmlTransient
    public Set<String> getRequisitionedCategories() {
        return this.m_requisitionedCategories;
    }

    public void setRequisitionedCategories(Set<String> categories) {
        this.m_requisitionedCategories = new LinkedHashSet<String>(categories);
    }

    public void addRequisitionedCategory(String category) {
        this.m_requisitionedCategories.add(category);
    }

    public void removeRequisitionedCategory(String category) {
        this.m_requisitionedCategories.remove(category);
    }

    public String toString() {
        ToStringCreator retval = new ToStringCreator((Object)this);
        retval.append("id", (Object)this.m_id);
        retval.append("location", this.m_location == null ? null : this.m_location.getLocationName());
        retval.append("foreignSource", (Object)this.m_foreignSource);
        retval.append("foreignId", (Object)this.m_foreignId);
        retval.append("labelSource", this.m_labelSource == null ? null : this.m_labelSource.toString());
        retval.append("label", (Object)this.m_label);
        retval.append("parent.id", this.getParent() == null ? null : this.getParent().getId());
        retval.append("createTime", (Object)this.m_createTime);
        retval.append("sysObjectId", (Object)this.m_sysObjectId);
        retval.append("sysName", (Object)this.m_sysName);
        retval.append("sysDescription", (Object)this.m_sysDescription);
        retval.append("sysLocation", (Object)this.m_sysLocation);
        retval.append("sysContact", (Object)this.m_sysContact);
        retval.append("type", this.m_type == null ? null : this.m_type.toString());
        retval.append("operatingSystem", (Object)this.m_operatingSystem);
        return retval.toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        visitor.visitNode(this);
        for (OnmsIpInterface iface : this.getIpInterfaces()) {
            iface.visit(visitor);
        }
        for (OnmsSnmpInterface snmpIface : this.getSnmpInterfaces()) {
            snmpIface.visit(visitor);
        }
        visitor.visitNodeComplete(this);
    }

    public void addSnmpInterface(OnmsSnmpInterface snmpIface) {
        snmpIface.setNode(this);
        this.getSnmpInterfaces().add(snmpIface);
    }

    @Transient
    public boolean isDown() {
        boolean down = true;
        for (OnmsIpInterface ipIf : this.m_ipInterfaces) {
            if (ipIf.isDown()) continue;
            return !down;
        }
        return down;
    }

    @Transient
    @JsonIgnore
    public OnmsSnmpInterface getSnmpInterfaceWithIfIndex(int ifIndex) {
        for (OnmsSnmpInterface dbSnmpIface : this.getSnmpInterfaces()) {
            if (!dbSnmpIface.getIfIndex().equals(ifIndex)) continue;
            return dbSnmpIface;
        }
        return null;
    }

    public OnmsIpInterface getIpInterfaceByIpAddress(String ipAddress) {
        return this.getIpInterfaceByIpAddress(InetAddressUtils.getInetAddress((String)ipAddress));
    }

    public OnmsIpInterface getIpInterfaceByIpAddress(InetAddress ipAddress) {
        for (OnmsIpInterface iface : this.getIpInterfaces()) {
            if (!ipAddress.equals(iface.getIpAddress())) continue;
            return iface;
        }
        return null;
    }

    @Override
    public int compareTo(OnmsNode o) {
        int returnval;
        String compareLabel = "";
        Integer compareId = 0;
        if (o != null) {
            compareLabel = o.getLabel();
            compareId = o.getId();
        }
        if ((returnval = this.getLabel().compareToIgnoreCase(compareLabel)) == 0) {
            return this.getId().compareTo(compareId);
        }
        return returnval;
    }

    @Transient
    @JsonIgnore
    public OnmsIpInterface getPrimaryInterface() {
        ArrayList<OnmsIpInterface> primaryInterfaces = new ArrayList<OnmsIpInterface>();
        for (OnmsIpInterface iface : this.getIpInterfaces()) {
            if (!PrimaryType.PRIMARY.equals(iface.getIsSnmpPrimary())) continue;
            primaryInterfaces.add(iface);
        }
        if (primaryInterfaces.size() < 1) {
            return null;
        }
        if (primaryInterfaces.size() > 1) {
            Collections.sort(primaryInterfaces, new Comparator<OnmsIpInterface>(){

                @Override
                public int compare(OnmsIpInterface o1, OnmsIpInterface o2) {
                    if (o1 == null) {
                        if (o2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1.getIpLastCapsdPoll() == null) {
                        if (o2.getIpLastCapsdPoll() == null) {
                            return 0;
                        }
                        return 1;
                    }
                    if (o2.getIpLastCapsdPoll() == null) {
                        return -1;
                    }
                    return o2.getIpLastCapsdPoll().compareTo(o1.getIpLastCapsdPoll());
                }
            });
            OnmsIpInterface retval = (OnmsIpInterface)primaryInterfaces.iterator().next();
            LOG.warn("Multiple primary SNMP interfaces for node {}, returning most recently scanned interface: {}", (Object)this.m_id, (Object)retval.getInterfaceId());
            return retval;
        }
        return (OnmsIpInterface)primaryInterfaces.iterator().next();
    }

    @Transient
    @JsonIgnore
    public OnmsIpInterface getInterfaceWithService(String svcName) {
        for (OnmsIpInterface iface : this.getIpInterfaces()) {
            if (iface.getMonitoredServiceByServiceType(svcName) == null) continue;
            return iface;
        }
        return null;
    }

    @Transient
    @JsonIgnore
    public OnmsIpInterface getInterfaceWithAddress(InetAddress addr) {
        if (addr == null) {
            return null;
        }
        for (OnmsIpInterface iface : this.getIpInterfaces()) {
            if (!addr.equals(iface.getIpAddress())) continue;
            return iface;
        }
        return null;
    }

    @Transient
    @JsonIgnore
    public OnmsIpInterface getCriticalInterface() {
        OnmsIpInterface critIface = this.getPrimaryInterface();
        if (critIface != null) {
            return critIface;
        }
        return this.getInterfaceWithService("ICMP");
    }

    public void mergeAgentAttributes(OnmsNode scannedNode) {
        if (OnmsNode.hasNewValue(scannedNode.getSysContact(), this.getSysContact())) {
            this.setSysContact(scannedNode.getSysContact());
        }
        if (OnmsNode.hasNewValue(scannedNode.getSysDescription(), this.getSysDescription())) {
            this.setSysDescription(scannedNode.getSysDescription());
        }
        if (OnmsNode.hasNewValue(scannedNode.getSysLocation(), this.getSysLocation())) {
            this.setSysLocation(scannedNode.getSysLocation());
        }
        if (OnmsNode.hasNewValue(scannedNode.getSysName(), this.getSysName())) {
            this.setSysName(scannedNode.getSysName());
        }
        if (OnmsNode.hasNewValue(scannedNode.getSysObjectId(), this.getSysObjectId())) {
            this.setSysObjectId(scannedNode.getSysObjectId());
        }
    }

    public void mergeNodeAttributes(OnmsNode scannedNode, EventForwarder eventForwarder) {
        String scannedLabel = scannedNode.getLabel();
        boolean send = false;
        if (this.m_oldLabel != null || this.m_oldLabelSource != null) {
            send = true;
        } else if (OnmsNode.hasNewValue(scannedLabel, this.getLabel())) {
            this.m_oldLabel = this.getLabel();
            this.m_oldLabelSource = this.getLabelSource();
            send = true;
        }
        if (send) {
            LOG.debug("mergeNodeAttributes(): sending NODE_LABEL_CHANGED_EVENT_UEI");
            EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeLabelChanged", "OnmsNode.mergeNodeAttributes");
            bldr.setNodeid(scannedNode.getId().intValue());
            bldr.setHost(InetAddressUtils.getLocalHostAddressAsString());
            if (this.m_oldLabel != null) {
                bldr.addParam("oldNodeLabel", this.m_oldLabel);
                if (this.m_oldLabelSource != null) {
                    bldr.addParam("oldNodeLabelSource", this.m_oldLabelSource.toString());
                }
            }
            if (scannedLabel != null) {
                bldr.addParam("newNodeLabel", scannedLabel);
                if (scannedNode.getLabelSource() != null) {
                    bldr.addParam("newNodeLabelSource", scannedNode.getLabelSource().toString());
                }
            }
            this.m_oldLabel = null;
            this.m_oldLabelSource = null;
            eventForwarder.sendNow(bldr.getEvent());
            this.m_label = scannedLabel;
        } else {
            LOG.debug("mergeNodeAttributes(): skipping event.");
        }
        if (OnmsNode.hasNewValue(scannedNode.getLocation(), this.getLocation())) {
            this.setLocation(scannedNode.getLocation());
        }
        if (OnmsNode.hasNewValue(scannedNode.getForeignSource(), this.getForeignSource())) {
            this.setForeignSource(scannedNode.getForeignSource());
        }
        if (OnmsNode.hasNewValue(scannedNode.getForeignId(), this.getForeignId())) {
            this.setForeignId(scannedNode.getForeignId());
        }
        if (OnmsNode.hasNewValue((Object)scannedNode.getLabelSource(), (Object)this.getLabelSource())) {
            this.setLabelSource(scannedNode.getLabelSource());
        }
        if (OnmsNode.hasNewValue(scannedNode.getNetBiosName(), this.getNetBiosDomain())) {
            this.setNetBiosName(scannedNode.getNetBiosDomain());
        }
        if (OnmsNode.hasNewValue(scannedNode.getNetBiosDomain(), this.getNetBiosDomain())) {
            this.setNetBiosDomain(scannedNode.getNetBiosDomain());
        }
        if (OnmsNode.hasNewValue(scannedNode.getOperatingSystem(), this.getOperatingSystem())) {
            this.setOperatingSystem(scannedNode.getOperatingSystem());
        }
        this.mergeAgentAttributes(scannedNode);
        this.mergeAdditionalCategories(scannedNode);
    }

    public void mergeAdditionalCategories(OnmsNode scannedNode) {
        this.getCategories().addAll(scannedNode.getCategories());
    }

    public void mergeSnmpInterfaces(OnmsNode scannedNode, boolean deleteMissing) {
        if (scannedNode.getSnmpInterfaces().size() == 0) {
            return;
        }
        HashMap<Integer, OnmsSnmpInterface> scannedInterfaceMap = new HashMap<Integer, OnmsSnmpInterface>();
        for (OnmsSnmpInterface snmpIface : scannedNode.getSnmpInterfaces()) {
            if (snmpIface.getIfIndex() == null) continue;
            scannedInterfaceMap.put(snmpIface.getIfIndex(), snmpIface);
        }
        Iterator<OnmsSnmpInterface> it = this.getSnmpInterfaces().iterator();
        while (it.hasNext()) {
            OnmsSnmpInterface iface = it.next();
            OnmsSnmpInterface imported = (OnmsSnmpInterface)scannedInterfaceMap.get(iface.getIfIndex());
            if (imported == null) {
                if (!deleteMissing) continue;
                it.remove();
                scannedInterfaceMap.remove(iface.getIfIndex());
                continue;
            }
            iface.mergeSnmpInterfaceAttributes(imported);
            scannedInterfaceMap.remove(iface.getIfIndex());
        }
        for (OnmsSnmpInterface snmpIface : scannedInterfaceMap.values()) {
            this.addSnmpInterface(snmpIface);
        }
    }

    public void mergeIpInterfaces(OnmsNode scannedNode, EventForwarder eventForwarder, boolean deleteMissing) {
        OnmsIpInterface oldPrimaryInterface = null;
        OnmsIpInterface scannedPrimaryIf = null;
        HashMap<InetAddress, OnmsIpInterface> ipInterfaceMap = new HashMap<InetAddress, OnmsIpInterface>();
        for (OnmsIpInterface iface : scannedNode.getIpInterfaces()) {
            if (scannedPrimaryIf == null && iface.isPrimary()) {
                scannedPrimaryIf = iface;
            } else if (iface.isPrimary()) {
                iface.setIsSnmpPrimary(PrimaryType.SECONDARY);
            }
            ipInterfaceMap.put(iface.getIpAddress(), iface);
        }
        Iterator<OnmsIpInterface> it = this.getIpInterfaces().iterator();
        while (it.hasNext()) {
            OnmsIpInterface dbIface = it.next();
            OnmsIpInterface scannedIface = (OnmsIpInterface)ipInterfaceMap.get(dbIface.getIpAddress());
            if (scannedIface == null) {
                if (deleteMissing) {
                    it.remove();
                    dbIface.visit(new DeleteEventVisitor(eventForwarder));
                } else if (scannedPrimaryIf != null && dbIface.isPrimary()) {
                    dbIface.setIsSnmpPrimary(PrimaryType.SECONDARY);
                    oldPrimaryInterface = dbIface;
                }
            } else {
                dbIface.mergeInterface(scannedIface, eventForwarder, deleteMissing);
                if (scannedPrimaryIf != null && dbIface.isPrimary() && scannedPrimaryIf != scannedIface) {
                    dbIface.setIsSnmpPrimary(PrimaryType.SECONDARY);
                    oldPrimaryInterface = dbIface;
                }
            }
            ipInterfaceMap.remove(dbIface.getIpAddress());
        }
        for (OnmsIpInterface iface : ipInterfaceMap.values()) {
            this.addIpInterface(iface);
            if (iface.getIfIndex() != null) {
                iface.setSnmpInterface(this.getSnmpInterfaceWithIfIndex(iface.getIfIndex()));
            }
            iface.visit(new AddEventVisitor(eventForwarder));
        }
        if (oldPrimaryInterface != null && scannedPrimaryIf != null) {
            EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/primarySnmpInterfaceChanged", "Provisiond");
            bldr.setIpInterface(scannedPrimaryIf);
            bldr.setService("SNMP");
            bldr.addParam("oldPrimarySnmpAddress", InetAddressUtils.str((InetAddress)oldPrimaryInterface.getIpAddress()));
            bldr.addParam("newPrimarySnmpAddress", InetAddressUtils.str((InetAddress)scannedPrimaryIf.getIpAddress()));
            eventForwarder.sendNow(bldr.getEvent());
        }
    }

    public void mergeCategorySet(OnmsNode scannedNode) {
        if (!this.getCategories().equals(scannedNode.getCategories())) {
            this.setCategories(scannedNode.getCategories());
        }
    }

    public void mergeAssets(OnmsNode scannedNode) {
        this.getAssetRecord().mergeRecord(scannedNode.getAssetRecord());
    }

    public void replaceCurrentAssetRecord(OnmsNode scannedNode) {
        scannedNode.getAssetRecord().setId(this.getAssetRecord().getId());
        scannedNode.setId(this.m_id);
        this.setAssetRecord(scannedNode.getAssetRecord());
    }

    public void mergeNode(OnmsNode scannedNode, EventForwarder eventForwarder, boolean deleteMissing) {
        this.mergeNodeAttributes(scannedNode, eventForwarder);
        this.mergeSnmpInterfaces(scannedNode, deleteMissing);
        this.mergeIpInterfaces(scannedNode, eventForwarder, deleteMissing);
        this.mergeCategorySet(scannedNode);
        this.mergeAssets(scannedNode);
    }

    @Transient
    @JsonIgnore
    public boolean containsService(InetAddress addr, String service) {
        OnmsIpInterface iface = this.getInterfaceWithAddress(addr);
        if (iface != null) {
            OnmsMonitoredService svc = iface.getMonitoredServiceByServiceType(service);
            return svc != null;
        }
        return false;
    }

    @Transient
    @JsonIgnore
    public boolean containsInterface(InetAddress addr) {
        return this.getInterfaceWithAddress(addr) != null;
    }

    @XmlEnum
    public static enum NodeLabelSource {
        USER('U'),
        NETBIOS('N'),
        HOSTNAME('H'),
        SYSNAME('S'),
        ADDRESS('A'),
        UNKNOWN(' ');

        private final char value;

        private NodeLabelSource(char c) {
            this.value = c;
        }

        @JsonValue
        public char value() {
            return this.value;
        }

        @JsonCreator
        static NodeLabelSource create(String s) {
            if (s == null || s.length() == 0) {
                return null;
            }
            for (NodeLabelSource src : NodeLabelSource.values()) {
                if (src.value != s.charAt(0)) continue;
                return src;
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @XmlEnum
    public static enum NodeType {
        ACTIVE('A'),
        DELETED('D'),
        UNKNOWN(' ');

        private final char value;

        private NodeType(char c) {
            this.value = c;
        }

        @JsonValue
        public char value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NodeType getNodeTypeFromChar(char c) {
            for (NodeType nodeType : NodeType.values()) {
                if (nodeType.value != c) continue;
                return nodeType;
            }
            return null;
        }

        @JsonCreator
        public static NodeType create(String s) {
            if (s == null || s.length() == 0) {
                return null;
            }
            for (NodeType nodeType : NodeType.values()) {
                if (nodeType.value != s.charAt(0)) continue;
                return nodeType;
            }
            return null;
        }
    }
}

