/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.topology.Topology;

@Entity
@Table(name="cdpElement")
public final class CdpElement
implements Serializable,
Topology {
    private static final long serialVersionUID = -3134355798509685991L;
    private Integer m_id;
    private OspfElement.TruthValue m_cdpGlobalRun;
    private String m_cdpGlobalDeviceId;
    private CdpGlobalDeviceIdFormat m_cdpGlobalDeviceIdFormat;
    private Date m_cdpNodeCreateTime = new Date();
    private Date m_cdpNodeLastPollTime;
    private OnmsNode m_node;

    public CdpElement() {
    }

    public CdpElement(OnmsNode node, String cdpGlobalDeviceId) {
        this.setNode(node);
        this.setCdpGlobalDeviceId(cdpGlobalDeviceId);
    }

    public CdpElement(OnmsNode node, String cdpGlobalDeviceId, CdpGlobalDeviceIdFormat format) {
        this.setNode(node);
        this.setCdpGlobalDeviceId(cdpGlobalDeviceId);
        this.setCdpGlobalDeviceIdFormat(format);
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    @Column(name="cdpGlobalRun", nullable=false)
    @Type(type="org.opennms.netmgt.model.TruthValueUserType")
    public OspfElement.TruthValue getCdpGlobalRun() {
        return this.m_cdpGlobalRun;
    }

    @Column(name="cdpGlobalDeviceId", length=256, nullable=false)
    public String getCdpGlobalDeviceId() {
        return this.m_cdpGlobalDeviceId;
    }

    @Column(name="cdpGlobalDeviceIdFormat", nullable=true)
    @Type(type="org.opennms.netmgt.model.CdpGlobalDeviceIdFormatUserType")
    public CdpGlobalDeviceIdFormat getCdpGlobalDeviceIdFormat() {
        return this.m_cdpGlobalDeviceIdFormat;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="cdpNodeCreateTime", nullable=false)
    public Date getCdpNodeCreateTime() {
        return this.m_cdpNodeCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="cdpNodeLastPollTime", nullable=false)
    public Date getCdpNodeLastPollTime() {
        return this.m_cdpNodeLastPollTime;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    public void setCdpGlobalRun(OspfElement.TruthValue cdpGlobalRun) {
        this.m_cdpGlobalRun = cdpGlobalRun;
    }

    public void setCdpGlobalDeviceId(String cdpGlobalDeviceId) {
        this.m_cdpGlobalDeviceId = cdpGlobalDeviceId;
    }

    public void setCdpGlobalDeviceIdFormat(CdpGlobalDeviceIdFormat cdpGlobalDeviceIdFormat) {
        this.m_cdpGlobalDeviceIdFormat = cdpGlobalDeviceIdFormat;
    }

    public void setCdpNodeCreateTime(Date cdpNodeCreateTime) {
        this.m_cdpNodeCreateTime = cdpNodeCreateTime;
    }

    public void setCdpNodeLastPollTime(Date cdpNodeLastPollTime) {
        this.m_cdpNodeLastPollTime = cdpNodeLastPollTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Nodeid", (Object)this.m_node.getId()).append("cdpGlobalDeviceId", (Object)this.m_cdpGlobalDeviceId).append("cdpNodeCreateTime", (Object)this.m_cdpNodeCreateTime).append("cdpNodeLastPollTime", (Object)this.m_cdpNodeLastPollTime).toString();
    }

    @Override
    @Transient
    public String printTopology() {
        StringBuffer strb = new StringBuffer();
        strb.append("cdpelement: nodeid:[");
        strb.append(this.getNode().getId());
        strb.append("], Global Device Id:[");
        strb.append(this.getCdpGlobalDeviceId());
        strb.append("], Global Run:[");
        strb.append(OspfElement.TruthValue.getTypeString(this.getCdpGlobalRun().getValue()));
        strb.append("]");
        return strb.toString();
    }

    public void merge(CdpElement element) {
        if (element == null) {
            return;
        }
        this.setCdpGlobalRun(element.getCdpGlobalRun());
        this.setCdpGlobalDeviceId(element.getCdpGlobalDeviceId());
        this.setCdpNodeLastPollTime(element.getCdpNodeCreateTime());
    }

    public static enum CdpGlobalDeviceIdFormat {
        serialNumber(1),
        macAddress(2),
        other(3);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private CdpGlobalDeviceIdFormat(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static CdpGlobalDeviceIdFormat get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create CdpDeviceFormat from null code");
            }
            switch (code) {
                case 1: {
                    return serialNumber;
                }
                case 2: {
                    return macAddress;
                }
                case 3: {
                    return other;
                }
            }
            throw new IllegalArgumentException("Cannot create CdpDeviceIdFormat from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "serialNumber");
            s_typeMap.put(2, "macAddress");
            s_typeMap.put(3, "other");
        }
    }
}

