/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.model.topology.BridgeForwardingTable;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BridgePortWithMacs;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.Topology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeSimpleConnection
implements Topology {
    static final Logger LOG = LoggerFactory.getLogger(BridgeSimpleConnection.class);
    private final BridgeForwardingTable m_xBridge;
    private final BridgeForwardingTable m_yBridge;
    private BridgePort m_xyPort;
    private BridgePort m_yxPort;

    public static Set<String> getMacs(BridgeForwardingTable xBridge, BridgeForwardingTable yBridge, BridgeSimpleConnection simple) throws BridgeTopologyException {
        if (simple.getFirstPort() == null) {
            throw new BridgeTopologyException("getMacs: not found simpleconnection [" + xBridge.getNodeId() + "]", simple);
        }
        if (simple.getSecondPort() == null) {
            throw new BridgeTopologyException("getMacs: not found simpleconnection [" + yBridge.getNodeId() + "]", simple);
        }
        if (xBridge.getNodeId().intValue() != simple.getFirstPort().getNodeId().intValue()) {
            throw new BridgeTopologyException("getMacs: node mismatch [" + xBridge.getNodeId() + "] found ", simple.getFirstPort());
        }
        if (yBridge.getNodeId().intValue() != simple.getSecondPort().getNodeId().intValue()) {
            throw new BridgeTopologyException("getMacs: node mismatch [" + yBridge.getNodeId() + "]", simple.getSecondPort());
        }
        Set<String> macsOnSegment = xBridge.getBridgePortWithMacs(simple.getFirstPort()).getMacs();
        macsOnSegment.retainAll(yBridge.getBridgePortWithMacs(simple.getSecondPort()).getMacs());
        return macsOnSegment;
    }

    public BridgePort getFirstPort() {
        return this.m_xyPort;
    }

    public BridgePort getSecondPort() {
        return this.m_yxPort;
    }

    public Integer getFirstBridgePort() {
        return this.m_xyPort.getBridgePort();
    }

    public Integer getSecondBridgePort() {
        return this.m_yxPort.getBridgePort();
    }

    private BridgeSimpleConnection(BridgeForwardingTable xBridge, BridgeForwardingTable yBridge) {
        this.m_xBridge = xBridge;
        this.m_yBridge = yBridge;
    }

    private void findSimpleConnection() throws BridgeTopologyException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\n first bridge -> \n{}\n second bridge -> \n{}", (Object)this.m_xBridge.printTopology(), (Object)this.m_yBridge.printTopology());
        }
        if (this.m_xBridge.getPorttomac().size() == 1) {
            this.m_xyPort = this.m_xBridge.getPorttomac().iterator().next().getPort();
            LOG.debug("only one port found: bridge:[{}] <- {} ", (Object)this.m_yBridge.getNodeId(), (Object)this.m_xyPort.printTopology());
        }
        if (this.m_yBridge.getPorttomac().size() == 1) {
            this.m_yxPort = this.m_yBridge.getPorttomac().iterator().next().getPort();
            LOG.debug("only one port found: bridge:[{}] <- {} ", (Object)this.m_xBridge.getNodeId(), (Object)this.m_yxPort.printTopology());
        }
        if (this.m_xyPort == null) {
            try {
                this.m_xyPort = BridgeSimpleConnection.condition1(this.m_yBridge, this.m_xBridge);
            }
            catch (BridgeTopologyException e) {
                LOG.debug("bridge: [{}] -> [{}], {}", new Object[]{this.m_xBridge.getNodeId(), this.m_yBridge.getNodeId(), e.getMessage()});
            }
        }
        if (this.m_yxPort == null) {
            try {
                this.m_yxPort = BridgeSimpleConnection.condition1(this.m_xBridge, this.m_yBridge);
            }
            catch (BridgeTopologyException e) {
                LOG.debug("bridge: [{}] -> [{}], {}", new Object[]{this.m_yBridge.getNodeId(), this.m_xBridge.getNodeId(), e.getMessage()});
            }
        }
        if (this.m_xyPort != null && this.m_yxPort != null) {
            return;
        }
        HashSet<String> commonlearnedmacs = new HashSet<String>(this.m_xBridge.getMactoport().keySet());
        commonlearnedmacs.retainAll(new HashSet<String>(this.m_yBridge.getMactoport().keySet()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("bridge: [{}] <-> [{}] common (learned mac): {}", new Object[]{this.m_yBridge.getNodeId(), this.m_xBridge.getNodeId(), commonlearnedmacs});
        }
        if (this.m_yxPort != null && this.m_xyPort == null) {
            try {
                this.m_xyPort = BridgeSimpleConnection.condition2(commonlearnedmacs, this.m_yxPort, this.m_yBridge, this.m_xBridge);
            }
            catch (BridgeTopologyException e) {
                LOG.warn("bridge: [{}] -> [{}], {}", new Object[]{this.m_xBridge.getNodeId(), this.m_yBridge.getNodeId(), e.getMessage()});
                this.m_xyPort = BridgeSimpleConnection.conditionB(commonlearnedmacs, this.m_xBridge);
            }
            return;
        }
        if (this.m_yxPort == null && this.m_xyPort != null) {
            try {
                this.m_yxPort = BridgeSimpleConnection.condition2(commonlearnedmacs, this.m_xyPort, this.m_xBridge, this.m_yBridge);
            }
            catch (BridgeTopologyException e) {
                LOG.warn("bridge: [{}] -> [{}], {}", new Object[]{this.m_yBridge.getNodeId(), this.m_xBridge.getNodeId(), e.getMessage()});
                this.m_yxPort = BridgeSimpleConnection.conditionB(commonlearnedmacs, this.m_yBridge);
            }
            return;
        }
        List<BridgePort> ports = BridgeSimpleConnection.condition3(commonlearnedmacs, this.m_xBridge, this.m_yBridge);
        this.m_xyPort = ports.get(0);
        this.m_yxPort = ports.get(1);
    }

    private static List<BridgePort> condition3(Set<String> commonlearnedmacs, BridgeForwardingTable bridgexFt, BridgeForwardingTable bridgeyFt) throws BridgeTopologyException {
        Map<String, BridgePort> xbft = bridgexFt.getMactoport();
        Map<String, BridgePort> ybft = bridgeyFt.getMactoport();
        if (LOG.isDebugEnabled()) {
            LOG.debug("condition3: common (learned mac): -> {}", commonlearnedmacs);
        }
        String mac1 = null;
        String mac2 = null;
        BridgePort yp1 = null;
        BridgePort yp2 = null;
        BridgePort xp1 = null;
        BridgePort xp2 = null;
        ArrayList<BridgePort> bbports = new ArrayList<BridgePort>(2);
        for (String mac : commonlearnedmacs) {
            if (mac1 == null) {
                mac1 = mac;
                yp1 = ybft.get(mac);
                xp1 = xbft.get(mac);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("condition3: mac:[{}] {} - {} ", new Object[]{mac1, xp1.printTopology(), yp1.printTopology()});
                continue;
            }
            if (ybft.get(mac).getBridgePort() == yp1.getBridgePort() && xbft.get(mac).getBridgePort() == xp1.getBridgePort()) continue;
            if (mac2 == null) {
                mac2 = mac;
                yp2 = ybft.get(mac);
                xp2 = xbft.get(mac);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("condition3: mac:[{}], {} - {} ", new Object[]{mac2, xp2.printTopology(), yp2.printTopology()});
                continue;
            }
            if (ybft.get(mac).getBridgePort() == yp2.getBridgePort() && xbft.get(mac).getBridgePort() == xp2.getBridgePort()) continue;
            BridgePort yp3 = ybft.get(mac);
            BridgePort xp3 = xbft.get(mac);
            if (LOG.isDebugEnabled()) {
                LOG.debug("condition3: mac:[{}], {} - {} ", new Object[]{mac, xp3.printTopology(), yp3.printTopology()});
            }
            if (xp1.getBridgePort() == xp2.getBridgePort() && xp1.getBridgePort() != xp3.getBridgePort() && (yp1.getBridgePort() != yp3.getBridgePort() || yp2.getBridgePort() != yp3.getBridgePort())) {
                bbports.add(0, xp1);
                bbports.add(1, yp3);
                return bbports;
            }
            if (yp1.getBridgePort() == yp2.getBridgePort() && yp1.getBridgePort() != yp3.getBridgePort() && (xp1.getBridgePort() != xp3.getBridgePort() || xp2.getBridgePort() != xp3.getBridgePort())) {
                bbports.add(0, xp3);
                bbports.add(1, yp1);
                return bbports;
            }
            if (xp1.getBridgePort() == xp3.getBridgePort() && xp1.getBridgePort() != xp2.getBridgePort() && (yp1.getBridgePort() != yp2.getBridgePort() || yp2.getBridgePort() != yp3.getBridgePort())) {
                bbports.add(0, xp1);
                bbports.add(1, yp2);
                return bbports;
            }
            if (yp1.getBridgePort() == yp3.getBridgePort() && yp1.getBridgePort() != yp2.getBridgePort() && (xp1.getBridgePort() != xp2.getBridgePort() || xp2.getBridgePort() != xp3.getBridgePort())) {
                bbports.add(0, xp2);
                bbports.add(1, yp1);
                return bbports;
            }
            if (xp3.getBridgePort() == xp2.getBridgePort() && xp1.getBridgePort() != xp3.getBridgePort() && (yp1.getBridgePort() != yp3.getBridgePort() || yp2.getBridgePort() != yp1.getBridgePort())) {
                bbports.add(0, xp2);
                bbports.add(1, yp1);
                return bbports;
            }
            if (yp3.getBridgePort() != yp2.getBridgePort() || yp1.getBridgePort() == yp3.getBridgePort() || xp1.getBridgePort() == xp3.getBridgePort() && xp2.getBridgePort() == xp1.getBridgePort()) continue;
            bbports.add(0, xp1);
            bbports.add(1, yp2);
            return bbports;
        }
        if (mac2 == null) {
            bbports.add(0, xp1);
            bbports.add(1, yp1);
            return bbports;
        }
        throw new BridgeTopologyException("condition3: bridge: no simple connection", bridgeyFt);
    }

    private static BridgePort condition2(Set<String> commonlearnedmacs, BridgePort bridge1port, BridgeForwardingTable bridge1Ft, BridgeForwardingTable bridge2Ft) throws BridgeTopologyException {
        for (String mac : commonlearnedmacs) {
            BridgePort bridge1port1 = bridge1Ft.getMactoport().get(mac);
            BridgePort bridge2port1 = bridge2Ft.getMactoport().get(mac);
            if (bridge1port.getBridgePort().intValue() == bridge1port1.getBridgePort().intValue()) continue;
            LOG.debug("condition2: bridge:[{}] <- {}", (Object)bridge1Ft.getNodeId(), (Object)bridge2port1.printTopology());
            return bridge2port1;
        }
        throw new BridgeTopologyException("condition2: bridge: no simple connection", bridge2Ft.getBridge());
    }

    public static BridgePort conditionA(BridgeForwardingTable bridge2Ft) throws BridgeTopologyException {
        BridgePort port = null;
        int size = 0;
        for (BridgePortWithMacs bft : bridge2Ft.getPorttomac()) {
            if (size > bft.getMacs().size()) continue;
            port = bft.getPort();
            size = bft.getMacs().size();
        }
        if (size == 0) {
            throw new BridgeTopologyException("conditionA: no elements in bft", bridge2Ft);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("conditionA: root bridge! selected port: bridge:[] <- {}", (Object)port.printTopology());
        }
        return port;
    }

    public static BridgePort conditionB(Set<String> commonlearnedmacs, BridgeForwardingTable bridge2Ft) throws BridgeTopologyException {
        if (bridge2Ft.getPorttomac().size() != 2) {
            throw new BridgeTopologyException("conditionB: bft has more then 2 forwarding ports", bridge2Ft);
        }
        HashSet<BridgePort> ports = new HashSet<BridgePort>();
        for (String mac : commonlearnedmacs) {
            ports.add(bridge2Ft.getMactoport().get(mac));
        }
        if (ports.size() != 1) {
            throw new BridgeTopologyException("conditionB: common macs have more then 1 forwarding port", bridge2Ft);
        }
        for (BridgePortWithMacs bft : bridge2Ft.getPorttomac()) {
            for (BridgePort parsed : ports) {
                if (bft.getPort().equals(parsed)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("conditionB: new bridge and common mac on only one port: bridge:[] <- {}", (Object)bft.getPort().printTopology());
                }
                return bft.getPort();
            }
        }
        throw new BridgeTopologyException("conditionB: error forwarding ports", bridge2Ft);
    }

    private static BridgePort condition1(BridgeForwardingTable bridge1Ft, BridgeForwardingTable bridge2Ft) throws BridgeTopologyException {
        for (String mac : bridge1Ft.getIdentifiers()) {
            if (!bridge2Ft.getMactoport().containsKey(mac)) continue;
            BridgePort bp = bridge2Ft.getMactoport().get(mac);
            if (LOG.isDebugEnabled()) {
                LOG.debug("condition1: {} -> bridge:[{}] identifier:[{}]", new Object[]{bp.printTopology(), bridge1Ft.getNodeId(), mac});
            }
            return bp;
        }
        throw new BridgeTopologyException("condition1: no bridge identifier found on fpt");
    }

    public static BridgeSimpleConnection createAndRun(BridgeForwardingTable xBridge, BridgeForwardingTable yBridge) throws BridgeTopologyException {
        BridgeSimpleConnection sp = new BridgeSimpleConnection(xBridge, yBridge);
        sp.findSimpleConnection();
        return sp;
    }

    @Override
    public String printTopology() {
        StringBuffer strbfr = new StringBuffer();
        strbfr.append("simple connection: [");
        if (this.m_xyPort != null) {
            strbfr.append(this.m_xyPort.printTopology());
        } else {
            strbfr.append("null");
        }
        strbfr.append("], <--> [");
        if (this.m_yxPort != null) {
            strbfr.append(this.m_yxPort.printTopology());
        } else {
            strbfr.append("null");
        }
        strbfr.append("]");
        return strbfr.toString();
    }
}

