/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.outage;

import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.core.utils.FuzzyDateFormatter;

@XmlRootElement(name="outage-summary")
@XmlAccessorType(value=XmlAccessType.NONE)
public class OutageSummary
implements Comparable<OutageSummary>,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="node-id")
    protected int nodeId;
    @XmlAttribute(name="node-label")
    protected String nodeLabel;
    @XmlAttribute(name="time-down")
    protected Date timeDown;
    @XmlAttribute(name="time-up")
    protected Date timeUp;
    @XmlAttribute(name="time-now")
    protected Date timeNow;

    public OutageSummary() {
    }

    public OutageSummary(int nodeId, String nodeLabel, Date timeDown, Date timeUp, Date timeNow) {
        if (timeDown == null) {
            throw new IllegalArgumentException(String.format("timeDown cannot be null.  nodeId=%d, nodeLabel=%s, timeDown=%s, timeUp=%s, timeNow=%s", nodeId, nodeLabel, timeDown, timeUp, timeNow));
        }
        this.nodeLabel = nodeLabel == null ? String.valueOf(nodeId) : nodeLabel;
        this.nodeId = nodeId;
        this.timeDown = timeDown;
        this.timeUp = timeUp;
        this.timeNow = timeNow;
    }

    public OutageSummary(int nodeId, String nodeLabel, Date timeDown, Date timeUp) {
        this(nodeId, nodeLabel, timeDown, timeUp, new Date());
    }

    public OutageSummary(int nodeId, String nodeLabel, Date timeDown) {
        this(nodeId, nodeLabel, timeDown, null, new Date());
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getHostname() {
        return this.nodeLabel;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public Date getTimeDown() {
        return this.timeDown;
    }

    public Date getTimeUp() {
        return this.timeUp;
    }

    public String getFuzzyTimeDown() {
        return FuzzyDateFormatter.calculateDifference((Date)this.getTimeDown(), (Date)new Date());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<OutageSummary: ");
        buffer.append(this.nodeId);
        buffer.append(":");
        buffer.append(this.nodeLabel);
        buffer.append(", down at ");
        buffer.append(this.timeDown);
        if (this.timeUp != null) {
            buffer.append(", back up at ");
            buffer.append(this.timeUp);
        }
        return buffer.toString();
    }

    @Override
    public int compareTo(OutageSummary that) {
        return new CompareToBuilder().append((Object)this.getTimeDown(), (Object)that.getTimeDown()).append((Object)this.getTimeUp(), (Object)that.getTimeUp()).append((Object)this.getHostname(), (Object)that.getHostname()).append((Object)this.getNodeLabel(), (Object)that.getNodeLabel()).toComparison();
    }
}

