/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceId
implements Comparable<ResourceId> {
    private static final Pattern PATTERN = Pattern.compile("(?:^|\\.)(?<type>\\w+)\\[(?<name>(?:    [^\\[\\]\\\\]    |    \\\\.)*)\\]", 4);
    public final ResourceId parent;
    public final String type;
    public final String name;

    private ResourceId(ResourceId parent, String type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("Type must be non-null");
        }
        if (!type.matches("\\w+")) {
            throw new IllegalArgumentException("Type must be a valid identifier");
        }
        this.parent = parent;
        this.type = type;
        this.name = name == null ? "" : name;
    }

    public ResourceId resolve(String type, String name) {
        return new ResourceId(this, type, name);
    }

    public static ResourceId get(ResourceId parent, String type, String name) {
        return new ResourceId(parent, type, name);
    }

    public static ResourceId get(String type, String name) {
        return new ResourceId(null, type, name);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.parent != null) {
            s.append(this.parent.toString());
            s.append('.');
        }
        s.append(ResourceId.escape(this.type));
        s.append('[');
        s.append(ResourceId.escape(this.name));
        s.append(']');
        return s.toString();
    }

    public static ResourceId fromString(String s) {
        if (s == null) {
            return null;
        }
        Matcher m = PATTERN.matcher(s);
        StringBuffer sb = new StringBuffer();
        ResourceId id = null;
        while (m.find()) {
            String type = ResourceId.unescape(m.group("type"));
            String name = ResourceId.unescape(m.group("name"));
            id = new ResourceId(id, type, name);
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        if (sb.length() > 0) {
            throw new IllegalArgumentException("Ill-formed resource ID: " + sb.toString());
        }
        return id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceId that = (ResourceId)o;
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ResourceId resourceId) {
        return this.toString().compareToIgnoreCase(resourceId.toString());
    }

    private static String escape(String raw) {
        return raw.replaceAll("[\\[\\]\\\\]", "\\\\$0");
    }

    private static String unescape(String escaped) {
        return escaped.replaceAll("\\\\(.)", "$1");
    }
}

