/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonBackReference;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="assetRecord")
@Entity
@Table(name="assets")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsAssetRecord
implements Serializable {
    private static final long serialVersionUID = -8259333820682056097L;
    public static final String AUTOENABLED = "A";
    public static final String SSH_CONNECTION = "ssh";
    public static final String TELNET_CONNECTION = "telnet";
    public static final String RSH_CONNECTION = "rsh";
    private Integer m_id;
    private String m_category = "Unspecified";
    private String m_manufacturer;
    private String m_vendor;
    private String m_modelNumber;
    private String m_serialNumber;
    private String m_description;
    private String m_circuitId;
    private String m_assetNumber;
    private String m_operatingSystem;
    private String m_rack;
    private String m_slot;
    private String m_port;
    private String m_region;
    private String m_division;
    private String m_department;
    private String m_building;
    private String m_floor;
    private String m_room;
    private String m_vendorPhone;
    private String m_vendorFax;
    private String m_vendorAssetNumber;
    private String m_username;
    private String m_password;
    private String m_enable;
    private String m_connection;
    private String m_autoenable;
    private String m_lastModifiedBy = "";
    private Date m_lastModifiedDate = new Date();
    private String m_dateInstalled;
    private String m_lease;
    private String m_leaseExpires;
    private String m_supportPhone;
    private String m_maintcontract;
    private String m_maintContractExpiration;
    private String m_displayCategory;
    private String m_notifyCategory;
    private String m_pollerCategory;
    private String m_thresholdCategory;
    private String m_comment;
    private String m_cpu;
    private String m_ram;
    private String m_storagectrl;
    private String m_hdd1;
    private String m_hdd2;
    private String m_hdd3;
    private String m_hdd4;
    private String m_hdd5;
    private String m_hdd6;
    private String m_numpowersupplies;
    private String m_inputpower;
    private String m_additionalhardware;
    private String m_admin;
    private String m_snmpcommunity;
    private String m_rackunitheight;
    private OnmsNode m_node;
    private String m_managedObjectType;
    private String m_managedObjectInstance;
    private OnmsGeolocation m_geolocation = new OnmsGeolocation();
    private String m_vmwareManagedObjectId;
    private String m_vmwareManagedEntityType;
    private String m_vmwareManagementServer;
    private String m_vmwareTopologyInfo;
    private String m_vmwareState;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @XmlIDREF
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @JsonBackReference
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="category", length=64)
    public String getCategory() {
        return this.m_category;
    }

    public void setCategory(String category) {
        this.m_category = category;
    }

    @Column(name="manufacturer")
    public String getManufacturer() {
        return this.m_manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.m_manufacturer = manufacturer;
    }

    @Column(name="vendor")
    public String getVendor() {
        return this.m_vendor;
    }

    public void setVendor(String vendor) {
        this.m_vendor = vendor;
    }

    @Column(name="modelNumber")
    public String getModelNumber() {
        return this.m_modelNumber;
    }

    public void setModelNumber(String modelnumber) {
        this.m_modelNumber = modelnumber;
    }

    @Column(name="serialNumber")
    public String getSerialNumber() {
        return this.m_serialNumber;
    }

    public void setSerialNumber(String serialnumber) {
        this.m_serialNumber = serialnumber;
    }

    @Column(name="description")
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Column(name="circuitId")
    public String getCircuitId() {
        return this.m_circuitId;
    }

    public void setCircuitId(String circuitid) {
        this.m_circuitId = circuitid;
    }

    @Column(name="assetNumber")
    public String getAssetNumber() {
        return this.m_assetNumber;
    }

    public void setAssetNumber(String assetnumber) {
        this.m_assetNumber = assetnumber;
    }

    @Column(name="operatingSystem")
    public String getOperatingSystem() {
        return this.m_operatingSystem;
    }

    public void setOperatingSystem(String operatingsystem) {
        this.m_operatingSystem = operatingsystem;
    }

    @Column(name="rack")
    public String getRack() {
        return this.m_rack;
    }

    public void setRack(String rack) {
        this.m_rack = rack;
    }

    @Column(name="slot")
    public String getSlot() {
        return this.m_slot;
    }

    public void setSlot(String slot) {
        this.m_slot = slot;
    }

    @Column(name="port", length=64)
    public String getPort() {
        return this.m_port;
    }

    public void setPort(String port) {
        this.m_port = port;
    }

    @Column(name="region")
    public String getRegion() {
        return this.m_region;
    }

    public void setRegion(String region) {
        this.m_region = region;
    }

    @Column(name="division")
    public String getDivision() {
        return this.m_division;
    }

    public void setDivision(String division) {
        this.m_division = division;
    }

    @Column(name="department")
    public String getDepartment() {
        return this.m_department;
    }

    public void setDepartment(String department) {
        this.m_department = department;
    }

    @Embedded
    @XmlTransient
    public OnmsGeolocation getGeolocation() {
        return this.m_geolocation;
    }

    public void setGeolocation(OnmsGeolocation geolocation) {
        this.m_geolocation = geolocation;
    }

    @Column(name="building")
    public String getBuilding() {
        return this.m_building;
    }

    public void setBuilding(String building) {
        this.m_building = building;
    }

    @Column(name="floor")
    public String getFloor() {
        return this.m_floor;
    }

    public void setFloor(String floor) {
        this.m_floor = floor;
    }

    @Column(name="room")
    public String getRoom() {
        return this.m_room;
    }

    public void setRoom(String room) {
        this.m_room = room;
    }

    @Column(name="vendorPhone")
    public String getVendorPhone() {
        return this.m_vendorPhone;
    }

    public void setVendorPhone(String vendorphone) {
        this.m_vendorPhone = vendorphone;
    }

    @Column(name="vendorFax")
    public String getVendorFax() {
        return this.m_vendorFax;
    }

    public void setVendorFax(String vendorfax) {
        this.m_vendorFax = vendorfax;
    }

    @Column(name="vendorAssetNumber")
    public String getVendorAssetNumber() {
        return this.m_vendorAssetNumber;
    }

    public void setVendorAssetNumber(String vendorassetnumber) {
        this.m_vendorAssetNumber = vendorassetnumber;
    }

    @Column(name="userLastModified", length=20)
    public String getLastModifiedBy() {
        return this.m_lastModifiedBy == null ? null : this.m_lastModifiedBy.trim();
    }

    public void setLastModifiedBy(String userlastmodified) {
        this.m_lastModifiedBy = userlastmodified;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastModifiedDate")
    public Date getLastModifiedDate() {
        return this.m_lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastmodifieddate) {
        this.m_lastModifiedDate = lastmodifieddate;
    }

    @Column(name="dateInstalled", length=64)
    public String getDateInstalled() {
        return this.m_dateInstalled;
    }

    public void setDateInstalled(String dateinstalled) {
        this.m_dateInstalled = dateinstalled;
    }

    @Column(name="lease")
    public String getLease() {
        return this.m_lease;
    }

    public void setLease(String lease) {
        this.m_lease = lease;
    }

    @Column(name="leaseExpires", length=64)
    public String getLeaseExpires() {
        return this.m_leaseExpires;
    }

    public void setLeaseExpires(String leaseexpires) {
        this.m_leaseExpires = leaseexpires;
    }

    @Column(name="supportPhone")
    public String getSupportPhone() {
        return this.m_supportPhone;
    }

    public void setSupportPhone(String supportphone) {
        this.m_supportPhone = supportphone;
    }

    @Column(name="maintcontract")
    public String getMaintcontract() {
        return this.m_maintcontract;
    }

    public void setMaintcontract(String maintcontract) {
        this.m_maintcontract = maintcontract;
    }

    @Transient
    public String getMaintContractNumber() {
        return this.getMaintcontract();
    }

    public void setMaintContractNumber(String maintcontract) {
        this.setMaintcontract(maintcontract);
    }

    @Column(name="maintContractExpires", length=64)
    public String getMaintContractExpiration() {
        return this.m_maintContractExpiration;
    }

    public void setMaintContractExpiration(String maintcontractexpires) {
        this.m_maintContractExpiration = maintcontractexpires;
    }

    @Column(name="displayCategory")
    public String getDisplayCategory() {
        return this.m_displayCategory;
    }

    public void setDisplayCategory(String displaycategory) {
        this.m_displayCategory = displaycategory;
    }

    @Column(name="notifyCategory")
    public String getNotifyCategory() {
        return this.m_notifyCategory;
    }

    public void setNotifyCategory(String notifycategory) {
        this.m_notifyCategory = notifycategory;
    }

    @Column(name="pollerCategory")
    public String getPollerCategory() {
        return this.m_pollerCategory;
    }

    public void setPollerCategory(String pollercategory) {
        this.m_pollerCategory = pollercategory;
    }

    @Column(name="thresholdCategory")
    public String getThresholdCategory() {
        return this.m_thresholdCategory;
    }

    public void setThresholdCategory(String thresholdcategory) {
        this.m_thresholdCategory = thresholdcategory;
    }

    @Column(name="comment")
    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    @Column(name="managedObjectType")
    public String getManagedObjectType() {
        return this.m_managedObjectType;
    }

    public void setManagedObjectType(String mot) {
        this.m_managedObjectType = mot;
    }

    @Column(name="managedObjectInstance")
    public String getManagedObjectInstance() {
        return this.m_managedObjectInstance;
    }

    public void setManagedObjectInstance(String moi) {
        this.m_managedObjectInstance = moi;
    }

    @Column(name="username")
    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    @Column(name="password")
    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    @Column(name="enable")
    public String getEnable() {
        return this.m_enable;
    }

    public void setEnable(String enable) {
        this.m_enable = enable;
    }

    @Column(name="connection", length=32)
    public String getConnection() {
        return this.m_connection;
    }

    public void setConnection(String connection) {
        this.m_connection = TELNET_CONNECTION.equalsIgnoreCase(connection) ? TELNET_CONNECTION : (SSH_CONNECTION.equalsIgnoreCase(connection) ? SSH_CONNECTION : (RSH_CONNECTION.equalsIgnoreCase(connection) ? RSH_CONNECTION : connection));
    }

    @Column(name="autoenable", length=1)
    public String getAutoenable() {
        return this.m_autoenable;
    }

    public void setAutoenable(String autoenable) {
        this.m_autoenable = autoenable;
    }

    @Column(name="cpu")
    public String getCpu() {
        return this.m_cpu;
    }

    public void setCpu(String cpu) {
        this.m_cpu = cpu;
    }

    @Column(name="ram")
    public String getRam() {
        return this.m_ram;
    }

    public void setRam(String ram) {
        this.m_ram = ram;
    }

    @Column(name="snmpcommunity", length=1)
    public String getSnmpcommunity() {
        return this.m_snmpcommunity;
    }

    public void setSnmpcommunity(String snmpcommunity) {
        this.m_snmpcommunity = snmpcommunity;
    }

    @Column(name="rackunitheight", length=2)
    public String getRackunitheight() {
        return this.m_rackunitheight;
    }

    public void setRackunitheight(String rackunitheight) {
        this.m_rackunitheight = rackunitheight;
    }

    @Column(name="admin")
    public String getAdmin() {
        return this.m_admin;
    }

    public void setAdmin(String admin) {
        this.m_admin = admin;
    }

    @Column(name="additionalhardware")
    public String getAdditionalhardware() {
        return this.m_additionalhardware;
    }

    public void setAdditionalhardware(String additionalhardware) {
        this.m_additionalhardware = additionalhardware;
    }

    @Column(name="inputpower", length=1)
    public String getInputpower() {
        return this.m_inputpower;
    }

    public void setInputpower(String inputpower) {
        this.m_inputpower = inputpower;
    }

    @Column(name="numpowersupplies", length=1)
    public String getNumpowersupplies() {
        return this.m_numpowersupplies;
    }

    public void setNumpowersupplies(String numpowersupplies) {
        this.m_numpowersupplies = numpowersupplies;
    }

    @Column(name="hdd6")
    public String getHdd6() {
        return this.m_hdd6;
    }

    public void setHdd6(String hdd6) {
        this.m_hdd6 = hdd6;
    }

    @Column(name="hdd5")
    public String getHdd5() {
        return this.m_hdd5;
    }

    public void setHdd5(String hdd5) {
        this.m_hdd5 = hdd5;
    }

    @Column(name="hdd4")
    public String getHdd4() {
        return this.m_hdd4;
    }

    public void setHdd4(String hdd4) {
        this.m_hdd4 = hdd4;
    }

    @Column(name="hdd3")
    public String getHdd3() {
        return this.m_hdd3;
    }

    public void setHdd3(String hdd3) {
        this.m_hdd3 = hdd3;
    }

    @Column(name="hdd2")
    public String getHdd2() {
        return this.m_hdd2;
    }

    public void setHdd2(String hdd2) {
        this.m_hdd2 = hdd2;
    }

    @Column(name="hdd1")
    public String getHdd1() {
        return this.m_hdd1;
    }

    public void setHdd1(String hdd1) {
        this.m_hdd1 = hdd1;
    }

    @Column(name="storagectrl")
    public String getStoragectrl() {
        return this.m_storagectrl;
    }

    public void setStoragectrl(String storagectrl) {
        this.m_storagectrl = storagectrl;
    }

    @Transient
    @Deprecated
    @XmlElement
    public String getAddress1() {
        return this.m_geolocation == null ? null : this.m_geolocation.getAddress1();
    }

    @Deprecated
    public void setAddress1(String address1) {
        if (this.m_geolocation != null) {
            this.m_geolocation.setAddress1(address1);
        }
    }

    @Transient
    @Deprecated
    @XmlElement
    public String getAddress2() {
        return this.m_geolocation == null ? null : this.m_geolocation.getAddress2();
    }

    @Deprecated
    public void setAddress2(String address2) {
        if (this.m_geolocation != null) {
            this.m_geolocation.setAddress2(address2);
        }
    }

    @Transient
    @Deprecated
    @XmlElement
    public String getCity() {
        return this.m_geolocation == null ? null : this.m_geolocation.getCity();
    }

    @Deprecated
    public void setCity(String city) {
        if (this.m_geolocation != null) {
            this.m_geolocation.setCity(city);
        }
    }

    @Transient
    @Deprecated
    @XmlElement
    public String getState() {
        return this.m_geolocation == null ? null : this.m_geolocation.getState();
    }

    @Deprecated
    public void setState(String state) {
        if (this.m_geolocation != null) {
            this.m_geolocation.setState(state);
        }
    }

    @Transient
    @Deprecated
    @XmlElement
    public String getZip() {
        return this.m_geolocation == null ? null : this.m_geolocation.getZip();
    }

    @Deprecated
    public void setZip(String zip) {
        if (this.m_geolocation != null) {
            this.m_geolocation.setZip(zip);
        }
    }

    @Transient
    @Deprecated
    @XmlElement
    public String getCountry() {
        return this.m_geolocation == null ? null : this.m_geolocation.getCountry();
    }

    @Deprecated
    public void setCountry(String country) {
        if (this.m_geolocation != null) {
            this.m_geolocation.setCountry(country);
        }
    }

    @Transient
    @Deprecated
    @XmlElement
    public Float getLongitude() {
        return this.m_geolocation == null ? null : this.m_geolocation.getLongitude();
    }

    @Deprecated
    public void setLongitude(Float longitude) {
        if (this.m_geolocation != null) {
            this.m_geolocation.setLongitude(longitude);
        }
    }

    @Transient
    @Deprecated
    @XmlElement
    public Float getLatitude() {
        return this.m_geolocation == null ? null : this.m_geolocation.getLatitude();
    }

    @Deprecated
    public void setLatitude(Float latitude) {
        if (this.m_geolocation != null) {
            this.m_geolocation.setLatitude(latitude);
        }
    }

    @Column(name="vmwareManagedEntityType")
    public String getVmwareManagedEntityType() {
        return this.m_vmwareManagedEntityType;
    }

    public void setVmwareManagedEntityType(String vmwareManagedEntityType) {
        this.m_vmwareManagedEntityType = vmwareManagedEntityType;
    }

    @Column(name="vmwareManagedObjectId")
    public String getVmwareManagedObjectId() {
        return this.m_vmwareManagedObjectId;
    }

    public void setVmwareManagedObjectId(String vmwareManagedObjectId) {
        this.m_vmwareManagedObjectId = vmwareManagedObjectId;
    }

    @Column(name="vmwareManagementServer")
    public String getVmwareManagementServer() {
        return this.m_vmwareManagementServer;
    }

    public void setVmwareManagementServer(String vmwareManagementServer) {
        this.m_vmwareManagementServer = vmwareManagementServer;
    }

    @Column(name="vmwareState")
    public String getVmwareState() {
        return this.m_vmwareState;
    }

    public void setVmwareState(String vmwareState) {
        this.m_vmwareState = vmwareState;
    }

    @Column(name="vmwareTopologyInfo")
    public String getVmwareTopologyInfo() {
        return this.m_vmwareTopologyInfo;
    }

    public void setVmwareTopologyInfo(String vmwareTopologyInfo) {
        this.m_vmwareTopologyInfo = vmwareTopologyInfo;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("category", (Object)this.getCategory()).append("manufacturer", (Object)this.getManufacturer()).append("vendor", (Object)this.getVendor()).append("modelnumber", (Object)this.getModelNumber()).append("serialnumber", (Object)this.getSerialNumber()).append("description", (Object)this.getDescription()).append("circuitid", (Object)this.getCircuitId()).append("assetnumber", (Object)this.getAssetNumber()).append("operatingsystem", (Object)this.getOperatingSystem()).append("rack", (Object)this.getRack()).append("slot", (Object)this.getSlot()).append("port", (Object)this.getPort()).append("region", (Object)this.getRegion()).append("division", (Object)this.getDivision()).append("department", (Object)this.getDepartment()).append("address1", this.m_geolocation == null ? null : this.m_geolocation.getAddress1()).append("address2", this.m_geolocation == null ? null : this.m_geolocation.getAddress2()).append("city", this.m_geolocation == null ? null : this.m_geolocation.getCity()).append("state", this.m_geolocation == null ? null : this.m_geolocation.getState()).append("zip", this.m_geolocation == null ? null : this.m_geolocation.getZip()).append("country", this.m_geolocation == null ? null : this.m_geolocation.getCountry()).append("longitude", this.m_geolocation == null ? null : this.m_geolocation.getLongitude()).append("latitude", this.m_geolocation == null ? null : this.m_geolocation.getLatitude()).append("building", (Object)this.getBuilding()).append("floor", (Object)this.getFloor()).append("room", (Object)this.getRoom()).append("username", (Object)this.getUsername()).append("password", (Object)this.getPassword()).append("enable", (Object)this.getEnable()).append("autoenable", (Object)this.getAutoenable()).append("connection", (Object)this.getConnection()).append("vendorphone", (Object)this.getVendorPhone()).append("vendorfax", (Object)this.getVendorFax()).append("vendorassetnumber", (Object)this.getVendorAssetNumber()).append("userlastmodified", (Object)this.getLastModifiedBy()).append("lastmodifieddate", (Object)this.getLastModifiedDate()).append("dateinstalled", (Object)this.getDateInstalled()).append("lease", (Object)this.getLease()).append("leaseexpires", (Object)this.getLeaseExpires()).append("supportphone", (Object)this.getSupportPhone()).append("maintcontract", (Object)this.getMaintcontract()).append("maintcontractexpires", (Object)this.getMaintContractExpiration()).append("displaycategory", (Object)this.getDisplayCategory()).append("notifycategory", (Object)this.getNotifyCategory()).append("pollercategory", (Object)this.getPollerCategory()).append("thresholdcategory", (Object)this.getThresholdCategory()).append("comment", (Object)this.getComment()).append("cpu", (Object)this.getCpu()).append("ram", (Object)this.getRam()).append("storagectrl", (Object)this.getStoragectrl()).append("hdd1", (Object)this.getHdd1()).append("hdd2", (Object)this.getHdd2()).append("hdd3", (Object)this.getHdd3()).append("hdd4", (Object)this.getHdd4()).append("hdd5", (Object)this.getHdd5()).append("hdd6", (Object)this.getHdd6()).append("numpowersupplies", (Object)this.getNumpowersupplies()).append("inputpower", (Object)this.getInputpower()).append("additionalhardware", (Object)this.getAdditionalhardware()).append("admin", (Object)this.getAdmin()).append("snmpcommunity", (Object)this.getSnmpcommunity()).append("rackunitheight", (Object)this.getRackunitheight()).append("vmwareManagedObjectId", (Object)this.getVmwareManagedObjectId()).append("vmwareManagedEntityType", (Object)this.getVmwareManagedEntityType()).append("vmwareManagementServer", (Object)this.getVmwareManagementServer()).append("vmwareTopologyInfo", (Object)this.getVmwareTopologyInfo()).append("vmwareState", (Object)this.getVmwareState()).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            throw new IllegalArgumentException("the Operation Object passed is either null or of the wrong class");
        }
        OnmsAssetRecord cmpAsset = (OnmsAssetRecord)obj;
        Integer newNodeId = cmpAsset.getNode().getId();
        if (newNodeId == null) {
            return false;
        }
        return this.m_node.getId().equals(cmpAsset.getNode().getId());
    }

    public int hashCode() {
        return 223 * this.m_node.getId().hashCode();
    }

    public void mergeRecord(OnmsAssetRecord newRecord) {
        if (!this.equals(newRecord)) {
            return;
        }
        OnmsGeolocation toGeolocation = this.getGeolocation();
        if (toGeolocation == null) {
            toGeolocation = new OnmsGeolocation();
            this.setGeolocation(toGeolocation);
        }
        OnmsGeolocation fromGeolocation = newRecord.getGeolocation();
        BeanWrapper currentBean = PropertyAccessorFactory.forBeanPropertyAccess((Object)this);
        BeanWrapper newBean = PropertyAccessorFactory.forBeanPropertyAccess((Object)newRecord);
        PropertyDescriptor[] pds = newBean.getPropertyDescriptors();
        ArrayList<String> blackListedProperties = new ArrayList<String>();
        blackListedProperties.add("class");
        blackListedProperties.add("city");
        blackListedProperties.add("zip");
        blackListedProperties.add("state");
        blackListedProperties.add("country");
        blackListedProperties.add("longitude");
        blackListedProperties.add("latitude");
        blackListedProperties.add("address1");
        blackListedProperties.add("address2");
        for (PropertyDescriptor pd : pds) {
            String propertyName = pd.getName();
            if (blackListedProperties.contains(propertyName) || newBean.getPropertyValue(propertyName) == null) continue;
            currentBean.setPropertyValue(propertyName, newBean.getPropertyValue(propertyName));
        }
        toGeolocation.mergeGeolocation(fromGeolocation);
        this.setGeolocation(toGeolocation);
    }
}

