/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import java.net.InetAddress;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.opennms.core.time.ZonedDateTimeBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.StringUtils;

public class EventBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(EventBuilder.class);
    private Event m_event;
    private ZonedDateTimeBuilder zonedDateTimeBuilder = null;

    public EventBuilder() {
        this.m_event = new Event();
    }

    public EventBuilder(String uei, String source) {
        this(uei, source, new Date());
    }

    public EventBuilder(String uei, String source, Date date) {
        this.m_event = new Event();
        this.setUei(uei);
        this.setTime(date);
        this.setSource(source);
    }

    public EventBuilder(Event event) {
        this.m_event = event;
        Date now = new Date();
        this.setTime(now);
    }

    public Date currentEventTime() {
        if (this.m_event.getTime() == null && this.zonedDateTimeBuilder != null) {
            ZonedDateTime time = this.zonedDateTimeBuilder.build();
            return Date.from(time.toInstant());
        }
        return this.m_event.getTime();
    }

    public Event getEvent() {
        if (this.m_event.getTime() == null && this.zonedDateTimeBuilder != null) {
            ZonedDateTime time = this.zonedDateTimeBuilder.build();
            this.m_event.setTime(Date.from(time.toInstant()));
        }
        if (this.m_event.getCreationTime() == null) {
            this.m_event.setCreationTime(new Date());
        }
        return this.m_event;
    }

    public Log getLog() {
        Event event = this.getEvent();
        Events events = new Events();
        events.setEvent(new Event[]{event});
        Header header = new Header();
        header.setCreated(org.opennms.core.utils.StringUtils.toStringEfficiently((Date)event.getCreationTime()));
        Log log = new Log();
        log.setHeader(header);
        log.setEvents(events);
        return log;
    }

    public EventBuilder setUei(String uei) {
        this.m_event.setUei(uei);
        return this;
    }

    public EventBuilder setTime(Date date) {
        this.m_event.setTime(date);
        return this;
    }

    protected ZonedDateTimeBuilder getZonedDateTimeBuilder() {
        if (this.zonedDateTimeBuilder == null) {
            this.zonedDateTimeBuilder = new ZonedDateTimeBuilder();
        }
        return this.zonedDateTimeBuilder;
    }

    public EventBuilder setYear(int value) {
        this.getZonedDateTimeBuilder().setYear(Integer.valueOf(value));
        return this;
    }

    public EventBuilder setMonth(int value) {
        this.getZonedDateTimeBuilder().setMonth(Integer.valueOf(value));
        return this;
    }

    public EventBuilder setDayOfMonth(int value) {
        this.getZonedDateTimeBuilder().setDayOfMonth(Integer.valueOf(value));
        return this;
    }

    public EventBuilder setHourOfDay(int value) {
        this.getZonedDateTimeBuilder().setHourOfDay(Integer.valueOf(value));
        return this;
    }

    public EventBuilder setMinute(int value) {
        this.getZonedDateTimeBuilder().setMinute(Integer.valueOf(value));
        return this;
    }

    public EventBuilder setSecond(int value) {
        this.getZonedDateTimeBuilder().setSecond(Integer.valueOf(value));
        return this;
    }

    public EventBuilder setMillisecond(int value) {
        this.getZonedDateTimeBuilder().setNanosecond(Integer.valueOf(value * 1000));
        return this;
    }

    public EventBuilder setZoneId(ZoneId value) {
        this.getZonedDateTimeBuilder().setZoneId(value);
        return this;
    }

    public EventBuilder setSource(String source) {
        this.m_event.setSource(source);
        return this;
    }

    public EventBuilder setSeverity(String severity) {
        this.m_event.setSeverity(OnmsSeverity.get(severity).getLabel());
        return this;
    }

    public EventBuilder setNodeid(long nodeid) {
        this.m_event.setNodeid(Long.valueOf(nodeid));
        return this;
    }

    public EventBuilder setHost(String hostname) {
        this.m_event.setHost(hostname);
        return this;
    }

    public EventBuilder setInterface(InetAddress ipAddress) {
        if (ipAddress != null) {
            this.m_event.setInterfaceAddress(ipAddress);
        }
        return this;
    }

    public EventBuilder setIfIndex(int ifIndex) {
        this.m_event.setIfIndex(Integer.valueOf(ifIndex));
        return this;
    }

    public EventBuilder setService(String serviceName) {
        this.m_event.setService(serviceName);
        return this;
    }

    public EventBuilder addParam(String parmName, String val) {
        return this.addParam(parmName, val, null, null);
    }

    public EventBuilder addParam(String parmName, String val, String type, String encoding) {
        if (parmName != null) {
            Value value = new Value();
            value.setContent(val);
            if (type != null) {
                value.setType(type);
            }
            if (encoding != null) {
                value.setEncoding(encoding);
            }
            Parm parm = new Parm();
            parm.setParmName(parmName);
            parm.setValue(value);
            this.addParam(parm);
        }
        return this;
    }

    public EventBuilder addParam(Parm parm) {
        this.m_event.addParm(parm);
        return this;
    }

    public EventBuilder addParam(String parmName, boolean val) {
        if (parmName != null) {
            Value value = new Value();
            value.setContent(val ? "true" : "false");
            Parm parm = new Parm();
            parm.setParmName(parmName);
            parm.setValue(value);
            this.addParam(parm);
        }
        return this;
    }

    public EventBuilder setParam(String parmName, String val) {
        if (this.m_event.getParmCollection().size() < 1) {
            return this.addParam(parmName, val);
        }
        for (Parm parm : this.m_event.getParmCollection()) {
            if (!parm.getParmName().equals(parmName)) continue;
            Value value = new Value();
            value.setContent(val);
            parm.setValue(value);
            return this;
        }
        return this.addParam(parmName, val);
    }

    public EventBuilder setParam(String parmName, int val) {
        return this.setParam(parmName, Integer.toString(val));
    }

    public EventBuilder addParam(String parmName, double val) {
        return this.addParam(parmName, Double.toString(val));
    }

    public EventBuilder addParam(String parmName, long val) {
        return this.addParam(parmName, Long.toString(val));
    }

    public EventBuilder addParam(String parmName, int val) {
        return this.addParam(parmName, Integer.toString(val));
    }

    public EventBuilder addParam(String parmName, char ch) {
        return this.addParam(parmName, Character.toString(ch));
    }

    public EventBuilder addParam(String parmName, Collection<String> vals) {
        String val = StringUtils.collectionToCommaDelimitedString(vals);
        return this.addParam(parmName, val);
    }

    public EventBuilder setAlarmData(AlarmData alarmData) {
        if (alarmData != null) {
            this.m_event.setAlarmData(alarmData);
        }
        return this;
    }

    public EventBuilder setNode(OnmsNode node) {
        if (node != null) {
            this.m_event.setNodeid(Long.valueOf(node.getId().longValue()));
        }
        return this;
    }

    public EventBuilder setIpInterface(OnmsIpInterface iface) {
        if (iface != null) {
            if (iface.getNode() != null) {
                this.m_event.setNodeid(Long.valueOf(iface.getNode().getId().longValue()));
            }
            this.m_event.setInterfaceAddress(iface.getIpAddress());
        }
        return this;
    }

    public EventBuilder setMonitoredService(OnmsMonitoredService monitoredService) {
        if (monitoredService != null) {
            this.m_event.setNodeid(Long.valueOf(monitoredService.getNodeId().longValue()));
            this.m_event.setInterfaceAddress(monitoredService.getIpAddress());
            this.m_event.setService(monitoredService.getServiceName());
        }
        return this;
    }

    public EventBuilder setSnmpVersion(String version) {
        this.ensureSnmp();
        this.m_event.getSnmp().setVersion(version);
        return this;
    }

    private void ensureSnmp() {
        if (this.m_event.getSnmp() == null) {
            this.m_event.setSnmp(new Snmp());
        }
    }

    public EventBuilder setCommunity(String community) {
        this.ensureSnmp();
        this.m_event.getSnmp().setCommunity(community);
        return this;
    }

    public EventBuilder setEnterpriseId(String enterprise) {
        this.ensureSnmp();
        this.m_event.getSnmp().setId(enterprise);
        return this;
    }

    public EventBuilder setGeneric(int generic) {
        this.ensureSnmp();
        this.m_event.getSnmp().setGeneric(Integer.valueOf(generic));
        return this;
    }

    public EventBuilder setSpecific(int specific) {
        this.ensureSnmp();
        this.m_event.getSnmp().setSpecific(Integer.valueOf(specific));
        return this;
    }

    public EventBuilder setSnmpHost(String snmpHost) {
        this.m_event.setSnmphost(snmpHost);
        return this;
    }

    public EventBuilder setSnmpTimeStamp(long timeStamp) {
        this.ensureSnmp();
        this.m_event.getSnmp().setTimeStamp(Long.valueOf(timeStamp));
        return this;
    }

    public void setField(String name, String val) {
        if (name.equals("eventparms")) {
            String[] parts;
            for (String part : parts = val.split(";")) {
                String[] pair = part.split("=");
                this.addParam(pair[0], pair[1].replaceFirst("[(]\\w+,\\w+[)]", ""));
            }
        } else {
            BeanWrapper w = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.m_event);
            try {
                w.setPropertyValue(name, (Object)val);
            }
            catch (BeansException e) {
                LOG.warn("Could not set field on event: {}", (Object)name, (Object)e);
            }
        }
    }

    private void ensureLogmsg() {
        if (this.m_event.getLogmsg() == null) {
            this.m_event.setLogmsg(new Logmsg());
        }
    }

    public EventBuilder setLogDest(String dest) {
        this.ensureLogmsg();
        this.m_event.getLogmsg().setDest(dest);
        return this;
    }

    public EventBuilder setLogMessage(String content) {
        this.ensureLogmsg();
        this.m_event.getLogmsg().setContent(content);
        return this;
    }

    public EventBuilder setDescription(String descr) {
        this.m_event.setDescr(descr);
        return this;
    }

    public EventBuilder setParms(List<Parm> parms) {
        this.m_event.setParmCollection(parms);
        return this;
    }

    public EventBuilder setUuid(String uuid) {
        this.m_event.setUuid(uuid);
        return this;
    }

    public EventBuilder setDistPoller(String distPoller) {
        this.m_event.setDistPoller(distPoller);
        return this;
    }

    public EventBuilder setMasterStation(String masterStation) {
        this.m_event.setMasterStation(masterStation);
        return this;
    }
}

