/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2007-2014 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2014 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.netmgt.model;

/**
 * OpenNMS Trouble Ticket State Enumerations.
 *
 * @author <a href="mailto:brozow@opennms.org">Mathew Brozowski</a>
 * @author <a href="mailto:david@opennms.org">David Hustace</a>
 * @author <a href="mailto:dschlenk@convergeone.com">David Schlenk</a>
 * @version $Id: $
 */
public enum TroubleTicketState {
    /* KEEP THESE IN ORDER or the DEFAULT ALARM VACUUM QUERIES will BREAK */
    
    /* TODO: once JPA 2.1+ in use, change things that use this to also use a
     * javax.persistence.AttributeConverter<TroubleTicketState, Integer> that
     * returns TroubleTicketState.getValue() in the converter. That should
     * maintain backwords compatibility to the current default 
     * Enum.toOrdinal() JPA behavior and prevent breaking when reordering items
     * in the Enum. 
     */
    
    OPEN(0),
    CREATE_PENDING(1),
    CREATE_FAILED(2),
    UPDATE_PENDING(3),
    UPDATE_FAILED(4),
    CLOSED(5),
    CLOSE_PENDING(6),
    CLOSE_FAILED(7),
    RESOLVED(8),
    RESOLVE_PENDING(9),
    RESOLVE_FAILED(10),
    CANCELLED(11),
    CANCEL_PENDING(12),
    CANCEL_FAILED(13);

    private final int m_value;

    TroubleTicketState(int value) {
        m_value = value;
    }
    
    public int getValue() {
        return this.m_value;
    }

}
