/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.model.OnmsMonitoringSystem;
import org.springframework.core.style.ToStringCreator;

@Entity
@DiscriminatorValue(value="Remote Poller")
@XmlRootElement(name="locationMonitor")
public class OnmsLocationMonitor
extends OnmsMonitoringSystem
implements Comparable<OnmsLocationMonitor> {
    private static final long serialVersionUID = 7923969022838262552L;
    private MonitorStatus m_status = MonitorStatus.REGISTERED;

    @Enumerated(value=EnumType.STRING)
    @Column(name="status", length=31, nullable=false)
    public MonitorStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(MonitorStatus status) {
        this.m_status = status;
    }

    @Transient
    public String getName() {
        return this.getLocation() + '-' + this.getId();
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("status", (Object)this.m_status).toString();
    }

    @Override
    public int compareTo(OnmsLocationMonitor o) {
        int diff = this.getLocation().compareTo(o.getLocation());
        if (diff != 0) {
            return diff;
        }
        return this.getId().compareTo(o.getId());
    }

    public static enum MonitorStatus {
        REGISTERED,
        STARTED,
        STOPPED,
        DISCONNECTED,
        PAUSED,
        CONFIG_CHANGED,
        DELETED;

    }
}

