/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;
import org.opennms.netmgt.model.HwEntityAttributeType;
import org.opennms.netmgt.model.NodeIdAdapter;
import org.opennms.netmgt.model.OnmsHwEntityAttribute;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="hwEntity")
@Entity
@Table(name="hwEntity")
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsHwEntity
implements Serializable,
Comparable<OnmsHwEntity> {
    private static final long serialVersionUID = -543872118396806431L;
    private Integer m_id;
    private Integer m_entPhysicalIndex;
    private Integer m_entPhysicalParentRelPos;
    private Integer m_entPhysicalContainedIn;
    private String m_entPhysicalName;
    private String m_entPhysicalDescr;
    private String m_entPhysicalAlias;
    private String m_entPhysicalVendorType;
    private String m_entPhysicalClass;
    private String m_entPhysicalMfgName;
    private String m_entPhysicalModelName;
    private String m_entPhysicalHardwareRev;
    private String m_entPhysicalFirmwareRev;
    private String m_entPhysicalSoftwareRev;
    private String m_entPhysicalSerialNum;
    private String m_entPhysicalAssetID;
    private Boolean m_entPhysicalIsFRU;
    private Date m_entPhysicalMfgDate;
    private String m_entPhysicalUris;
    private OnmsNode m_node;
    private SortedSet<OnmsHwEntityAttribute> m_hwAttributes = new TreeSet<OnmsHwEntityAttribute>();
    private OnmsHwEntity m_parent;
    private SortedSet<OnmsHwEntity> m_children = new TreeSet<OnmsHwEntity>();

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @XmlID
    @XmlAttribute(name="entityId")
    @Transient
    public String getOnmsHwEntityId() {
        return this.getId() == null ? null : this.getId().toString();
    }

    public void setOnmsHwEntityId(String id) {
        this.setId(Integer.valueOf(id));
    }

    @Column(nullable=false)
    @XmlAttribute
    public Integer getEntPhysicalIndex() {
        return this.m_entPhysicalIndex;
    }

    public void setEntPhysicalIndex(Integer entPhysicalIndex) {
        this.m_entPhysicalIndex = entPhysicalIndex;
    }

    @Transient
    @XmlTransient
    public Integer getEntPhysicalContainedIn() {
        return this.m_entPhysicalContainedIn;
    }

    public void setEntPhysicalContainedIn(Integer entPhysicalContainedIn) {
        this.m_entPhysicalContainedIn = entPhysicalContainedIn;
    }

    @Column
    @XmlElement
    public String getEntPhysicalDescr() {
        return this.m_entPhysicalDescr;
    }

    public void setEntPhysicalDescr(String entPhysicalDescr) {
        this.m_entPhysicalDescr = entPhysicalDescr;
    }

    @Column
    @XmlElement
    public String getEntPhysicalVendorType() {
        return this.m_entPhysicalVendorType;
    }

    public void setEntPhysicalVendorType(String entPhysicalVendorType) {
        this.m_entPhysicalVendorType = entPhysicalVendorType;
    }

    @Column
    @XmlElement
    public String getEntPhysicalClass() {
        return this.m_entPhysicalClass;
    }

    public void setEntPhysicalClass(String entPhysicalClass) {
        this.m_entPhysicalClass = entPhysicalClass;
    }

    @Column
    @XmlTransient
    public Integer getEntPhysicalParentRelPos() {
        return this.m_entPhysicalParentRelPos;
    }

    public void setEntPhysicalParentRelPos(Integer entPhysicalParentRelPos) {
        this.m_entPhysicalParentRelPos = entPhysicalParentRelPos;
    }

    @Column
    @XmlElement
    public String getEntPhysicalName() {
        return this.m_entPhysicalName;
    }

    public void setEntPhysicalName(String entPhysicalName) {
        this.m_entPhysicalName = entPhysicalName;
    }

    @Column
    @XmlElement
    public String getEntPhysicalHardwareRev() {
        return this.m_entPhysicalHardwareRev;
    }

    public void setEntPhysicalHardwareRev(String entPhysicalHardwareRev) {
        this.m_entPhysicalHardwareRev = entPhysicalHardwareRev;
    }

    @Column
    @XmlElement
    public String getEntPhysicalFirmwareRev() {
        return this.m_entPhysicalFirmwareRev;
    }

    public void setEntPhysicalFirmwareRev(String entPhysicalFirmwareRev) {
        this.m_entPhysicalFirmwareRev = entPhysicalFirmwareRev;
    }

    @Column
    @XmlElement
    public String getEntPhysicalSoftwareRev() {
        return this.m_entPhysicalSoftwareRev;
    }

    public void setEntPhysicalSoftwareRev(String entPhysicalSoftwareRev) {
        this.m_entPhysicalSoftwareRev = entPhysicalSoftwareRev;
    }

    @Column
    @XmlElement
    public String getEntPhysicalSerialNum() {
        return this.m_entPhysicalSerialNum;
    }

    public void setEntPhysicalSerialNum(String entPhysicalSerialNum) {
        this.m_entPhysicalSerialNum = entPhysicalSerialNum;
    }

    @Column
    @XmlElement
    public String getEntPhysicalMfgName() {
        return this.m_entPhysicalMfgName;
    }

    public void setEntPhysicalMfgName(String entPhysicalMfgName) {
        this.m_entPhysicalMfgName = entPhysicalMfgName;
    }

    @Column
    @XmlElement
    public String getEntPhysicalModelName() {
        return this.m_entPhysicalModelName;
    }

    public void setEntPhysicalModelName(String entPhysicalModelName) {
        this.m_entPhysicalModelName = entPhysicalModelName;
    }

    @Column
    @XmlElement
    public String getEntPhysicalAlias() {
        return this.m_entPhysicalAlias;
    }

    public void setEntPhysicalAlias(String entPhysicalAlias) {
        this.m_entPhysicalAlias = entPhysicalAlias;
    }

    @Column
    @XmlElement
    public String getEntPhysicalAssetID() {
        return this.m_entPhysicalAssetID;
    }

    public void setEntPhysicalAssetID(String entPhysicalAssetID) {
        this.m_entPhysicalAssetID = entPhysicalAssetID;
    }

    @Column
    @XmlElement
    public Boolean getEntPhysicalIsFRU() {
        return this.m_entPhysicalIsFRU;
    }

    public void setEntPhysicalIsFRU(Boolean entPhysicalIsFRU) {
        this.m_entPhysicalIsFRU = entPhysicalIsFRU;
    }

    @Column
    @XmlElement
    public Date getEntPhysicalMfgDate() {
        return this.m_entPhysicalMfgDate;
    }

    public void setEntPhysicalMfgDate(Date entPhysicalMfgDate) {
        this.m_entPhysicalMfgDate = entPhysicalMfgDate;
    }

    @Column
    @XmlElement
    public String getEntPhysicalUris() {
        return this.m_entPhysicalUris;
    }

    public void setEntPhysicalUris(String entPhysicalUris) {
        this.m_entPhysicalUris = entPhysicalUris;
    }

    @XmlTransient
    @ManyToOne(cascade={CascadeType.ALL}, optional=true)
    @JoinColumn(name="parentId")
    public OnmsHwEntity getParent() {
        return this.m_parent;
    }

    public void setParent(OnmsHwEntity parent) {
        this.m_parent = parent;
    }

    @Transient
    @XmlAttribute(name="parentPhysicalIndex")
    public Integer getParentIndex() {
        return this.m_parent == null ? null : this.m_parent.getEntPhysicalIndex();
    }

    @XmlElement(name="hwEntity")
    @XmlElementWrapper(name="children")
    @Sort(type=SortType.NATURAL, comparator=OnmsHwEntity.class)
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public SortedSet<OnmsHwEntity> getChildren() {
        return this.m_children;
    }

    public void setChildren(SortedSet<OnmsHwEntity> children) {
        if (children != null) {
            this.m_children = children;
        }
    }

    public void addChildEntity(OnmsHwEntity child) {
        child.setParent(this);
        this.getChildren().add(child);
    }

    public OnmsHwEntity getChildByIndex(Integer entPhysicalIndex) {
        for (OnmsHwEntity child : this.m_children) {
            if (child.getEntPhysicalIndex() != entPhysicalIndex) continue;
            return child;
        }
        return null;
    }

    public void removeChild(OnmsHwEntity child) {
        if (this.m_children != null) {
            this.m_children.remove(child);
        }
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlAttribute(name="nodeId")
    @XmlJavaTypeAdapter(value=NodeIdAdapter.class)
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        if (node == null) {
            return;
        }
        this.m_node = node;
        if (this.m_children == null) {
            return;
        }
        for (OnmsHwEntity child : this.m_children) {
            child.setNode(node);
        }
    }

    @OneToMany(mappedBy="hwEntity", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Sort(type=SortType.NATURAL)
    @XmlElement(name="hwEntityAttribute")
    @XmlElementWrapper(name="vendorAttributes")
    public SortedSet<OnmsHwEntityAttribute> getHwEntityAttributes() {
        return this.m_hwAttributes;
    }

    public void setHwEntityAttributes(SortedSet<OnmsHwEntityAttribute> hwAttributes) {
        if (hwAttributes != null) {
            this.m_hwAttributes = hwAttributes;
        }
    }

    public void addAttribute(HwEntityAttributeType type, String value) {
        OnmsHwEntityAttribute attr = new OnmsHwEntityAttribute(type, value);
        attr.setHwEntity(this);
        this.m_hwAttributes.add(attr);
    }

    public OnmsHwEntityAttribute getAttribute(String typeName) {
        for (OnmsHwEntityAttribute attr : this.m_hwAttributes) {
            if (!attr.getTypeName().equals(typeName)) continue;
            return attr;
        }
        return null;
    }

    public String getAttributeValue(String typeName) {
        OnmsHwEntityAttribute attr = this.getAttribute(typeName);
        return attr == null ? null : attr.getValue();
    }

    public String getAttributeClass(String typeName) {
        OnmsHwEntityAttribute attr = this.getAttribute(typeName);
        return attr == null ? null : attr.getType().getAttributeClass();
    }

    @Transient
    public boolean isRoot() {
        return this.m_parent == null || this.m_entPhysicalContainedIn == 0;
    }

    @Transient
    public boolean hasChildren() {
        return !this.m_hwAttributes.isEmpty();
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this.getClass().getSimpleName(), ToStringStyle.SHORT_PREFIX_STYLE);
        if (this.m_node != null) {
            b.append("nodeId", (Object)this.m_node.getId());
        }
        if (this.getParentIndex() != null) {
            b.append("parentPhysicalIndex", (Object)this.getParentIndex());
        }
        if (this.m_entPhysicalIndex != null) {
            b.append("entPhysicalIndex", (Object)this.m_entPhysicalIndex);
        }
        if (this.m_entPhysicalName != null) {
            b.append("entPhysicalName", (Object)this.m_entPhysicalName);
        }
        if (this.m_entPhysicalDescr != null) {
            b.append("entPhysicalDescr", (Object)this.m_entPhysicalDescr);
        }
        if (this.m_entPhysicalAlias != null) {
            b.append("entPhysicalAlias", (Object)this.m_entPhysicalAlias);
        }
        if (this.m_entPhysicalVendorType != null) {
            b.append("entPhysicalVendorType", (Object)this.m_entPhysicalVendorType);
        }
        if (this.m_entPhysicalClass != null) {
            b.append("entPhysicalClass", (Object)this.m_entPhysicalClass);
        }
        if (this.m_entPhysicalMfgName != null) {
            b.append("entPhysicalMfgName", (Object)this.m_entPhysicalMfgName);
        }
        if (this.m_entPhysicalModelName != null) {
            b.append("entPhysicalModelName", (Object)this.m_entPhysicalModelName);
        }
        if (this.m_entPhysicalHardwareRev != null) {
            b.append("entPhysicalHardwareRev", (Object)this.m_entPhysicalHardwareRev);
        }
        if (this.m_entPhysicalFirmwareRev != null) {
            b.append("entPhysicalFirmwareRev", (Object)this.m_entPhysicalFirmwareRev);
        }
        if (this.m_entPhysicalSoftwareRev != null) {
            b.append("entPhysicalSoftwareRev", (Object)this.m_entPhysicalSoftwareRev);
        }
        if (this.m_entPhysicalSerialNum != null) {
            b.append("entPhysicalSerialNum", (Object)this.m_entPhysicalSerialNum);
        }
        if (!this.m_hwAttributes.isEmpty()) {
            b.append("vendorAttributes", (Object)this.m_hwAttributes.toString());
        }
        if (!this.m_children.isEmpty()) {
            b.append("children", (Object)this.m_children.toString());
        }
        return b.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof OnmsHwEntity) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    @Override
    public int compareTo(OnmsHwEntity o) {
        if (o == null) {
            return -1;
        }
        return this.toString().compareTo(o.toString());
    }

    public void fixRelationships() {
        for (OnmsHwEntityAttribute attrib : this.m_hwAttributes) {
            attrib.setHwEntity(this);
        }
        if (this.m_children == null) {
            return;
        }
        for (OnmsHwEntity child : this.m_children) {
            child.setParent(this);
            child.fixRelationships();
        }
    }
}

