/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonManagedReference;
import org.hibernate.annotations.Formula;
import org.opennms.netmgt.model.ScanReportLog;
import org.opennms.netmgt.model.ScanReportPollResult;

@Entity
@Table(name="scanReports")
@XmlRootElement(name="scan-report")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ScanReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERY_APPLICATIONS = "applications";
    @XmlID
    @XmlAttribute(name="id", required=true)
    private String m_id = UUID.randomUUID().toString();
    @XmlAttribute(name="location", required=true)
    private String m_location;
    @XmlAttribute(name="locale")
    private String m_locale;
    @XmlAttribute(name="timestamp")
    private Date m_timestamp;
    @XmlElementWrapper(name="properties")
    private Map<String, String> m_properties = new LinkedHashMap<String, String>();
    @XmlElementWrapper(name="poll-results")
    @XmlElement(name="poll-result")
    @JsonManagedReference
    private List<ScanReportPollResult> m_scanReportPollResults = new ArrayList<ScanReportPollResult>();
    @XmlTransient
    @JsonIgnore
    private ScanReportLog m_logs;

    public ScanReport() {
    }

    public ScanReport(ScanReport pkg) {
        this.m_id = pkg.getId();
        this.m_locale = pkg.getLocale();
        this.m_location = pkg.getLocation();
        this.m_timestamp = pkg.getTimestamp();
        this.m_properties = pkg.getProperties();
        this.m_scanReportPollResults = pkg.getPollResults();
        this.m_logs = pkg.getLog();
    }

    @Id
    @Column(name="id", unique=true)
    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    @ElementCollection
    @JoinTable(name="scanReportProperties", joinColumns={@JoinColumn(name="scanReportId")})
    @MapKeyColumn(name="property", nullable=false)
    @Column(name="propertyValue")
    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.m_properties = properties;
    }

    public void addProperty(String name, String value) {
        this.m_properties.put(name, value);
    }

    public void addProperty(Map.Entry<String, String> entry) {
        this.m_properties.put(entry.getKey(), entry.getValue());
    }

    @Transient
    public String getProperty(String name) {
        return this.m_properties.get(name);
    }

    @Formula(value="(select coalesce((select p.propertyvalue from scanreportproperties p where p.scanreportid = id and p.property = 'applications')))")
    @XmlTransient
    @JsonIgnore
    public String getApplications() {
        return this.getProperty(PROPERY_APPLICATIONS);
    }

    public void setApplications(String applications) {
        this.addProperty(PROPERY_APPLICATIONS, applications);
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public void setLocale(String m_locale) {
        this.m_locale = m_locale;
    }

    public Date getTimestamp() {
        return this.m_timestamp;
    }

    public void setTimestamp(Date m_timestamp) {
        this.m_timestamp = m_timestamp;
    }

    @OneToMany(mappedBy="scanReport", orphanRemoval=true, cascade={CascadeType.ALL})
    public List<ScanReportPollResult> getPollResults() {
        return this.m_scanReportPollResults;
    }

    public void setPollResults(List<ScanReportPollResult> scanReportPollResults) {
        this.m_scanReportPollResults = scanReportPollResults;
    }

    public boolean addPollResult(ScanReportPollResult scanReportPollResult) {
        scanReportPollResult.setScanReport(this);
        return this.m_scanReportPollResults.add(scanReportPollResult);
    }

    @OneToOne(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @PrimaryKeyJoinColumn
    public ScanReportLog getLog() {
        return this.m_logs;
    }

    public void setLog(ScanReportLog logs) {
        this.m_logs = logs;
    }

    @Transient
    public boolean isUp() {
        if (this.m_scanReportPollResults != null) {
            for (ScanReportPollResult result : this.m_scanReportPollResults) {
                if (result.isUp()) continue;
                return false;
            }
        }
        return true;
    }

    @Transient
    public boolean isAvailable() {
        if (this.m_scanReportPollResults != null) {
            for (ScanReportPollResult result : this.m_scanReportPollResults) {
                if (result.isAvailable()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "ScanReport [id=" + this.m_id + ", location=" + this.m_location + ", locale=" + this.m_locale + ", timestamp=" + this.m_timestamp + ", properties=" + this.m_properties + ", pollResults=" + this.m_scanReportPollResults + "]";
    }
}

