/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="isisElement")
public final class IsIsElement
implements Serializable {
    private static final long serialVersionUID = -3134355798509685991L;
    private Integer m_id;
    private String m_isisSysID;
    private IsisAdminState m_isisSysAdminState;
    private Date m_isisNodeCreateTime = new Date();
    private Date m_isisNodeLastPollTime;
    private OnmsNode m_node;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    @Column(name="isisSysAdminState", nullable=false)
    @Type(type="org.opennms.netmgt.model.IsIsAdminStateUserType")
    public IsisAdminState getIsisSysAdminState() {
        return this.m_isisSysAdminState;
    }

    @Column(name="isisSysID", length=32, nullable=false)
    public String getIsisSysID() {
        return this.m_isisSysID;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="isisNodeCreateTime", nullable=false)
    public Date getIsisNodeCreateTime() {
        return this.m_isisNodeCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="isisNodeLastPollTime", nullable=false)
    public Date getIsisNodeLastPollTime() {
        return this.m_isisNodeLastPollTime;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    public void setIsisSysID(String isisSysID) {
        this.m_isisSysID = isisSysID;
    }

    public void setIsisSysAdminState(IsisAdminState isisSysAdminState) {
        this.m_isisSysAdminState = isisSysAdminState;
    }

    public void setIsisNodeCreateTime(Date isisNodeCreateTime) {
        this.m_isisNodeCreateTime = isisNodeCreateTime;
    }

    public void setIsisNodeLastPollTime(Date isisNodeLastPollTime) {
        this.m_isisNodeLastPollTime = isisNodeLastPollTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("NodeId", (Object)this.m_node.getId()).append("isisSysAdminState", (Object)IsisAdminState.getTypeString(this.m_isisSysAdminState.getValue())).append("isisSysID", (Object)this.m_isisSysID).append("isisNodeCreateTime", (Object)this.m_isisNodeCreateTime).append("isisNodeLastPollTime", (Object)this.m_isisNodeLastPollTime).toString();
    }

    public void merge(IsIsElement element) {
        if (element == null) {
            return;
        }
        this.setIsisSysID(element.getIsisSysID());
        this.setIsisSysAdminState(element.getIsisSysAdminState());
        this.setIsisNodeLastPollTime(element.getIsisNodeCreateTime());
    }

    public static enum IsisAdminState {
        on(1),
        off(2);

        private int m_value;
        protected static final Map<Integer, String> s_typeMap;

        private IsisAdminState(int value) {
            this.m_value = value;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public static IsisAdminState get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create IsisAdminState from null code");
            }
            switch (code) {
                case 1: {
                    return on;
                }
                case 2: {
                    return off;
                }
            }
            throw new IllegalArgumentException("Cannot create IsisAdminState from code " + code);
        }

        public Integer getValue() {
            return this.m_value;
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "on");
            s_typeMap.put(2, "off");
        }
    }
}

