/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AckAction {
    UNSPECIFIED(1, "Unspecified"),
    ACKNOWLEDGE(2, "Acknowledge"),
    UNACKNOWLEDGE(3, "Unacknowledge"),
    ESCALATE(4, "Escalate"),
    CLEAR(5, "Clear");

    private static final Map<Integer, AckAction> m_idMap;
    private static final List<Integer> m_ids;
    private int m_id;
    private String m_label;

    private AckAction(int id, String label) {
        this.m_id = id;
        this.m_label = label;
    }

    private Integer getId() {
        return this.m_id;
    }

    public String toString() {
        return this.m_label;
    }

    public static AckAction get(int id) {
        if (m_idMap.containsKey(id)) {
            return m_idMap.get(id);
        }
        throw new IllegalArgumentException("Cannot create AckAction from unknown ID " + id);
    }

    static {
        m_ids = new ArrayList<Integer>(AckAction.values().length);
        m_idMap = new HashMap<Integer, AckAction>(AckAction.values().length);
        for (AckAction action : AckAction.values()) {
            m_ids.add(action.getId());
            m_idMap.put(action.getId(), action);
        }
    }
}

