/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AckType {
    UNSPECIFIED(1, "Unspecified"),
    ALARM(2, "Alarm"),
    NOTIFICATION(3, "Notification");

    private static final Map<Integer, AckType> m_idMap;
    private static final List<Integer> m_ids;
    private int m_id;
    private String m_label;

    private AckType(int id, String label) {
        this.m_id = id;
        this.m_label = label;
    }

    private Integer getId() {
        return this.m_id;
    }

    public String toString() {
        return this.m_label;
    }

    public static AckType get(int id) {
        if (m_idMap.containsKey(id)) {
            return m_idMap.get(id);
        }
        throw new IllegalArgumentException("Cannot create AckType from unknown ID: " + id);
    }

    static {
        m_ids = new ArrayList<Integer>(AckType.values().length);
        m_idMap = new HashMap<Integer, AckType>(AckType.values().length);
        for (AckType action : AckType.values()) {
            m_ids.add(action.getId());
            m_idMap.put(action.getId(), action);
        }
    }
}

