/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeTopology {
    private static final Logger LOG = LoggerFactory.getLogger(BridgeTopology.class);
    private List<BridgeTopologyLink> bridgelinks = new ArrayList<BridgeTopologyLink>();
    private Map<String, Set<BridgeTopologyPort>> bridgeAssociatedMacAddressMap = new HashMap<String, Set<BridgeTopologyPort>>();
    private List<BridgeTopologyLinkCandidate> bridgeTopologyPortCandidates = new ArrayList<BridgeTopologyLinkCandidate>();

    public void addBridgeAssociatedMac(Integer nodeid, Integer port, Set<String> macsonport, String mac) {
        LOG.info("addBridgeAssociatedMac: adding nodeid {}, bridge port {}, mac {}", new Object[]{nodeid, port, mac});
        if (this.bridgeAssociatedMacAddressMap.containsKey(mac)) {
            this.bridgeAssociatedMacAddressMap.get(mac).add(new BridgeTopologyPort(nodeid, port, macsonport));
        } else {
            HashSet<BridgeTopologyPort> ports = new HashSet<BridgeTopologyPort>();
            ports.add(new BridgeTopologyPort(nodeid, port, macsonport));
            this.bridgeAssociatedMacAddressMap.put(mac, ports);
        }
    }

    private boolean parsed(BridgeTopologyPort bridgePort) {
        for (BridgeTopologyLink link : this.bridgelinks) {
            if (!link.contains(bridgePort)) continue;
            return true;
        }
        return false;
    }

    public void addTopology(Integer nodeid, Map<Integer, Set<String>> bridgeTopologyTable, Set<Integer> targets) {
        LOG.info("addTopology: -----------------------------------------------------");
        LOG.info("addTopology: adding bridge topology for node {} with targets {}", (Object)nodeid, targets);
        for (Map.Entry<Integer, Set<String>> curEntry : bridgeTopologyTable.entrySet()) {
            LOG.info("addTopology: node {}, port {}: mac {}", new Object[]{nodeid, curEntry.getKey(), curEntry.getValue()});
            BridgeTopologyLinkCandidate candidate = new BridgeTopologyLinkCandidate(new BridgeTopologyPort(nodeid, curEntry.getKey(), curEntry.getValue()));
            candidate.setTargets(targets);
            this.bridgeTopologyPortCandidates.add(candidate);
        }
    }

    public void parseBFT(Integer nodeid, Map<Integer, Set<String>> bridgeForwardingTable) {
        LOG.info("parseBFT: -----------------------------------------------------");
        LOG.info("parseBFT: start: parsing bridge forwarding table for node {}", (Object)nodeid);
        for (Map.Entry<Integer, Set<String>> curEntry : bridgeForwardingTable.entrySet()) {
            BridgeTopologyPort bridgetopologyport = new BridgeTopologyPort(nodeid, curEntry.getKey(), curEntry.getValue());
            if (this.parsed(bridgetopologyport)) {
                LOG.info("parseBFT: node {}, port {} has been previuosly parsed. Skipping.", (Object)nodeid, (Object)curEntry.getKey());
                continue;
            }
            BridgeTopologyLinkCandidate topologycandidate = new BridgeTopologyLinkCandidate(bridgetopologyport);
            for (String mac : curEntry.getValue()) {
                if (!this.bridgeAssociatedMacAddressMap.containsKey(mac)) continue;
                for (BridgeTopologyPort swPort : this.bridgeAssociatedMacAddressMap.get(mac)) {
                    if (swPort.getNodeid().intValue() == nodeid.intValue()) continue;
                    LOG.info("parseBFT: node {}, port {}: mac {} found on bridge adding target: targetnodeid {}, targetport {}", new Object[]{nodeid, curEntry.getKey(), mac, swPort.getNodeid(), swPort.getBridgePort()});
                    topologycandidate.setLinkPortCandidate(swPort);
                    topologycandidate.addTarget(swPort.getNodeid());
                }
            }
            LOG.info("parseBFT: node {} port {} macs {} targets {} role {}", new Object[]{topologycandidate.getBridgeTopologyPort().getNodeid(), topologycandidate.getBridgeTopologyPort().getBridgePort(), topologycandidate.getMacs(), topologycandidate.getTargets(), topologycandidate.getRole()});
            this.bridgeTopologyPortCandidates.add(this.parseBFTEntry(topologycandidate));
        }
        HashSet<BridgeTopologyLinkCandidate> secondStep = new HashSet<BridgeTopologyLinkCandidate>();
        for (BridgeTopologyLinkCandidate candidateA : this.bridgeTopologyPortCandidates) {
            if (candidateA.getRole() != BridgePortRole.BACKBONE) continue;
            for (BridgeTopologyLinkCandidate candidateB : this.bridgeTopologyPortCandidates) {
                if (candidateB.getBridgeTopologyPort().getNodeid().intValue() != candidateA.getBridgeTopologyPort().getNodeid().intValue() || candidateB.getRole() != null || candidateB.getLinkPortCandidate() == null || !candidateA.getTargets().contains(candidateB.getLinkPortCandidate().getNodeid())) continue;
                LOG.info("parseBFT: rule A: only one backbone port: BACKBONE node {} port {} targets {}: setting port {} to DIRECT", new Object[]{candidateA.getBridgeTopologyPort().getNodeid(), candidateA.getBridgeTopologyPort().getBridgePort(), candidateA.getTargets(), candidateB.getBridgeTopologyPort().getBridgePort()});
                candidateB.setRole(BridgePortRole.DIRECT);
                candidateB.setLinkPortCandidate(null);
                secondStep.add(candidateB);
            }
        }
        for (BridgeTopologyLinkCandidate candidateA : secondStep) {
            for (BridgeTopologyLinkCandidate candidateB : this.bridgeTopologyPortCandidates) {
                if (candidateB.getBridgeTopologyPort().getNodeid().intValue() == candidateA.getBridgeTopologyPort().getNodeid().intValue() || candidateB.getRole() == BridgePortRole.DIRECT) continue;
                HashSet<String> otherMacs = new HashSet<String>();
                for (String mac : candidateA.getMacs()) {
                    if (!candidateB.getMacs().contains(mac)) continue;
                    otherMacs.add(mac);
                }
                if (otherMacs.isEmpty()) continue;
                LOG.info("parseBFT: rule B: found DIRECT: node {} BACKBONE port {}: removing mac {} and adding target {}", new Object[]{candidateB.getBridgeTopologyPort().getNodeid(), candidateB.getBridgeTopologyPort().getBridgePort(), otherMacs, candidateA.getBridgeTopologyPort().getNodeid()});
                candidateB.removeMacs(otherMacs);
                candidateB.addTarget(candidateA.getBridgeTopologyPort().getNodeid());
            }
        }
        for (BridgeTopologyLinkCandidate candidate : this.bridgeTopologyPortCandidates) {
            candidate.setRole(null);
        }
        LOG.info("parseBFT: end: bridge forwarding table for node {}", (Object)nodeid);
    }

    private BridgeTopologyLinkCandidate parseBFTEntry(BridgeTopologyLinkCandidate topologyLinkCandidate) {
        for (BridgeTopologyLinkCandidate linkcandidate : this.bridgeTopologyPortCandidates) {
            LOG.info("parseBFTEntry: cycle top: checking node {} port {} macs {} targets {} role {}", new Object[]{linkcandidate.getBridgeTopologyPort().getNodeid(), linkcandidate.getBridgeTopologyPort().getBridgePort(), linkcandidate.getMacs(), linkcandidate.getTargets(), linkcandidate.getRole()});
            if (linkcandidate.getBridgeTopologyPort().getNodeid().intValue() == topologyLinkCandidate.getBridgeTopologyPort().getNodeid().intValue()) {
                LOG.info("parseBFTEntry: rule 0: same node do nothing");
                continue;
            }
            if (linkcandidate.intersectionNull(topologyLinkCandidate)) {
                LOG.info("parseBFTEntry: rule 00: mac intesection null do nothing");
                continue;
            }
            if (linkcandidate.getRole() == BridgePortRole.BACKBONE && topologyLinkCandidate.strictContainedPort(linkcandidate)) {
                LOG.info("parseBFTEntry: rule 1-d: BACKBONE checking: setting candidate to DIRECT");
                linkcandidate.removeMacs(topologyLinkCandidate.getMacs());
                topologyLinkCandidate.setRole(BridgePortRole.DIRECT);
                linkcandidate.addTarget(topologyLinkCandidate.getBridgeTopologyPort().getNodeid());
            } else if (topologyLinkCandidate.getRole() == BridgePortRole.BACKBONE && linkcandidate.strictContainedPort(topologyLinkCandidate)) {
                LOG.info("parseBFTEntry: rule 1-r: BACKBONE candidate: setting checking to DIRECT");
                topologyLinkCandidate.removeMacs(linkcandidate.getMacs());
                topologyLinkCandidate.addTarget(linkcandidate.getBridgeTopologyPort().getNodeid());
                linkcandidate.setRole(BridgePortRole.DIRECT);
            } else if (topologyLinkCandidate.strictContainedPort(linkcandidate)) {
                LOG.info("parseBFTEntry: rule 2-d: candidate strict contained: setting: candidate to DIRECT: checking to BACKBONE");
                linkcandidate.setRole(BridgePortRole.BACKBONE);
                linkcandidate.removeMacs(topologyLinkCandidate.getMacs());
                linkcandidate.addTarget(topologyLinkCandidate.getBridgeTopologyPort().getNodeid());
                topologyLinkCandidate.setRole(BridgePortRole.DIRECT);
            } else if (linkcandidate.strictContainedPort(topologyLinkCandidate)) {
                LOG.info("parseBFTEntry: rule 2-r: candidate strict contains: setting: candidate to BACKBONE: checking to DIRECT");
                topologyLinkCandidate.setRole(BridgePortRole.BACKBONE);
                topologyLinkCandidate.removeMacs(linkcandidate.getMacs());
                topologyLinkCandidate.addTarget(linkcandidate.getBridgeTopologyPort().getNodeid());
                linkcandidate.setRole(BridgePortRole.DIRECT);
            } else if (linkcandidate.getLinkPortCandidate() == null && topologyLinkCandidate.getLinkPortCandidate() == null) {
                LOG.info("parseBFTEntry: rule 3: port candidate each other");
                linkcandidate.setLinkPortCandidate(topologyLinkCandidate.getBridgeTopologyPort());
                topologyLinkCandidate.setLinkPortCandidate(linkcandidate.getBridgeTopologyPort());
            } else if (linkcandidate.getLinkPortCandidate() != null && topologyLinkCandidate.getBridgeTopologyPort().getNodeid().intValue() == linkcandidate.getLinkPortCandidate().getNodeid().intValue() && topologyLinkCandidate.getBridgeTopologyPort().getBridgePort().intValue() != linkcandidate.getLinkPortCandidate().getBridgePort().intValue()) {
                LOG.info("parseBFTEntry: rule 4-d: checking forwards on two different ports on candidate: setting: candidate  to DIRECT: checking to BACKBONE");
                linkcandidate.setRole(BridgePortRole.BACKBONE);
                linkcandidate.removeMacs(topologyLinkCandidate.getMacs());
                linkcandidate.addTarget(topologyLinkCandidate.getBridgeTopologyPort().getNodeid());
                topologyLinkCandidate.setRole(BridgePortRole.DIRECT);
                topologyLinkCandidate.setLinkPortCandidate(null);
            } else if (topologyLinkCandidate.getLinkPortCandidate() != null && linkcandidate.getBridgeTopologyPort().getNodeid().intValue() == topologyLinkCandidate.getLinkPortCandidate().getNodeid().intValue() && linkcandidate.getBridgeTopologyPort().getBridgePort().intValue() != topologyLinkCandidate.getLinkPortCandidate().getBridgePort().intValue()) {
                LOG.info("parseBFTEntry: rule 4-r: candidate forwards on two different ports on checking: setting: candidate to BACKBONE: checking to DIRECT");
                topologyLinkCandidate.setRole(BridgePortRole.BACKBONE);
                topologyLinkCandidate.removeMacs(linkcandidate.getMacs());
                topologyLinkCandidate.addTarget(linkcandidate.getBridgeTopologyPort().getNodeid());
                linkcandidate.setRole(BridgePortRole.DIRECT);
                linkcandidate.setLinkPortCandidate(null);
            }
            LOG.info("parseBFTEntry: cycle end: node {} port {} macs {} targets {} role {}", new Object[]{topologyLinkCandidate.getBridgeTopologyPort().getNodeid(), topologyLinkCandidate.getBridgeTopologyPort().getBridgePort(), topologyLinkCandidate.getMacs(), topologyLinkCandidate.getTargets(), topologyLinkCandidate.getRole()});
            LOG.info("parseBFTEntry: cycle end: node {} port {} macs {} targets {} role {}", new Object[]{linkcandidate.getBridgeTopologyPort().getNodeid(), linkcandidate.getBridgeTopologyPort().getBridgePort(), linkcandidate.getMacs(), linkcandidate.getTargets(), linkcandidate.getRole()});
        }
        return topologyLinkCandidate;
    }

    public void parseSTPEntry(Integer nodeid, Integer bridgePort, Set<String> macs, Integer designatednodeid, Integer designatedport, Set<String> designatedmacs) {
        BridgeTopologyPort source = new BridgeTopologyPort(nodeid, bridgePort, macs);
        BridgeTopologyPort designated = new BridgeTopologyPort(designatednodeid, designatedport, designatedmacs);
        BridgeTopologyLinkCandidate sourceLink = new BridgeTopologyLinkCandidate(source);
        BridgeTopologyLinkCandidate designatedLink = new BridgeTopologyLinkCandidate(designated);
        BridgeTopologyLink link = new BridgeTopologyLink(source, designated);
        LOG.info("parseSTPEntry: macs on bridge {}.", macs);
        LOG.info("parseSTPEntry: macs on designated bridge {}.", designatedmacs);
        LOG.info("parseSTPEntry: nodeid {}, port {}, designated nodeid {}, designated port {}, macs on link {}.", new Object[]{nodeid, bridgePort, designatednodeid, designatedport, link.getMacs()});
        if (sourceLink.intersectionNull(designatedLink)) {
            this.bridgelinks.add(link);
        } else {
            sourceLink.addTarget(designatednodeid);
            designatedLink.addTarget(nodeid);
            this.bridgeTopologyPortCandidates.add(this.parseBFTEntry(sourceLink));
            this.bridgeTopologyPortCandidates.add(this.parseBFTEntry(designatedLink));
        }
    }

    public List<BridgeTopologyLink> getTopology() {
        for (BridgeTopologyLinkCandidate candidateA : this.bridgeTopologyPortCandidates) {
            if (this.parsed(candidateA.getBridgeTopologyPort()) || candidateA.getTargets().isEmpty()) continue;
            for (BridgeTopologyLinkCandidate candidateB : this.bridgeTopologyPortCandidates) {
                if (this.parsed(candidateA.getBridgeTopologyPort()) || candidateB.getTargets().isEmpty() || candidateA.getBridgeTopologyPort().getNodeid() >= candidateB.getBridgeTopologyPort().getNodeid()) continue;
                LOG.info("getTopology: bridgetobridge discovery: parsing nodeidA {}, portA {}, targetsA {}.", new Object[]{candidateA.getBridgeTopologyPort().getNodeid(), candidateA.getBridgeTopologyPort().getBridgePort(), candidateA.getTargets()});
                LOG.info("getTopology: bridgetobridge discovery: parsing nodeidB {}, portB {}, targetsB {}.", new Object[]{candidateB.getBridgeTopologyPort().getNodeid(), candidateB.getBridgeTopologyPort().getBridgePort(), candidateB.getTargets()});
                if (!candidateA.getTargets().contains(candidateB.getBridgeTopologyPort().getNodeid()) || !candidateB.getTargets().contains(candidateA.getBridgeTopologyPort().getNodeid())) continue;
                boolean linkFound = true;
                for (Integer targetA : candidateA.getTargets()) {
                    if (targetA.intValue() == candidateB.getBridgeTopologyPort().getNodeid().intValue() || !candidateB.getTargets().contains(targetA)) continue;
                    LOG.info("getTopology: bridgetobridge discovery: bridge found {} between A and B: skipping", new Object[]{targetA, candidateA.getBridgeTopologyPort().getNodeid(), candidateB.getBridgeTopologyPort().getNodeid()});
                    linkFound = false;
                    break;
                }
                if (!linkFound) continue;
                BridgeTopologyLink link = new BridgeTopologyLink(candidateA.getBridgeTopologyPort(), candidateB.getBridgeTopologyPort());
                LOG.info("getTopology: bridgetobridge discovery: link found {}", (Object)link);
                this.bridgelinks.add(link);
            }
        }
        for (BridgeTopologyLinkCandidate candidate : this.bridgeTopologyPortCandidates) {
            if (this.parsed(candidate.getBridgeTopologyPort())) continue;
            LOG.info("getTopology: mac discovery: parsing nodeid {}, port {}, macs {}, targets {}.", new Object[]{candidate.getBridgeTopologyPort().getNodeid(), candidate.getBridgeTopologyPort().getBridgePort(), candidate.getMacs(), candidate.getTargets()});
            BridgeTopologyLink link = new BridgeTopologyLink(new BridgeTopologyPort(candidate.getBridgeTopologyPort().getNodeid(), candidate.getBridgeTopologyPort().getBridgePort(), candidate.getMacs()));
            LOG.info("getTopology: bridgetomac link found {}", (Object)link);
            this.bridgelinks.add(link);
        }
        return this.bridgelinks;
    }

    public class BridgeTopologyLink {
        private final BridgeTopologyPort bridgePort;
        private BridgeTopologyPort designatebridgePort;
        private Set<String> macs = new HashSet<String>();

        public BridgeTopologyLink(BridgeTopologyPort bridgeport) {
            this.bridgePort = bridgeport;
            this.macs = bridgeport.getMacs();
        }

        public BridgeTopologyLink(BridgeTopologyPort bridgeport, BridgeTopologyPort designatedbridgePort) {
            this.bridgePort = bridgeport;
            this.designatebridgePort = designatedbridgePort;
            for (String mac : bridgeport.getMacs()) {
                if (!designatedbridgePort.getMacs().contains(mac)) continue;
                this.macs.add(mac);
            }
        }

        public Set<String> getMacs() {
            return this.macs;
        }

        public BridgeTopologyPort getBridgeTopologyPort() {
            return this.bridgePort;
        }

        public BridgeTopologyPort getDesignateBridgePort() {
            return this.designatebridgePort;
        }

        public boolean contains(BridgeTopologyPort bridgeport) {
            if (this.bridgePort.equals(bridgeport)) {
                return true;
            }
            return this.designatebridgePort != null && this.designatebridgePort.equals(bridgeport);
        }
    }

    public class BridgeTopologyPort {
        private final Integer nodeid;
        private final Integer bridgePort;
        private final Set<String> macs;

        public BridgeTopologyPort(Integer nodeid, Integer bridgePort, Set<String> macs) {
            this.nodeid = nodeid;
            this.bridgePort = bridgePort;
            this.macs = macs;
        }

        public Set<String> getMacs() {
            return this.macs;
        }

        public Integer getNodeid() {
            return this.nodeid;
        }

        public Integer getBridgePort() {
            return this.bridgePort;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bridgePort == null ? 0 : this.bridgePort.hashCode());
            result = 31 * result + (this.nodeid == null ? 0 : this.nodeid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BridgeTopologyPort other = (BridgeTopologyPort)obj;
            if (this.bridgePort == null ? other.bridgePort != null : !this.bridgePort.equals(other.bridgePort)) {
                return false;
            }
            return !(this.nodeid == null ? other.nodeid != null : !this.nodeid.equals(other.nodeid));
        }
    }

    public class BridgeTopologyLinkCandidate {
        private final BridgeTopologyPort bridgeTopologyPort;
        private Set<String> macs = new HashSet<String>();
        private Set<Integer> targets = new HashSet<Integer>();
        private BridgePortRole role;
        private BridgeTopologyPort linkportcandidate;

        public BridgeTopologyLinkCandidate(BridgeTopologyPort btp) {
            this.bridgeTopologyPort = btp;
            this.macs = this.bridgeTopologyPort.getMacs();
        }

        public void removeMacs(Set<String> otherMacs) {
            HashSet<String> curmacs = new HashSet<String>();
            for (String mac : this.getMacs()) {
                if (otherMacs.contains(mac)) continue;
                curmacs.add(mac);
            }
            this.macs = curmacs;
        }

        public Set<String> getMacs() {
            return this.macs;
        }

        public boolean intersectionNull(BridgeTopologyLinkCandidate portcandidate) {
            for (String mac : this.getMacs()) {
                if (!portcandidate.getMacs().contains(mac)) continue;
                return false;
            }
            return true;
        }

        public boolean strictContainedPort(BridgeTopologyLinkCandidate portcandidate) {
            if (portcandidate.getBridgeTopologyPort().getMacs().size() <= this.getBridgeTopologyPort().getMacs().size()) {
                return false;
            }
            for (String mac : this.getBridgeTopologyPort().getMacs()) {
                if (portcandidate.getBridgeTopologyPort().getMacs().contains(mac)) continue;
                return false;
            }
            return true;
        }

        public boolean strictContained(BridgeTopologyLinkCandidate portcandidate) {
            if (portcandidate.getMacs().size() <= this.getMacs().size()) {
                return this.strictContainedPort(portcandidate);
            }
            for (String mac : this.getMacs()) {
                if (portcandidate.getMacs().contains(mac)) continue;
                return false;
            }
            return true;
        }

        public BridgeTopologyPort getBridgeTopologyPort() {
            return this.bridgeTopologyPort;
        }

        public Set<Integer> getTargets() {
            return this.targets;
        }

        public void setTargets(Set<Integer> targets) {
            this.targets = targets;
        }

        public void addTarget(Integer target) {
            this.targets.add(target);
        }

        public BridgePortRole getRole() {
            return this.role;
        }

        public void setRole(BridgePortRole role) {
            this.role = role;
        }

        public BridgeTopologyPort getLinkPortCandidate() {
            return this.linkportcandidate;
        }

        public void setLinkPortCandidate(BridgeTopologyPort linkportcandidate) {
            this.linkportcandidate = linkportcandidate;
        }
    }

    public static enum BridgePortRole {
        BACKBONE,
        DIRECT;

    }
}

