/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="stpInterface")
@Entity
@Table(name="stpInterface", uniqueConstraints={@UniqueConstraint(columnNames={"nodeId", "bridgePort", "stpVlan"})})
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsStpInterface {
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_bridgePort;
    private Integer m_ifIndex = -1;
    private StpPortStatus m_stpPortState;
    private Integer m_stpPortPathCost;
    private String m_stpPortDesignatedRoot;
    private Integer m_stpPortDesignatedCost;
    private String m_stpPortDesignatedBridge;
    private String m_stpPortDesignatedPort;
    private OnmsArpInterface.StatusType m_status = OnmsArpInterface.StatusType.UNKNOWN;
    private Date m_lastPollTime;
    private Integer m_vlan;

    public OnmsStpInterface() {
    }

    public OnmsStpInterface(Integer bridgePort, Integer vlanIndex) {
        this.m_bridgePort = bridgePort;
        this.m_vlan = vlanIndex;
    }

    public OnmsStpInterface(OnmsNode node, Integer bridgePort, Integer vlanIndex) {
        this.m_node = node;
        this.m_bridgePort = bridgePort;
        this.m_vlan = vlanIndex;
    }

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId().toString();
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.m_ifIndex = ifIndex;
    }

    @XmlElement
    @Column
    public StpPortStatus getStpPortState() {
        return this.m_stpPortState;
    }

    public void setStpPortState(StpPortStatus stpPortState) {
        this.m_stpPortState = stpPortState;
    }

    @XmlElement
    @Column
    public Integer getStpPortPathCost() {
        return this.m_stpPortPathCost;
    }

    public void setStpPortPathCost(Integer stpPortPathCost) {
        this.m_stpPortPathCost = stpPortPathCost;
    }

    @XmlElement
    @Column(length=16)
    public String getStpPortDesignatedRoot() {
        return this.m_stpPortDesignatedRoot;
    }

    public void setStpPortDesignatedRoot(String stpPortDesignatedRoot) {
        this.m_stpPortDesignatedRoot = stpPortDesignatedRoot;
    }

    @XmlElement
    @Column
    public Integer getStpPortDesignatedCost() {
        return this.m_stpPortDesignatedCost;
    }

    public void setStpPortDesignatedCost(Integer stpPortDesignatedCost) {
        this.m_stpPortDesignatedCost = stpPortDesignatedCost;
    }

    @XmlAttribute
    @Column(nullable=false)
    public OnmsArpInterface.StatusType getStatus() {
        return this.m_status;
    }

    public void setStatus(OnmsArpInterface.StatusType status) {
        this.m_status = status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    @XmlElement
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    @XmlElement
    @Column(nullable=false)
    public Integer getBridgePort() {
        return this.m_bridgePort;
    }

    public void setBridgePort(Integer bridgePort) {
        this.m_bridgePort = bridgePort;
    }

    @XmlElement
    @Column(length=16)
    public String getStpPortDesignatedBridge() {
        return this.m_stpPortDesignatedBridge;
    }

    public void setStpPortDesignatedBridge(String stpPortDesignatedBridge) {
        this.m_stpPortDesignatedBridge = stpPortDesignatedBridge;
    }

    @XmlElement
    @Column(length=4)
    public String getStpPortDesignatedPort() {
        return this.m_stpPortDesignatedPort;
    }

    public void setStpPortDesignatedPort(String stpPortDesignatedPort) {
        this.m_stpPortDesignatedPort = stpPortDesignatedPort;
    }

    @XmlElement(name="stpVlan")
    @Column(name="stpVlan", nullable=false)
    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    @Embeddable
    public static class StpPortStatus
    implements Comparable<StpPortStatus>,
    Serializable {
        private static final long serialVersionUID = 7669097061380115150L;
        public static final int STP_PORT_STATUS_UNKNOWN = 0;
        public static final int STP_PORT_STATUS_DISABLED = 1;
        public static final int STP_PORT_STATUS_BLOCKING = 2;
        public static final int STP_PORT_STATUS_LISTENING = 3;
        public static final int STP_PORT_STATUS_LEARNING = 4;
        public static final int STP_PORT_STATUS_FORWARDING = 5;
        public static final int STP_PORT_STATUS_BROKEN = 6;
        private static final Integer[] s_order = new Integer[]{0, 1, 2, 3, 4, 5, 6};
        private Integer m_stpPortStatus;
        private static final Map<Integer, String> stpPortStatusMap = new HashMap<Integer, String>();
        public static final StpPortStatus UNKNOWN;
        public static final StpPortStatus DISABLED;
        public static final StpPortStatus BLOCKING;
        public static final StpPortStatus LISTENING;
        public static final StpPortStatus LEARNING;
        public static final StpPortStatus FORWARDING;
        public static final StpPortStatus BROKEN;

        private StpPortStatus() {
        }

        public StpPortStatus(Integer stpPortStatus) {
            this.m_stpPortStatus = stpPortStatus;
        }

        @Column(name="stpPortState")
        public Integer getIntCode() {
            return this.m_stpPortStatus;
        }

        public void setIntCode(Integer stpPortStatus) {
            this.m_stpPortStatus = stpPortStatus;
        }

        @Override
        public int compareTo(StpPortStatus o) {
            return StpPortStatus.getIndex(this.m_stpPortStatus) - StpPortStatus.getIndex(o.m_stpPortStatus);
        }

        private static int getIndex(Integer code) {
            for (int i = 0; i < s_order.length; ++i) {
                if (s_order[i] != code) continue;
                return i;
            }
            throw new IllegalArgumentException("illegal stpPortStatus code '" + code + "'");
        }

        public boolean equals(Object o) {
            if (o instanceof StpPortStatus) {
                return this.m_stpPortStatus.intValue() == ((StpPortStatus)o).m_stpPortStatus.intValue();
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.m_stpPortStatus);
        }

        public static StpPortStatus get(Integer code) {
            if (code == null) {
                return UNKNOWN;
            }
            switch (code) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return DISABLED;
                }
                case 2: {
                    return BLOCKING;
                }
                case 3: {
                    return LISTENING;
                }
                case 4: {
                    return LEARNING;
                }
                case 5: {
                    return FORWARDING;
                }
                case 6: {
                    return BROKEN;
                }
            }
            throw new IllegalArgumentException("Cannot create vlanStatus from code " + code);
        }

        public static String getStpPortStatusString(Integer code) {
            if (stpPortStatusMap.containsKey(code)) {
                return stpPortStatusMap.get(code);
            }
            return null;
        }

        static {
            stpPortStatusMap.put(0, "Unknown");
            stpPortStatusMap.put(1, "disabled");
            stpPortStatusMap.put(2, "blocking");
            stpPortStatusMap.put(3, "listening");
            stpPortStatusMap.put(4, "learning");
            stpPortStatusMap.put(5, "forwarding");
            stpPortStatusMap.put(6, "broken");
            UNKNOWN = new StpPortStatus(0);
            DISABLED = new StpPortStatus(1);
            BLOCKING = new StpPortStatus(2);
            LISTENING = new StpPortStatus(3);
            LEARNING = new StpPortStatus(4);
            FORWARDING = new StpPortStatus(5);
            BROKEN = new StpPortStatus(6);
        }
    }
}

