/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsMonitoredService;

@XmlRootElement(name="monitored-service")
public class OnmsMonitoredServiceDetail
implements Serializable,
Comparable<OnmsMonitoredServiceDetail> {
    private String m_statusCode;
    private String m_status;
    private String m_nodeLabel;
    private String m_serviceName;
    private InetAddress m_ipAddress;
    private boolean m_isMonitored;
    private boolean m_isDown;

    public OnmsMonitoredServiceDetail() {
    }

    public OnmsMonitoredServiceDetail(OnmsMonitoredService service) {
        this.m_nodeLabel = service.getIpInterface().getNode().getLabel();
        this.m_ipAddress = service.getIpAddress();
        this.m_serviceName = service.getServiceName();
        this.m_isMonitored = service.getStatus().equals("A");
        this.m_isDown = service.isDown();
        this.m_statusCode = service.getStatus();
        this.m_status = service.getStatusLong();
    }

    @XmlElement(name="status")
    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    @XmlAttribute(name="statusCode")
    public String getStatusCode() {
        return this.m_statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.m_statusCode = statusCode;
    }

    @XmlElement(name="node")
    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public void setNodeLabel(String nodeLabel) {
        this.m_nodeLabel = nodeLabel;
    }

    @XmlElement(name="serviceName")
    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @XmlElement(name="ipAddress")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    @XmlAttribute(name="isMonitored")
    public boolean isMonitored() {
        return this.m_isMonitored;
    }

    @XmlAttribute(name="isDown")
    public boolean isDown() {
        return this.m_isDown;
    }

    @Override
    public int compareTo(OnmsMonitoredServiceDetail o) {
        BigInteger b;
        int diff = this.getNodeLabel().compareToIgnoreCase(o.getNodeLabel());
        if (diff != 0) {
            return diff;
        }
        BigInteger a = InetAddressUtils.toInteger((InetAddress)this.getIpAddress());
        diff = a.compareTo(b = InetAddressUtils.toInteger((InetAddress)o.getIpAddress()));
        if (diff != 0) {
            return diff;
        }
        return this.getServiceName().compareToIgnoreCase(o.getServiceName());
    }
}

