/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="ipRouteInterface")
@Entity
@Table(name="ipRouteInterface", uniqueConstraints={@UniqueConstraint(columnNames={"nodeId", "routeDest"})})
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsIpRouteInterface {
    private Integer m_id;
    private OnmsNode m_node;
    private String m_routeDest;
    private String m_routeMask;
    private String m_routeNextHop;
    private Integer m_routeIfIndex;
    private Integer m_routeMetric1;
    private Integer m_routeMetric2;
    private Integer m_routeMetric3;
    private Integer m_routeMetric4;
    private Integer m_routeMetric5;
    private RouteType m_routeType;
    private Integer m_routeProto;
    private OnmsArpInterface.StatusType m_status = OnmsArpInterface.StatusType.UNKNOWN;
    private Date m_lastPollTime;

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId().toString();
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlElement
    @Column(nullable=false, length=16)
    public String getRouteDest() {
        return this.m_routeDest;
    }

    public void setRouteDest(String routeDest) {
        this.m_routeDest = routeDest;
    }

    @XmlElement
    @Column(nullable=false, length=16)
    public String getRouteMask() {
        return this.m_routeMask;
    }

    public void setRouteMask(String routeMask) {
        this.m_routeMask = routeMask;
    }

    @XmlElement
    @Column(nullable=false, length=16)
    public String getRouteNextHop() {
        return this.m_routeNextHop;
    }

    public void setRouteNextHop(String routeNextHop) {
        this.m_routeNextHop = routeNextHop;
    }

    @XmlElement
    @Column(nullable=false)
    public Integer getRouteIfIndex() {
        return this.m_routeIfIndex;
    }

    public void setRouteIfIndex(Integer routeIfIndex) {
        this.m_routeIfIndex = routeIfIndex;
    }

    @XmlElement
    @Column
    public Integer getRouteMetric1() {
        return this.m_routeMetric1;
    }

    public void setRouteMetric1(Integer routeMetric1) {
        this.m_routeMetric1 = routeMetric1;
    }

    @XmlElement
    @Column
    public Integer getRouteMetric2() {
        return this.m_routeMetric2;
    }

    public void setRouteMetric2(Integer routeMetric2) {
        this.m_routeMetric2 = routeMetric2;
    }

    @XmlElement
    @Column
    public Integer getRouteMetric3() {
        return this.m_routeMetric3;
    }

    public void setRouteMetric3(Integer routeMetric3) {
        this.m_routeMetric3 = routeMetric3;
    }

    @XmlElement
    @Column
    public Integer getRouteMetric4() {
        return this.m_routeMetric4;
    }

    public void setRouteMetric4(Integer routeMetric4) {
        this.m_routeMetric4 = routeMetric4;
    }

    @XmlElement
    @Column
    public Integer getRouteMetric5() {
        return this.m_routeMetric5;
    }

    public void setRouteMetric5(Integer routeMetric5) {
        this.m_routeMetric5 = routeMetric5;
    }

    @XmlElement
    @Column
    public RouteType getRouteType() {
        return this.m_routeType;
    }

    public void setRouteType(RouteType routeType) {
        this.m_routeType = routeType;
    }

    @XmlElement
    @Column
    public Integer getRouteProto() {
        return this.m_routeProto;
    }

    public void setRouteProto(Integer routeProto) {
        this.m_routeProto = routeProto;
    }

    @XmlElement
    @Column(nullable=false)
    public OnmsArpInterface.StatusType getStatus() {
        return this.m_status;
    }

    public void setStatus(OnmsArpInterface.StatusType status) {
        this.m_status = status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    @XmlElement
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.m_id).append("node", (Object)this.m_node).append("routedest", (Object)this.m_routeDest).append("routemask", (Object)this.m_routeMask).append("routenexthop", (Object)this.m_routeNextHop).append("routeifindex", (Object)this.m_routeIfIndex).append("routetype", (Object)RouteType.getRouteTypeString(this.m_routeType.getIntCode())).append("routeprotocol", (Object)this.m_routeProto).append("routemetric1", (Object)this.m_routeMetric1).toString();
    }

    @Embeddable
    public static class RouteType
    implements Comparable<RouteType>,
    Serializable {
        private static final long serialVersionUID = -4784344871599250528L;
        public static final int ROUTE_TYPE_OTHER = 1;
        public static final int ROUTE_TYPE_INVALID = 2;
        public static final int ROUTE_TYPE_DIRECT = 3;
        public static final int ROUTE_TYPE_INDIRECT = 4;
        private static final Integer[] s_order = new Integer[]{1, 2, 3, 4};
        private Integer m_routeType;
        private static final Map<Integer, String> routeTypeMap = new HashMap<Integer, String>();
        public static final RouteType OTHER;
        public static final RouteType INVALID;
        public static final RouteType DIRECT;
        public static final RouteType INDIRECT;

        private RouteType() {
        }

        public RouteType(Integer routeType) {
            this.m_routeType = routeType;
        }

        @Column(name="routeType")
        public Integer getIntCode() {
            return this.m_routeType;
        }

        public void setIntCode(Integer routeType) {
            this.m_routeType = routeType;
        }

        @Override
        public int compareTo(RouteType o) {
            return RouteType.getIndex(this.m_routeType) - RouteType.getIndex(o.m_routeType);
        }

        private static int getIndex(Integer code) {
            for (int i = 0; i < s_order.length; ++i) {
                if (s_order[i] != code) continue;
                return i;
            }
            throw new IllegalArgumentException("illegal routeType code '" + code + "'");
        }

        public boolean equals(Object o) {
            if (o instanceof RouteType) {
                return this.m_routeType.intValue() == ((RouteType)o).m_routeType.intValue();
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.m_routeType);
        }

        public static RouteType get(Integer code) {
            if (code == null) {
                return null;
            }
            switch (code) {
                case 1: {
                    return OTHER;
                }
                case 2: {
                    return INVALID;
                }
                case 3: {
                    return DIRECT;
                }
                case 4: {
                    return INDIRECT;
                }
            }
            throw new IllegalArgumentException("Cannot create routeType from code " + code);
        }

        public static String getRouteTypeString(Integer code) {
            if (routeTypeMap.containsKey(code)) {
                return routeTypeMap.get(code);
            }
            return null;
        }

        static {
            routeTypeMap.put(1, "Other");
            routeTypeMap.put(2, "Invalid");
            routeTypeMap.put(3, "Direct");
            routeTypeMap.put(4, "Indirect");
            OTHER = new RouteType(1);
            INVALID = new RouteType(2);
            DIRECT = new RouteType(3);
            INDIRECT = new RouteType(4);
        }
    }
}

