/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.Date;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.SnmpInterfaceBuilder;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;

public class NetworkBuilder {
    private final OnmsDistPoller m_distPoller;
    OnmsNode m_currentNode;
    BeanWrapper m_assetBean;
    OnmsIpInterface m_currentIf;
    OnmsArpInterface m_currentAtIf;
    OnmsMonitoredService m_currentMonSvc;

    public NetworkBuilder(OnmsDistPoller distPoller) {
        this.m_distPoller = distPoller;
    }

    public NetworkBuilder(String name, String ipAddress) {
        this.m_distPoller = new OnmsDistPoller(name, ipAddress);
    }

    public NetworkBuilder() {
        this("localhost", "127.0.0.1");
    }

    public NodeBuilder addNode(String label) {
        this.m_currentNode = new OnmsNode(this.m_distPoller);
        this.m_currentNode.setLabel(label);
        this.m_assetBean = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.m_currentNode.getAssetRecord());
        return new NodeBuilder(this.m_currentNode);
    }

    public InterfaceBuilder addInterface(String ipAddr) {
        this.m_currentIf = new OnmsIpInterface(InetAddressUtils.addr((String)ipAddr), this.m_currentNode);
        return new InterfaceBuilder(this.m_currentIf);
    }

    public InterfaceBuilder addInterface(String ipAddr, OnmsSnmpInterface snmpInterface) {
        this.m_currentIf = new OnmsIpInterface(InetAddressUtils.addr((String)ipAddr), this.m_currentNode);
        this.m_currentIf.setSnmpInterface(snmpInterface);
        return new InterfaceBuilder(this.m_currentIf);
    }

    public AtInterfaceBuilder addAtInterface(OnmsNode sourceNode, String ipAddr, String physAddr) {
        this.m_currentAtIf = new OnmsArpInterface(sourceNode, this.m_currentNode, ipAddr, physAddr);
        return new AtInterfaceBuilder(this.m_currentAtIf);
    }

    public SnmpInterfaceBuilder addSnmpInterface(int ifIndex) {
        OnmsSnmpInterface snmp = new OnmsSnmpInterface(this.m_currentNode, ifIndex);
        snmp.getIpInterfaces().add(this.m_currentIf);
        return new SnmpInterfaceBuilder(snmp);
    }

    public OnmsMonitoredService addService(OnmsServiceType serviceType) {
        if (this.m_currentIf != null) {
            this.m_currentMonSvc = new OnmsMonitoredService(this.m_currentIf, serviceType);
            return this.m_currentMonSvc;
        }
        this.m_currentMonSvc = null;
        return null;
    }

    public void setDisplayCategory(String displayCategory) {
        this.m_currentNode.getAssetRecord().setDisplayCategory(displayCategory);
    }

    public void setBuilding(String building) {
        this.m_currentNode.getAssetRecord().setBuilding(building);
    }

    public OnmsNode getCurrentNode() {
        return this.m_currentNode;
    }

    public void addCategory(OnmsCategory cat) {
        this.m_currentNode.addCategory(cat);
    }

    public void addCategory(String categoryName) {
        this.addCategory(new OnmsCategory(categoryName));
    }

    public void clearInterface() {
        this.m_currentIf = null;
        this.m_currentMonSvc = null;
    }

    public OnmsMonitoredService addService(String serviceName) {
        return this.addService(new OnmsServiceType(serviceName));
    }

    public void setAssetAttribute(String name, String value) {
        try {
            this.m_assetBean.setPropertyValue(name, (Object)value);
        }
        catch (BeansException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Could not set property '%s' on asset '%s'", (Object[])new Object[]{value, name});
        }
    }

    public class AtInterfaceBuilder {
        final OnmsArpInterface m_iface;

        AtInterfaceBuilder(OnmsArpInterface iface) {
            this.m_iface = iface;
        }

        public AtInterfaceBuilder setStatus(char managed) {
            this.m_iface.setStatus(OnmsArpInterface.StatusType.get(managed));
            return this;
        }

        public AtInterfaceBuilder setIfIndex(int ifIndex) {
            this.m_iface.setIfIndex(ifIndex);
            return this;
        }

        public AtInterfaceBuilder setSourceNode(OnmsNode node) {
            this.m_iface.setSourceNode(node);
            return this;
        }

        public OnmsArpInterface getInterface() {
            return this.m_iface;
        }

        public AtInterfaceBuilder setId(int id) {
            this.m_iface.setId(id);
            return this;
        }

        public AtInterfaceBuilder setLastPollTime(Date timestamp) {
            this.m_iface.setLastPoll(timestamp);
            return this;
        }
    }

    public static class InterfaceBuilder {
        final OnmsIpInterface m_iface;

        InterfaceBuilder(OnmsIpInterface iface) {
            this.m_iface = iface;
        }

        public InterfaceBuilder setIsManaged(String managed) {
            this.m_iface.setIsManaged(managed);
            return this;
        }

        public InterfaceBuilder setIsSnmpPrimary(String isSnmpPrimary) {
            this.m_iface.setIsSnmpPrimary(PrimaryType.get(isSnmpPrimary));
            return this;
        }

        public OnmsIpInterface getInterface() {
            return this.m_iface;
        }

        @Deprecated
        public SnmpInterfaceBuilder addSnmpInterface(int ifIndex) {
            OnmsSnmpInterface snmpIf = new OnmsSnmpInterface(this.m_iface.getNode(), ifIndex);
            this.m_iface.setSnmpInterface(snmpIf);
            snmpIf.getIpInterfaces().add(this.m_iface);
            return new SnmpInterfaceBuilder(snmpIf);
        }

        public InterfaceBuilder setId(int id) {
            this.m_iface.setId(id);
            return this;
        }
    }

    public class NodeBuilder {
        OnmsNode m_node;

        NodeBuilder(OnmsNode node) {
            this.m_node = node;
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public NodeBuilder setId(Integer id) {
            this.m_node.setId(id);
            return this;
        }

        public NodeBuilder setForeignSource(String foreignSource) {
            this.m_node.setForeignSource(foreignSource);
            return this;
        }

        public NodeBuilder setForeignId(String foreignId) {
            this.m_node.setForeignId(foreignId);
            return this;
        }

        public OnmsAssetRecord getAssetRecord() {
            return this.m_node.getAssetRecord();
        }

        public NodeBuilder setLabelSource(String labelSource) {
            this.m_node.setLabelSource(labelSource);
            return this;
        }

        public NodeBuilder setType(String type) {
            this.m_node.setType(type);
            return this;
        }

        public NodeBuilder setSysObjectId(String sysObjectId) {
            this.m_node.setSysObjectId(sysObjectId);
            return this;
        }
    }
}

