/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="datalinkinterface")
public class DataLinkInterface
implements Serializable,
Comparable<DataLinkInterface> {
    private static final long serialVersionUID = 5241963830563150843L;
    private Integer m_id;
    private OnmsNode m_node;
    @Column(name="ifindex", nullable=false)
    private Integer m_ifIndex;
    @Column(name="nodeparentid", nullable=false)
    private Integer m_nodeParentId;
    @Column(name="parentifindex", nullable=false)
    private Integer m_parentIfIndex;
    @Column(name="status", length=1, nullable=false)
    private String m_status;
    @Column(name="linktypeid", nullable=true)
    private Integer m_linkTypeId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastpolltime", nullable=false)
    private Date m_lastPollTime;

    public DataLinkInterface() {
    }

    public DataLinkInterface(OnmsNode node, int ifIndex, int nodeParentId, int parentIfIndex, String status, Date lastPollTime) {
        this.m_node = node;
        this.m_ifIndex = ifIndex;
        this.m_nodeParentId = nodeParentId;
        this.m_parentIfIndex = parentIfIndex;
        this.m_status = status;
        this.m_lastPollTime = lastPollTime;
        this.m_linkTypeId = -1;
    }

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(int id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(int ifIndex) {
        this.m_ifIndex = ifIndex;
    }

    public Integer getNodeParentId() {
        return this.m_nodeParentId;
    }

    public void setNodeParentId(int nodeParentId) {
        this.m_nodeParentId = nodeParentId;
    }

    public Integer getParentIfIndex() {
        return this.m_parentIfIndex;
    }

    public void setParentIfIndex(int parentIfIndex) {
        this.m_parentIfIndex = parentIfIndex;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public Integer getLinkTypeId() {
        return this.m_linkTypeId;
    }

    public void setLinkTypeId(Integer linkTypeId) {
        this.m_linkTypeId = linkTypeId;
    }

    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    @Override
    public int compareTo(DataLinkInterface o) {
        return new CompareToBuilder().append((Object)this.getId(), (Object)o.getId()).append((Object)this.getNode(), (Object)o.getNode()).append((Object)this.getIfIndex(), (Object)o.getIfIndex()).append((Object)this.getNodeParentId(), (Object)o.getNodeParentId()).append((Object)this.getParentIfIndex(), (Object)o.getParentIfIndex()).append((Object)this.getStatus(), (Object)o.getStatus()).append((Object)this.getLastPollTime(), (Object)o.getLastPollTime()).append((Object)this.getLinkTypeId(), (Object)o.getLinkTypeId()).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.m_id).append((Object)this.m_node).append((Object)this.m_ifIndex).append((Object)this.m_nodeParentId).append((Object)this.m_parentIfIndex).append((Object)this.m_status).append((Object)this.m_lastPollTime).append((Object)this.m_linkTypeId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.m_id).append("node", (Object)this.m_node).append("ifIndex", (Object)this.m_ifIndex).append("nodeParentId", (Object)this.m_nodeParentId).append("parentIfIndex", (Object)this.m_parentIfIndex).append("status", (Object)this.m_status).append("linkTypeId", (Object)this.m_linkTypeId).append("lastPollTime", (Object)this.m_lastPollTime).toString();
    }
}

