/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.MapsAdapterConfig;
import org.opennms.netmgt.config.MapsAdapterConfigFactory;
import org.opennms.netmgt.config.map.adapter.Celement;
import org.opennms.netmgt.config.map.adapter.Cmap;
import org.opennms.netmgt.config.map.adapter.Csubmap;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OnmsMapDao;
import org.opennms.netmgt.dao.api.OnmsMapElementDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@EventListener(name="MapsProvisioningAdapter")
public class MapProvisioningAdapter
extends SimpleQueuedProvisioningAdapter
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(MapProvisioningAdapter.class);
    private Object m_lock = new Object();
    private NodeDao m_onmsNodeDao;
    private OnmsMapDao m_onmsMapDao;
    private OnmsMapElementDao m_onmsMapElementDao;
    private EventForwarder m_eventForwarder;
    private MapsAdapterConfig m_mapsAdapterConfig;
    private TransactionTemplate m_template;
    private static volatile ConcurrentMap<String, Integer> m_mapNameMapSizeListMap;
    private static final String MESSAGE_PREFIX = "Dynamic Map provisioning failed: ";
    private static final String ADAPTER_NAME = "MAP Provisioning Adapter";
    private static final long RESYNC_TIMEOUT = 300000L;
    private Set<Integer> m_deletes;
    private Set<Integer> m_adds;
    private Set<Integer> m_updates;
    private boolean doSync = false;
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final Pattern m_pattern;

    private XY getXY(OnmsMap map, int mapElementSize) {
        int deltaX = this.m_mapsAdapterConfig.getMapElementDimension();
        int deltaY = deltaX / 2;
        int maxNumberofelementsonX = map.getWidth() / (2 * deltaX);
        LOG.debug("getXY: max number of elements on a row: {}", (Object)maxNumberofelementsonX);
        int numberofexistingelement = mapElementSize;
        LOG.debug("getXY: number of existing elements on map: {}", (Object)mapElementSize);
        int positiononX = 1;
        int positiononY = 1;
        boolean addoffset = true;
        while (maxNumberofelementsonX <= numberofexistingelement) {
            LOG.debug("getXY: entering the loop: element found on the row: {}", (Object)(numberofexistingelement -= maxNumberofelementsonX));
            ++positiononY;
            maxNumberofelementsonX = addoffset ? --maxNumberofelementsonX : ++maxNumberofelementsonX;
            addoffset = !addoffset;
        }
        positiononX += numberofexistingelement;
        XY xy = new XY();
        if (addoffset) {
            xy.setX(2 * deltaX * positiononX - deltaX);
        } else {
            xy.setX(2 * deltaX * positiononX);
        }
        xy.setY(deltaY * positiononY);
        return xy;
    }

    public OnmsMapDao getOnmsMapDao() {
        return this.m_onmsMapDao;
    }

    public void setOnmsMapDao(OnmsMapDao onmsMapDao) {
        this.m_onmsMapDao = onmsMapDao;
    }

    public OnmsMapElementDao getOnmsMapElementDao() {
        return this.m_onmsMapElementDao;
    }

    public void setOnmsMapElementDao(OnmsMapElementDao onmsMapElementDao) {
        this.m_onmsMapElementDao = onmsMapElementDao;
    }

    public MapsAdapterConfig getMapsAdapterConfig() {
        return this.m_mapsAdapterConfig;
    }

    public void setMapsAdapterConfig(MapsAdapterConfig mapsAdapterConfig) {
        this.m_mapsAdapterConfig = mapsAdapterConfig;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public NodeDao getOnmsNodeDao() {
        return this.m_onmsNodeDao;
    }

    public void setOnmsNodeDao(NodeDao onmsNodeDao) {
        this.m_onmsNodeDao = onmsNodeDao;
    }

    public void setTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event event) {
        if (this.isReloadConfigEventTarget(event)) {
            EventBuilder ebldr = null;
            LOG.debug("reloading the maps adapter configuration");
            try {
                MapsAdapterConfigFactory.reload();
                this.syncMaps();
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Provisiond.MapProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.MapProvisioningAdapter");
            }
            catch (Throwable e) {
                LOG.info("unable to reload maps adapter configuration", e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Provisiond.MapProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.MapProvisioningAdapter");
                ebldr.addParam("reason", e.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Provisiond.MapProvisioningAdapter".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: Provisiond.MapProvisioningAdapter was target of reload event: {}", (Object)isTarget);
        return isTarget;
    }

    public String getName() {
        return ADAPTER_NAME;
    }

    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingOperationForNode(SimpleQueuedProvisioningAdapter.AdapterOperation op) throws ProvisioningAdapterException {
        LOG.info("processPendingOperationsForNode: acquiring lock...");
        Object object = this.m_lock;
        synchronized (object) {
            LOG.debug("processPendingOperationForNode: processing operation: {} for node with Id: # {}", (Object)op.getNodeId(), (Object)op.getType().name());
            if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.ADD) {
                this.m_adds.add(op.getNodeId());
            } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.UPDATE) {
                this.m_updates.add(op.getNodeId());
            } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.DELETE) {
                this.m_deletes.add(op.getNodeId());
            }
            this.doSync = true;
        }
        LOG.info("processPendingOperationsForNode: lock released.");
    }

    private void reSyncMap(final Set<Integer> deletes, final Set<Integer> adds, final Set<Integer> updates) throws ProvisioningAdapterException {
        this.m_mapsAdapterConfig.rebuildPackageIpListMap();
        this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus arg0) {
                try {
                    XY xy;
                    OnmsNode node;
                    for (Integer nodeid : deletes) {
                        LOG.debug("reSyncMap: deleting map element with nodeid: {}", (Object)nodeid);
                        MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByNodeid(nodeid.intValue());
                    }
                    if (adds.isEmpty() && updates.isEmpty()) {
                        return;
                    }
                    ConcurrentHashMap<String, OnmsMap> mapNames = new ConcurrentHashMap<String, OnmsMap>(m_mapNameMapSizeListMap.size());
                    for (OnmsMap onmsMap : MapProvisioningAdapter.this.m_onmsMapDao.findAutoAndSaveMaps()) {
                        if (!m_mapNameMapSizeListMap.containsKey(onmsMap.getName()) && !onmsMap.getType().equals("S")) continue;
                        LOG.debug("reSyncMaps: fetching map from db: {} type: {}", (Object)onmsMap.getType(), (Object)onmsMap.getName());
                        mapNames.put(onmsMap.getName(), onmsMap);
                    }
                    for (Integer nodeid : adds) {
                        LOG.debug("reSyncMap: adding map elements with nodeid: {}", (Object)nodeid);
                        if (deletes.contains(nodeid)) {
                            LOG.debug("reSyncMap: skipping because was deleted");
                            continue;
                        }
                        if (updates.contains(nodeid)) {
                            LOG.debug("reSyncMap: skipping because was updated");
                            continue;
                        }
                        node = (OnmsNode)MapProvisioningAdapter.this.m_onmsNodeDao.get((Serializable)nodeid);
                        Map<String, Celement> mapNameCelements = MapProvisioningAdapter.this.m_mapsAdapterConfig.getElementByAddress(MapProvisioningAdapter.this.getSuitableIp(node));
                        for (String mapName : mapNameCelements.keySet()) {
                            LOG.debug("reSyncMap: add: found container map: {}", (Object)mapName);
                            if (!mapNames.containsKey(mapName)) {
                                LOG.debug("reSyncMap: map: {} not in database. skipping....", (Object)mapName);
                                continue;
                            }
                            Celement celement = mapNameCelements.get(mapName);
                            OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                            if (onmsMap.getType().equals("A")) {
                                LOG.debug("reSyncMap: adding node: {} to map: {}", (Object)mapName, (Object)node.getLabel());
                                int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                LOG.debug("reSyncMap: mapElement is new: found last mapElement at position # {} on map: {}", (Object)mapName, (Object)elementsize);
                                XY xy2 = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                LOG.debug("reSyncMaps: mapElement is new: saved last mapElement at X position: {}", (Object)xy2.getX());
                                LOG.debug("reSyncMap: mapElement is new: saved last mapElement at Y position: {}", (Object)xy2.getY());
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "N", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), xy2.getX(), xy2.getY()));
                                m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                            } else {
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "H", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), 0, 0));
                            }
                            MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                        }
                    }
                    for (Integer nodeid : updates) {
                        LOG.debug("reSyncMap: updating map elements with nodeid: {}", (Object)nodeid);
                        if (deletes.contains(nodeid)) {
                            LOG.debug("reSyncMap: skipping because was deleted");
                            continue;
                        }
                        node = (OnmsNode)MapProvisioningAdapter.this.m_onmsNodeDao.get((Serializable)nodeid);
                        ArrayList<OnmsMapElement> elements = MapProvisioningAdapter.this.m_onmsMapElementDao.findElementsByNodeId(nodeid.intValue());
                        Map<String, Celement> mapNameCelements = MapProvisioningAdapter.this.m_mapsAdapterConfig.getElementByAddress(MapProvisioningAdapter.this.getSuitableIp(node));
                        for (String mapName : mapNameCelements.keySet()) {
                            LOG.debug("reSyncMap: update: found container map: {}", (Object)mapName);
                            if (!mapNames.containsKey(mapName)) {
                                LOG.debug("reSyncMap: map: {} not in database. skipping....", (Object)mapName);
                                continue;
                            }
                            Celement celement = mapNameCelements.get(mapName);
                            OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                            ArrayList<OnmsMapElement> tempElem = new ArrayList<OnmsMapElement>();
                            boolean elementExist = false;
                            for (OnmsMapElement elem : elements) {
                                if (elem.getMap().getId() == onmsMap.getId()) {
                                    elementExist = true;
                                    String label = MapProvisioningAdapter.this.getLabel(node.getLabel());
                                    if (elem.getLabel().equals(label)) {
                                        LOG.debug("reSyncMap: nodeid: {} is in map: {} and has the same label. skipping...", (Object)nodeid, (Object)mapName);
                                        continue;
                                    }
                                    LOG.debug("reSyncMap: nodeid: {} is in map: {} and has not the same label. updating...", (Object)nodeid, (Object)mapName);
                                    elem.setLabel(label);
                                    MapProvisioningAdapter.this.m_onmsMapElementDao.update((Object)elem);
                                    continue;
                                }
                                tempElem.add(elem);
                            }
                            elements = tempElem;
                            if (elementExist) continue;
                            if (onmsMap.getType().equals("A")) {
                                LOG.debug("reSyncMap: adding node: {} to map: {}", (Object)mapName, (Object)node.getLabel());
                                int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                LOG.debug("reSyncMap: mapElement is new: found last mapElement at position # {} on map: {}", (Object)mapName, (Object)elementsize);
                                xy = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                LOG.debug("reSyncMaps: mapElement is new: saved last mapElement at X position: {}", (Object)xy.getX());
                                LOG.debug("reSyncMap: mapElement is new: saved last mapElement at Y position: {}", (Object)xy.getY());
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "N", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), xy.getX(), xy.getY()));
                                m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                            } else {
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "H", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), 0, 0));
                            }
                            MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                        }
                        for (OnmsMapElement element : elements) {
                            if (!element.getMap().getType().equals("A")) continue;
                            MapProvisioningAdapter.this.m_onmsMapElementDao.delete((Object)element);
                        }
                    }
                    Map<String, List<Csubmap>> mapnameSubmapMap = MapProvisioningAdapter.this.m_mapsAdapterConfig.getsubMaps();
                    ConcurrentHashMap<String, Integer> mapNameSizeMap = new ConcurrentHashMap<String, Integer>();
                    for (String mapName : mapnameSubmapMap.keySet()) {
                        boolean auto;
                        LOG.debug("reSyncMap: update sub maps: found container map: {}", (Object)mapName);
                        if (!mapNames.containsKey(mapName)) {
                            LOG.debug("reSyncMap: map: {} not in database. skipping....", (Object)mapName);
                            continue;
                        }
                        OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                        LOG.debug("reSyncMaps: map type: {}", (Object)onmsMap.getType());
                        ArrayList<OnmsMapElement> elements = MapProvisioningAdapter.this.m_onmsMapElementDao.findElementsByMapIdAndType(onmsMap.getId(), "M");
                        if (onmsMap.getType().equals("A")) {
                            auto = true;
                        } else if (onmsMap.getType().equals("S")) {
                            auto = false;
                            elements.addAll(MapProvisioningAdapter.this.m_onmsMapElementDao.findElementsByMapIdAndType(onmsMap.getId(), "W"));
                        } else {
                            LOG.debug("reSyncMaps: cannot add submaps to map: {}", (Object)mapName);
                            continue;
                        }
                        for (Csubmap csubmap : mapnameSubmapMap.get(mapName)) {
                            LOG.debug("reSyncMaps: submap: {}", (Object)csubmap.getName());
                            if (!mapNames.containsKey(csubmap.getName())) {
                                LOG.debug("reSyncMap: map: {} not in database. skipping....", (Object)csubmap.getName());
                                continue;
                            }
                            OnmsMap onmsSubMap = (OnmsMap)mapNames.get(csubmap.getName());
                            if (!mapNameSizeMap.containsKey(onmsSubMap.getName())) {
                                mapNameSizeMap.put(csubmap.getName(), MapProvisioningAdapter.this.m_onmsMapElementDao.countElementsOnMap(onmsSubMap.getId()));
                            }
                            ArrayList<OnmsMapElement> tempelems = new ArrayList<OnmsMapElement>();
                            OnmsMapElement foundelement = null;
                            for (OnmsMapElement element : elements) {
                                if (element.getElementId() == onmsSubMap.getId()) {
                                    foundelement = element;
                                    LOG.debug("reSyncMap: map with id: {} is in map: {} .", (Object)onmsSubMap.getId(), (Object)mapName);
                                    continue;
                                }
                                tempelems.add(element);
                            }
                            elements = tempelems;
                            if (!csubmap.getAddwithoutelements() && (Integer)mapNameSizeMap.get(csubmap.getName()) == 0) {
                                if (foundelement == null || !auto && !foundelement.getType().equals("W")) continue;
                                MapProvisioningAdapter.this.m_onmsMapElementDao.delete((Object)foundelement);
                                continue;
                            }
                            if (foundelement != null) continue;
                            LOG.debug("ReSyncMaps: add submap: {} to map: {}", (Object)mapName, (Object)csubmap.getName());
                            if (auto) {
                                xy = new XY();
                                if (csubmap.hasX() && csubmap.hasY()) {
                                    xy.setX(csubmap.getX());
                                    xy.setY(csubmap.getY());
                                } else {
                                    int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                    xy = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                    m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                                }
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, onmsSubMap.getId(), "M", csubmap.getLabel(), csubmap.getIcon(), xy.getX(), xy.getY()));
                            } else {
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, onmsSubMap.getId(), "W", csubmap.getLabel(), csubmap.getIcon(), 0, 0));
                            }
                            MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                        }
                    }
                    int i = MapProvisioningAdapter.this.m_onmsMapDao.updateAllAutomatedMap(new Date());
                    LOG.debug("reSyncMap: updated last modified time for automated map: row#: {}", (Object)i);
                }
                catch (Throwable e) {
                    LOG.error(e.getMessage());
                    MapProvisioningAdapter.this.sendAndThrow(e);
                }
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_onmsNodeDao, (String)"Map Provisioning Adapter requires nodeDao property to be set.");
        Assert.notNull((Object)this.m_onmsMapDao, (String)"Map Provisioning Adapter requires OnmsMapDao property to be set.");
        Assert.notNull((Object)this.m_onmsMapElementDao, (String)"Map Provisioning Adapter requires OnmsMapElementDao property to be set.");
        Assert.notNull((Object)this.m_mapsAdapterConfig, (String)"Map Provisioning Adapter requires MapasAdapterConfig property to be set.");
        Assert.notNull((Object)this.m_eventForwarder, (String)"Map Provisioning Adapter requires EventForwarder property to be set.");
        this.m_deletes = new TreeSet<Integer>();
        this.m_updates = new TreeSet<Integer>();
        this.m_adds = new TreeSet<Integer>();
    }

    public void init() throws ProvisioningAdapterException {
        MapSyncExecutor e = new MapSyncExecutor();
        new Thread((Runnable)e, MapSyncExecutor.class.getSimpleName()).start();
    }

    private void syncMaps() throws ProvisioningAdapterException {
        try {
            this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void doInTransactionWithoutResult(TransactionStatus arg0) {
                    LOG.info("syncMaps: acquiring lock...");
                    Object object = MapProvisioningAdapter.this.m_lock;
                    synchronized (object) {
                        LOG.debug("syncMaps: lock acquired.  syncing maps...");
                        MapProvisioningAdapter.this.m_mapsAdapterConfig.getReadLock().lock();
                        try {
                            List<Cmap> cmaps = MapProvisioningAdapter.this.m_mapsAdapterConfig.getAllMaps();
                            m_mapNameMapSizeListMap = new ConcurrentHashMap(cmaps.size());
                            ConcurrentHashMap<String, OnmsMap> mapNames = new ConcurrentHashMap<String, OnmsMap>(cmaps.size());
                            for (Cmap cmap : cmaps) {
                                OnmsMap onmsMap = new OnmsMap();
                                onmsMap.setName(cmap.getMapName());
                                onmsMap.setType("A");
                                mapNames.put(cmap.getMapName(), onmsMap);
                            }
                            Date now = new Date();
                            LOG.debug("syncMaps: sync automated and static maps in database with configuration");
                            LOG.debug("syncMaps: deleting elements from automated existing map: ");
                            MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByMapType("A");
                            MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByType("W");
                            MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByType("H");
                            for (OnmsMap onmsMap : MapProvisioningAdapter.this.m_onmsMapDao.findAutoAndSaveMaps()) {
                                if (mapNames.containsKey(onmsMap.getName()) || onmsMap.getType().equals("S")) {
                                    if (onmsMap.getType().equals("S") && !mapNames.containsKey(onmsMap.getName())) {
                                        onmsMap.setType("U");
                                    }
                                    LOG.debug("syncMaps: fetching map from db: {} type: {}", (Object)onmsMap.getType(), (Object)onmsMap.getName());
                                    mapNames.put(onmsMap.getName(), onmsMap);
                                    continue;
                                }
                                LOG.debug("syncMaps: deleting old automated map: {}", (Object)onmsMap.getName());
                                LOG.debug("syncMaps: removing as map Element from all maps.");
                                MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByElementIdAndType(onmsMap.getId(), "M");
                                LOG.debug("syncMaps: removing from map table.");
                                MapProvisioningAdapter.this.m_onmsMapDao.delete((Object)onmsMap);
                                MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                                MapProvisioningAdapter.this.m_onmsMapDao.flush();
                            }
                            for (Cmap cmap : cmaps) {
                                OnmsMap onmsMap = (OnmsMap)mapNames.get(cmap.getMapName());
                                if (onmsMap.getType().equals("A")) {
                                    LOG.debug("syncMaps: sync automated map: {}", (Object)onmsMap.getName());
                                    onmsMap.setOwner(cmap.getMapOwner());
                                    onmsMap.setUserLastModifies(cmap.getMapOwner());
                                    onmsMap.setMapGroup(cmap.getMapGroup());
                                    onmsMap.setAccessMode(cmap.getMapAccess());
                                    onmsMap.setBackground(cmap.getMapBG());
                                    onmsMap.setHeight(cmap.getMapHeight());
                                    onmsMap.setWidth(cmap.getMapWidth());
                                    onmsMap.setLastModifiedTime(now);
                                    MapProvisioningAdapter.this.m_onmsMapDao.saveOrUpdate((Object)onmsMap);
                                    m_mapNameMapSizeListMap.put(cmap.getMapName(), 0);
                                } else {
                                    LOG.debug("syncMaps: skipping not automated map: {}", (Object)onmsMap.getName());
                                    LOG.debug("syncMaps: map type: {}", (Object)onmsMap.getType());
                                }
                                MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                            }
                            for (OnmsNode node : MapProvisioningAdapter.this.m_onmsNodeDao.findAllProvisionedNodes()) {
                                LOG.debug("syncMaps: try to sync automated maps for node element: ' {} '", (Object)node.getLabel());
                                Map<String, Celement> mapNameCelements = MapProvisioningAdapter.this.m_mapsAdapterConfig.getElementByAddress(MapProvisioningAdapter.this.getSuitableIp(node));
                                for (String mapName : mapNameCelements.keySet()) {
                                    Celement celement = mapNameCelements.get(mapName);
                                    OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                                    if (onmsMap.getType().equals("A")) {
                                        LOG.debug("syncMaps: adding node: {} to map: {}", (Object)mapName, (Object)node.getLabel());
                                        int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                        LOG.debug("syncMaps: mapElement is new: found last mapElement at position # {} on map: {}", (Object)mapName, (Object)elementsize);
                                        XY xy = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                        LOG.debug("syncMaps: mapElement is new: saved last mapElement at X position: {}", (Object)xy.getX());
                                        LOG.debug("syncMaps: mapElement is new: saved last mapElement at Y position: {}", (Object)xy.getY());
                                        MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "N", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), xy.getX(), xy.getY()));
                                        m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                                        continue;
                                    }
                                    if (MapProvisioningAdapter.this.m_onmsMapElementDao.findElement(node.getId().intValue(), "N", onmsMap) != null || MapProvisioningAdapter.this.m_onmsMapElementDao.findElement(node.getId().intValue(), "H", onmsMap) != null) continue;
                                    MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "H", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), 0, 0));
                                }
                            }
                            Map<String, List<Csubmap>> submaps = MapProvisioningAdapter.this.m_mapsAdapterConfig.getsubMaps();
                            for (String mapName : submaps.keySet()) {
                                boolean auto;
                                OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                                LOG.debug("syncMaps: found container map: {} type: {}", (Object)onmsMap.getType(), (Object)mapName);
                                Collection elements = new ArrayList();
                                if (onmsMap.getType().equals("A")) {
                                    auto = true;
                                } else if (onmsMap.getType().equals("S")) {
                                    elements = MapProvisioningAdapter.this.m_onmsMapElementDao.findElementsByMapIdAndType(onmsMap.getId(), "M");
                                    auto = false;
                                } else {
                                    LOG.debug("syncMaps: cannot add submaps to map: {}", (Object)mapName);
                                    continue;
                                }
                                block12: for (Csubmap csubmap : submaps.get(mapName)) {
                                    OnmsMap onmsSubMap = (OnmsMap)mapNames.get(csubmap.getName());
                                    LOG.debug("syncMaps: add submap: {}", (Object)csubmap.getName());
                                    if (!csubmap.getAddwithoutelements() && (Integer)m_mapNameMapSizeListMap.get(csubmap.getName()) == 0) continue;
                                    LOG.debug("syncMaps: add submap: {} to map: {}", (Object)mapName, (Object)csubmap.getName());
                                    if (auto) {
                                        XY xy = new XY();
                                        if (csubmap.hasX() && csubmap.hasY()) {
                                            xy.setX(csubmap.getX());
                                            xy.setY(csubmap.getY());
                                        } else {
                                            int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                            xy = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                            m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                                        }
                                        MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, onmsSubMap.getId(), "M", csubmap.getLabel(), csubmap.getIcon(), xy.getX(), xy.getY()));
                                        continue;
                                    }
                                    for (OnmsMapElement element : elements) {
                                        if (element.getElementId() != onmsSubMap.getId()) continue;
                                        continue block12;
                                    }
                                    MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, onmsSubMap.getId(), "W", csubmap.getLabel(), csubmap.getIcon(), 0, 0));
                                }
                                MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                            }
                            LOG.debug("syncMaps: maps synchronized.  releasing lock...");
                        }
                        finally {
                            MapProvisioningAdapter.this.m_mapsAdapterConfig.getReadLock().unlock();
                        }
                    }
                    LOG.info("syncMaps: lock released.");
                }
            });
        }
        catch (Exception e) {
            LOG.error("syncMaps: Caught exception synchronizing maps", (Throwable)e);
            throw new ProvisioningAdapterException("syncMaps exception", (Throwable)e);
        }
    }

    private void sendAndThrow(Throwable e) {
        Event event = this.buildEvent("uei.opennms.org/provisioner/provisioningAdapterFailed").addParam("reason", MESSAGE_PREFIX + e.getLocalizedMessage()).getEvent();
        this.m_eventForwarder.sendNow(event);
        LOG.error(e.getMessage());
        throw new ProvisioningAdapterException(MESSAGE_PREFIX, e);
    }

    private EventBuilder buildEvent(String uei) {
        return new EventBuilder(uei, "Provisioner", new Date());
    }

    public String getSuitableIp(OnmsNode node) {
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        if (primaryInterface == null) {
            Set ipInterfaces = node.getIpInterfaces();
            Iterator i$ = ipInterfaces.iterator();
            if (i$.hasNext()) {
                OnmsIpInterface onmsIpInterface = (OnmsIpInterface)i$.next();
                return InetAddressUtils.str((InetAddress)onmsIpInterface.getIpAddress());
            }
            return "0.0.0.0";
        }
        return InetAddressUtils.str((InetAddress)primaryInterface.getIpAddress());
    }

    private String getLabel(String FQDN) {
        if (FQDN.indexOf(46) > 0 && !this.validate(FQDN)) {
            return FQDN.substring(0, FQDN.indexOf(46));
        }
        return FQDN;
    }

    private boolean validate(String ip) {
        Matcher matcher = m_pattern.matcher(ip);
        return matcher.matches();
    }

    static {
        m_pattern = Pattern.compile(IPADDRESS_PATTERN);
    }

    class MapSyncExecutor
    implements Runnable {
        MapSyncExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MapProvisioningAdapter.this.syncMaps();
            while (true) {
                try {
                    LOG.debug("Sleeping: {}", (Object)300000L);
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    LOG.error("Cannot sleep: {}", (Object)e.getLocalizedMessage());
                }
                if (MapProvisioningAdapter.this.doSync) {
                    LOG.debug("Synchronization started");
                    TreeSet<Integer> deletes = new TreeSet<Integer>();
                    TreeSet<Integer> adds = new TreeSet<Integer>();
                    TreeSet<Integer> updates = new TreeSet<Integer>();
                    LOG.info("acquiring lock...");
                    Object object = MapProvisioningAdapter.this.m_lock;
                    synchronized (object) {
                        for (Integer i : MapProvisioningAdapter.this.m_deletes) {
                            deletes.add(i);
                        }
                        for (Integer i : MapProvisioningAdapter.this.m_adds) {
                            adds.add(i);
                        }
                        for (Integer i : MapProvisioningAdapter.this.m_updates) {
                            updates.add(i);
                        }
                        MapProvisioningAdapter.this.m_deletes = new TreeSet();
                        MapProvisioningAdapter.this.m_updates = new TreeSet();
                        MapProvisioningAdapter.this.m_adds = new TreeSet();
                        MapProvisioningAdapter.this.doSync = false;
                    }
                    LOG.info("lock released.");
                    MapProvisioningAdapter.this.reSyncMap(deletes, adds, updates);
                    continue;
                }
                LOG.debug("No Synchronization required");
            }
        }
    }

    private static class XY {
        int x;
        int y;

        protected XY() {
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
}

