/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.MapsAdapterConfig;
import org.opennms.netmgt.config.MapsAdapterConfigFactory;
import org.opennms.netmgt.config.map.adapter.Celement;
import org.opennms.netmgt.config.map.adapter.Cmap;
import org.opennms.netmgt.config.map.adapter.Csubmap;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.dao.OnmsMapElementDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@EventListener(name="MapsProvisioningAdapter")
public class MapProvisioningAdapter
extends SimpleQueuedProvisioningAdapter
implements InitializingBean {
    private Object m_lock = new Object();
    private NodeDao m_onmsNodeDao;
    private OnmsMapDao m_onmsMapDao;
    private OnmsMapElementDao m_onmsMapElementDao;
    private EventForwarder m_eventForwarder;
    private MapsAdapterConfig m_mapsAdapterConfig;
    private TransactionTemplate m_template;
    private static volatile ConcurrentMap<String, Integer> m_mapNameMapSizeListMap;
    private static final String MESSAGE_PREFIX = "Dynamic Map provisioning failed: ";
    private static final String ADAPTER_NAME = "MAP Provisioning Adapter";
    private static final long RESYNC_TIMEOUT = 300000L;
    private Set<Integer> m_deletes;
    private Set<Integer> m_adds;
    private Set<Integer> m_updates;
    private boolean doSync = false;
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final Pattern m_pattern;

    private XY getXY(OnmsMap map, int mapElementSize) {
        int deltaX = this.m_mapsAdapterConfig.getMapElementDimension();
        int deltaY = deltaX / 2;
        int maxNumberofelementsonX = map.getWidth() / (2 * deltaX);
        MapProvisioningAdapter.log().debug("getXY: max number of elements on a row: " + maxNumberofelementsonX);
        int numberofexistingelement = mapElementSize;
        MapProvisioningAdapter.log().debug("getXY: number of existing elements on map: " + mapElementSize);
        int positiononX = 1;
        int positiononY = 1;
        boolean addoffset = true;
        while (maxNumberofelementsonX <= numberofexistingelement) {
            MapProvisioningAdapter.log().debug("getXY: entering the loop: element found on the row: " + (numberofexistingelement -= maxNumberofelementsonX));
            ++positiononY;
            maxNumberofelementsonX = addoffset ? --maxNumberofelementsonX : ++maxNumberofelementsonX;
            addoffset = !addoffset;
        }
        positiononX += numberofexistingelement;
        XY xy = new XY();
        if (addoffset) {
            xy.setX(2 * deltaX * positiononX - deltaX);
        } else {
            xy.setX(2 * deltaX * positiononX);
        }
        xy.setY(deltaY * positiononY);
        return xy;
    }

    public OnmsMapDao getOnmsMapDao() {
        return this.m_onmsMapDao;
    }

    public void setOnmsMapDao(OnmsMapDao onmsMapDao) {
        this.m_onmsMapDao = onmsMapDao;
    }

    public OnmsMapElementDao getOnmsMapElementDao() {
        return this.m_onmsMapElementDao;
    }

    public void setOnmsMapElementDao(OnmsMapElementDao onmsMapElementDao) {
        this.m_onmsMapElementDao = onmsMapElementDao;
    }

    public MapsAdapterConfig getMapsAdapterConfig() {
        return this.m_mapsAdapterConfig;
    }

    public void setMapsAdapterConfig(MapsAdapterConfig mapsAdapterConfig) {
        this.m_mapsAdapterConfig = mapsAdapterConfig;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public NodeDao getOnmsNodeDao() {
        return this.m_onmsNodeDao;
    }

    public void setOnmsNodeDao(NodeDao onmsNodeDao) {
        this.m_onmsNodeDao = onmsNodeDao;
    }

    public TransactionTemplate getTemplate() {
        return this.m_template;
    }

    public void setTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(MapProvisioningAdapter.class);
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event event) {
        if (this.isReloadConfigEventTarget(event)) {
            EventBuilder ebldr = null;
            LogUtils.infof((Object)((Object)this), (String)"reloading the maps adapter configuration", (Object[])new Object[0]);
            try {
                MapsAdapterConfigFactory.reload();
                this.syncMaps();
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Provisiond.MapProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.MapProvisioningAdapter");
            }
            catch (Throwable e) {
                LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"unable to reload maps adapter configuration", (Object[])new Object[0]);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Provisiond.MapProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.MapProvisioningAdapter");
                ebldr.addParam("reason", e.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Provisiond.MapProvisioningAdapter".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        MapProvisioningAdapter.log().debug("isReloadConfigEventTarget: Provisiond.MapProvisioningAdapter was target of reload event: " + isTarget);
        return isTarget;
    }

    public String getName() {
        return ADAPTER_NAME;
    }

    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingOperationForNode(SimpleQueuedProvisioningAdapter.AdapterOperation op) throws ProvisioningAdapterException {
        MapProvisioningAdapter.log().info("processPendingOperationsForNode: acquiring lock...");
        Object object = this.m_lock;
        synchronized (object) {
            MapProvisioningAdapter.log().debug("processPendingOperationForNode: processing operation: " + op.getType().name() + " for node with Id: #" + op.getNodeId());
            if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.ADD) {
                this.m_adds.add(op.getNodeId());
            } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.UPDATE) {
                this.m_updates.add(op.getNodeId());
            } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.DELETE) {
                this.m_deletes.add(op.getNodeId());
            }
            this.doSync = true;
        }
        MapProvisioningAdapter.log().info("processPendingOperationsForNode: lock released.");
    }

    private void reSyncMap(final Set<Integer> deletes, final Set<Integer> adds, final Set<Integer> updates) throws ProvisioningAdapterException {
        this.m_mapsAdapterConfig.rebuildPackageIpListMap();
        this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus arg0) {
                try {
                    XY xy;
                    OnmsNode node;
                    for (Integer nodeid : deletes) {
                        MapProvisioningAdapter.log().debug("reSyncMap: deleting map element with nodeid: " + nodeid);
                        MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByNodeid(nodeid.intValue());
                    }
                    if (adds.isEmpty() && updates.isEmpty()) {
                        return null;
                    }
                    ConcurrentHashMap<String, OnmsMap> mapNames = new ConcurrentHashMap<String, OnmsMap>(m_mapNameMapSizeListMap.size());
                    for (OnmsMap onmsMap : MapProvisioningAdapter.this.m_onmsMapDao.findAutoAndSaveMaps()) {
                        if (!m_mapNameMapSizeListMap.containsKey(onmsMap.getName()) && !onmsMap.getType().equals("S")) continue;
                        MapProvisioningAdapter.log().debug("reSyncMaps: fetching map from db: " + onmsMap.getName() + " type: " + onmsMap.getType());
                        mapNames.put(onmsMap.getName(), onmsMap);
                    }
                    for (Integer nodeid : adds) {
                        MapProvisioningAdapter.log().debug("reSyncMap: adding map elements with nodeid: " + nodeid);
                        if (deletes.contains(nodeid)) {
                            MapProvisioningAdapter.log().debug("reSyncMap: skipping because was deleted");
                            continue;
                        }
                        if (updates.contains(nodeid)) {
                            MapProvisioningAdapter.log().debug("reSyncMap: skipping because was updated");
                            continue;
                        }
                        node = (OnmsNode)MapProvisioningAdapter.this.m_onmsNodeDao.get((Serializable)nodeid);
                        Map<String, Celement> mapNameCelements = MapProvisioningAdapter.this.m_mapsAdapterConfig.getElementByAddress(MapProvisioningAdapter.this.getSuitableIp(node));
                        for (String mapName : mapNameCelements.keySet()) {
                            MapProvisioningAdapter.log().debug("reSyncMap: add: found container map: " + mapName);
                            if (!mapNames.containsKey(mapName)) {
                                MapProvisioningAdapter.log().debug("reSyncMap: map: " + mapName + " not in database. skipping....");
                                continue;
                            }
                            Celement celement = mapNameCelements.get(mapName);
                            OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                            if (onmsMap.getType().equals("A")) {
                                MapProvisioningAdapter.log().debug("reSyncMap: adding node: " + node.getLabel() + " to map: " + mapName);
                                int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                MapProvisioningAdapter.log().debug("reSyncMap: mapElement is new: found last mapElement at position #" + elementsize + " on map: " + mapName);
                                XY xy2 = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                MapProvisioningAdapter.log().debug("reSyncMaps: mapElement is new: saved last mapElement at X position: " + xy2.getX());
                                MapProvisioningAdapter.log().debug("reSyncMap: mapElement is new: saved last mapElement at Y position: " + xy2.getY());
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "N", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), xy2.getX(), xy2.getY()));
                                m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                            } else {
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "H", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), 0, 0));
                            }
                            MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                        }
                    }
                    for (Integer nodeid : updates) {
                        MapProvisioningAdapter.log().debug("reSyncMap: updating map elements with nodeid: " + nodeid);
                        if (deletes.contains(nodeid)) {
                            MapProvisioningAdapter.log().debug("reSyncMap: skipping because was deleted");
                            continue;
                        }
                        node = (OnmsNode)MapProvisioningAdapter.this.m_onmsNodeDao.get((Serializable)nodeid);
                        ArrayList<OnmsMapElement> elements = MapProvisioningAdapter.this.m_onmsMapElementDao.findElementsByNodeId(nodeid.intValue());
                        Map<String, Celement> mapNameCelements = MapProvisioningAdapter.this.m_mapsAdapterConfig.getElementByAddress(MapProvisioningAdapter.this.getSuitableIp(node));
                        for (String mapName : mapNameCelements.keySet()) {
                            MapProvisioningAdapter.log().debug("reSyncMap: update: found container map: " + mapName);
                            if (!mapNames.containsKey(mapName)) {
                                MapProvisioningAdapter.log().debug("reSyncMap: map: " + mapName + " not in database. skipping....");
                                continue;
                            }
                            Celement celement = mapNameCelements.get(mapName);
                            OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                            ArrayList<OnmsMapElement> tempElem = new ArrayList<OnmsMapElement>();
                            boolean elementExist = false;
                            for (OnmsMapElement elem : elements) {
                                if (elem.getMap().getId() == onmsMap.getId()) {
                                    elementExist = true;
                                    String label = MapProvisioningAdapter.this.getLabel(node.getLabel());
                                    if (elem.getLabel().equals(label)) {
                                        MapProvisioningAdapter.log().debug("reSyncMap: nodeid: " + nodeid + " is in map:" + mapName + " and has the same label. skipping...");
                                        continue;
                                    }
                                    MapProvisioningAdapter.log().debug("reSyncMap: nodeid: " + nodeid + " is in map:" + mapName + " and has not the same label. updating...");
                                    elem.setLabel(label);
                                    MapProvisioningAdapter.this.m_onmsMapElementDao.update((Object)elem);
                                    continue;
                                }
                                tempElem.add(elem);
                            }
                            elements = tempElem;
                            if (elementExist) continue;
                            if (onmsMap.getType().equals("A")) {
                                MapProvisioningAdapter.log().debug("reSyncMap: adding node: " + node.getLabel() + " to map: " + mapName);
                                int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                MapProvisioningAdapter.log().debug("reSyncMap: mapElement is new: found last mapElement at position #" + elementsize + " on map: " + mapName);
                                xy = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                MapProvisioningAdapter.log().debug("reSyncMaps: mapElement is new: saved last mapElement at X position: " + xy.getX());
                                MapProvisioningAdapter.log().debug("reSyncMap: mapElement is new: saved last mapElement at Y position: " + xy.getY());
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "N", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), xy.getX(), xy.getY()));
                                m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                            } else {
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "H", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), 0, 0));
                            }
                            MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                        }
                        for (OnmsMapElement element : elements) {
                            if (!element.getMap().getType().equals("A")) continue;
                            MapProvisioningAdapter.this.m_onmsMapElementDao.delete((Object)element);
                        }
                    }
                    Map<String, List<Csubmap>> mapnameSubmapMap = MapProvisioningAdapter.this.m_mapsAdapterConfig.getsubMaps();
                    ConcurrentHashMap<String, Integer> mapNameSizeMap = new ConcurrentHashMap<String, Integer>();
                    for (String mapName : mapnameSubmapMap.keySet()) {
                        boolean auto;
                        MapProvisioningAdapter.log().debug("reSyncMap: update sub maps: found container map: " + mapName);
                        if (!mapNames.containsKey(mapName)) {
                            MapProvisioningAdapter.log().debug("reSyncMap: map: " + mapName + " not in database. skipping....");
                            continue;
                        }
                        OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                        MapProvisioningAdapter.log().debug("reSyncMaps: map type: " + onmsMap.getType());
                        ArrayList<OnmsMapElement> elements = MapProvisioningAdapter.this.m_onmsMapElementDao.findElementsByMapIdAndType(onmsMap.getId(), "M");
                        if (onmsMap.getType().equals("A")) {
                            auto = true;
                        } else if (onmsMap.getType().equals("S")) {
                            auto = false;
                            elements.addAll(MapProvisioningAdapter.this.m_onmsMapElementDao.findElementsByMapIdAndType(onmsMap.getId(), "W"));
                        } else {
                            MapProvisioningAdapter.log().debug("reSyncMaps: cannot add submaps to map: " + mapName);
                            continue;
                        }
                        for (Csubmap csubmap : mapnameSubmapMap.get(mapName)) {
                            MapProvisioningAdapter.log().debug("reSyncMaps: submap: " + csubmap.getName());
                            if (!mapNames.containsKey(csubmap.getName())) {
                                MapProvisioningAdapter.log().debug("reSyncMap: map: " + csubmap.getName() + " not in database. skipping....");
                                continue;
                            }
                            OnmsMap onmsSubMap = (OnmsMap)mapNames.get(csubmap.getName());
                            if (!mapNameSizeMap.containsKey(onmsSubMap.getName())) {
                                mapNameSizeMap.put(csubmap.getName(), MapProvisioningAdapter.this.m_onmsMapElementDao.countElementsOnMap(onmsSubMap.getId()));
                            }
                            ArrayList<OnmsMapElement> tempelems = new ArrayList<OnmsMapElement>();
                            OnmsMapElement foundelement = null;
                            for (OnmsMapElement element : elements) {
                                if (element.getElementId() == onmsSubMap.getId()) {
                                    foundelement = element;
                                    MapProvisioningAdapter.log().debug("reSyncMap: map with id: " + onmsSubMap.getId() + " is in map:" + mapName + ".");
                                    continue;
                                }
                                tempelems.add(element);
                            }
                            elements = tempelems;
                            if (!csubmap.getAddwithoutelements() && (Integer)mapNameSizeMap.get(csubmap.getName()) == 0) {
                                if (foundelement == null || !auto && !foundelement.getType().equals("W")) continue;
                                MapProvisioningAdapter.this.m_onmsMapElementDao.delete((Object)foundelement);
                                continue;
                            }
                            if (foundelement != null) continue;
                            MapProvisioningAdapter.log().debug("ReSyncMaps: add submap: " + csubmap.getName() + "to map: " + mapName);
                            if (auto) {
                                xy = new XY();
                                if (csubmap.hasX() && csubmap.hasY()) {
                                    xy.setX(csubmap.getX());
                                    xy.setY(csubmap.getY());
                                } else {
                                    int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                    xy = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                    m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                                }
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, onmsSubMap.getId(), "M", csubmap.getLabel(), csubmap.getIcon(), xy.getX(), xy.getY()));
                            } else {
                                MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, onmsSubMap.getId(), "W", csubmap.getLabel(), csubmap.getIcon(), 0, 0));
                            }
                            MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                        }
                    }
                    int i = MapProvisioningAdapter.this.m_onmsMapDao.updateAllAutomatedMap(new Date());
                    MapProvisioningAdapter.log().debug("reSyncMap: updated last modified time for automated map: row#: " + i);
                }
                catch (Throwable e) {
                    MapProvisioningAdapter.log().error(e.getMessage());
                    MapProvisioningAdapter.this.sendAndThrow(e);
                }
                return null;
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_onmsNodeDao, (String)"Map Provisioning Adapter requires nodeDao property to be set.");
        Assert.notNull((Object)this.m_onmsMapDao, (String)"Map Provisioning Adapter requires OnmsMapDao property to be set.");
        Assert.notNull((Object)this.m_onmsMapElementDao, (String)"Map Provisioning Adapter requires OnmsMapElementDao property to be set.");
        Assert.notNull((Object)this.m_mapsAdapterConfig, (String)"Map Provisioning Adapter requires MapasAdapterConfig property to be set.");
        Assert.notNull((Object)this.m_eventForwarder, (String)"Map Provisioning Adapter requires EventForwarder property to be set.");
        this.m_deletes = new TreeSet<Integer>();
        this.m_updates = new TreeSet<Integer>();
        this.m_adds = new TreeSet<Integer>();
    }

    public void init() throws ProvisioningAdapterException {
        MapSyncExecutor e = new MapSyncExecutor();
        new Thread((Runnable)e, MapSyncExecutor.class.getSimpleName()).start();
    }

    private void syncMaps() throws ProvisioningAdapterException {
        try {
            this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInTransaction(TransactionStatus arg0) {
                    MapProvisioningAdapter.log().info("syncMaps: acquiring lock...");
                    Object object = MapProvisioningAdapter.this.m_lock;
                    synchronized (object) {
                        MapProvisioningAdapter.log().debug("syncMaps: lock acquired.  syncing maps...");
                        MapProvisioningAdapter.this.m_mapsAdapterConfig.getReadLock().lock();
                        try {
                            List<Cmap> cmaps = MapProvisioningAdapter.this.m_mapsAdapterConfig.getAllMaps();
                            m_mapNameMapSizeListMap = new ConcurrentHashMap(cmaps.size());
                            ConcurrentHashMap<String, OnmsMap> mapNames = new ConcurrentHashMap<String, OnmsMap>(cmaps.size());
                            for (Cmap cmap : cmaps) {
                                OnmsMap onmsMap = new OnmsMap();
                                onmsMap.setName(cmap.getMapName());
                                onmsMap.setType("A");
                                mapNames.put(cmap.getMapName(), onmsMap);
                            }
                            Date now = new Date();
                            MapProvisioningAdapter.log().debug("syncMaps: sync automated and static maps in database with configuration");
                            MapProvisioningAdapter.log().debug("syncMaps: deleting elements from automated existing map: ");
                            MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByMapType("A");
                            MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByType("W");
                            MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByType("H");
                            for (OnmsMap onmsMap : MapProvisioningAdapter.this.m_onmsMapDao.findAutoAndSaveMaps()) {
                                if (mapNames.containsKey(onmsMap.getName()) || onmsMap.getType().equals("S")) {
                                    if (onmsMap.getType().equals("S") && !mapNames.containsKey(onmsMap.getName())) {
                                        onmsMap.setType("U");
                                    }
                                    MapProvisioningAdapter.log().debug("syncMaps: fetching map from db: " + onmsMap.getName() + " type: " + onmsMap.getType());
                                    mapNames.put(onmsMap.getName(), onmsMap);
                                    continue;
                                }
                                MapProvisioningAdapter.log().debug("syncMaps: deleting old automated map: " + onmsMap.getName());
                                MapProvisioningAdapter.log().debug("syncMaps: removing as map Element from all maps.");
                                MapProvisioningAdapter.this.m_onmsMapElementDao.deleteElementsByElementIdAndType(onmsMap.getId(), "M");
                                MapProvisioningAdapter.log().debug("syncMaps: removing from map table.");
                                MapProvisioningAdapter.this.m_onmsMapDao.delete((Object)onmsMap);
                                MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                                MapProvisioningAdapter.this.m_onmsMapDao.flush();
                            }
                            for (Cmap cmap : cmaps) {
                                OnmsMap onmsMap = (OnmsMap)mapNames.get(cmap.getMapName());
                                if (onmsMap.getType().equals("A")) {
                                    MapProvisioningAdapter.log().debug("syncMaps: sync automated map: " + onmsMap.getName());
                                    onmsMap.setOwner(cmap.getMapOwner());
                                    onmsMap.setUserLastModifies(cmap.getMapOwner());
                                    onmsMap.setMapGroup(cmap.getMapGroup());
                                    onmsMap.setAccessMode(cmap.getMapAccess());
                                    onmsMap.setBackground(cmap.getMapBG());
                                    onmsMap.setHeight(cmap.getMapHeight());
                                    onmsMap.setWidth(cmap.getMapWidth());
                                    onmsMap.setLastModifiedTime(now);
                                    MapProvisioningAdapter.this.m_onmsMapDao.saveOrUpdate((Object)onmsMap);
                                    m_mapNameMapSizeListMap.put(cmap.getMapName(), 0);
                                } else {
                                    MapProvisioningAdapter.log().debug("syncMaps: skipping not automated map: " + onmsMap.getName());
                                    MapProvisioningAdapter.log().debug("syncMaps: map type: " + onmsMap.getType());
                                }
                                MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                            }
                            for (OnmsNode node : MapProvisioningAdapter.this.m_onmsNodeDao.findAllProvisionedNodes()) {
                                MapProvisioningAdapter.log().debug("syncMaps: try to sync automated maps for node element: '" + node.getLabel() + "'");
                                Map<String, Celement> mapNameCelements = MapProvisioningAdapter.this.m_mapsAdapterConfig.getElementByAddress(MapProvisioningAdapter.this.getSuitableIp(node));
                                for (String mapName : mapNameCelements.keySet()) {
                                    Celement celement = mapNameCelements.get(mapName);
                                    OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                                    if (onmsMap.getType().equals("A")) {
                                        MapProvisioningAdapter.log().debug("syncMaps: adding node: " + node.getLabel() + " to map: " + mapName);
                                        int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                        MapProvisioningAdapter.log().debug("syncMaps: mapElement is new: found last mapElement at position #" + elementsize + " on map: " + mapName);
                                        XY xy = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                        MapProvisioningAdapter.log().debug("syncMaps: mapElement is new: saved last mapElement at X position: " + xy.getX());
                                        MapProvisioningAdapter.log().debug("syncMaps: mapElement is new: saved last mapElement at Y position: " + xy.getY());
                                        MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "N", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), xy.getX(), xy.getY()));
                                        m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                                        continue;
                                    }
                                    if (MapProvisioningAdapter.this.m_onmsMapElementDao.findElement(node.getId().intValue(), "N", onmsMap) != null || MapProvisioningAdapter.this.m_onmsMapElementDao.findElement(node.getId().intValue(), "H", onmsMap) != null) continue;
                                    MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, node.getId().intValue(), "H", MapProvisioningAdapter.this.getLabel(node.getLabel()), celement.getIcon(), 0, 0));
                                }
                            }
                            Map<String, List<Csubmap>> submaps = MapProvisioningAdapter.this.m_mapsAdapterConfig.getsubMaps();
                            for (String mapName : submaps.keySet()) {
                                boolean auto;
                                OnmsMap onmsMap = (OnmsMap)mapNames.get(mapName);
                                MapProvisioningAdapter.log().debug("syncMaps: found container map: " + mapName + " type: " + onmsMap.getType());
                                Collection elements = new ArrayList();
                                if (onmsMap.getType().equals("A")) {
                                    auto = true;
                                } else if (onmsMap.getType().equals("S")) {
                                    elements = MapProvisioningAdapter.this.m_onmsMapElementDao.findElementsByMapIdAndType(onmsMap.getId(), "M");
                                    auto = false;
                                } else {
                                    MapProvisioningAdapter.log().debug("syncMaps: cannot add submaps to map: " + mapName);
                                    continue;
                                }
                                block12: for (Csubmap csubmap : submaps.get(mapName)) {
                                    OnmsMap onmsSubMap = (OnmsMap)mapNames.get(csubmap.getName());
                                    MapProvisioningAdapter.log().debug("syncMaps: add submap: " + csubmap.getName());
                                    if (!csubmap.getAddwithoutelements() && (Integer)m_mapNameMapSizeListMap.get(csubmap.getName()) == 0) continue;
                                    MapProvisioningAdapter.log().debug("syncMaps: add submap: " + csubmap.getName() + "to map: " + mapName);
                                    if (auto) {
                                        XY xy = new XY();
                                        if (csubmap.hasX() && csubmap.hasY()) {
                                            xy.setX(csubmap.getX());
                                            xy.setY(csubmap.getY());
                                        } else {
                                            int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                                            xy = MapProvisioningAdapter.this.getXY(onmsMap, elementsize);
                                            m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                                        }
                                        MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, onmsSubMap.getId(), "M", csubmap.getLabel(), csubmap.getIcon(), xy.getX(), xy.getY()));
                                        continue;
                                    }
                                    for (OnmsMapElement element : elements) {
                                        if (element.getElementId() != onmsSubMap.getId()) continue;
                                        continue block12;
                                    }
                                    MapProvisioningAdapter.this.m_onmsMapElementDao.save((Object)new OnmsMapElement(onmsMap, onmsSubMap.getId(), "W", csubmap.getLabel(), csubmap.getIcon(), 0, 0));
                                }
                                MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                            }
                            MapProvisioningAdapter.log().debug("syncMaps: maps synchronized.  releasing lock...");
                        }
                        finally {
                            MapProvisioningAdapter.this.m_mapsAdapterConfig.getReadLock().unlock();
                        }
                    }
                    MapProvisioningAdapter.log().info("syncMaps: lock released.");
                    return null;
                }
            });
        }
        catch (Exception e) {
            MapProvisioningAdapter.log().error("syncMaps: Caught exception synchronizing maps: " + e, (Throwable)e);
            throw new ProvisioningAdapterException("syncMaps exception", (Throwable)e);
        }
    }

    private void sendAndThrow(Throwable e) {
        Event event = this.buildEvent("uei.opennms.org/provisioner/provisioningAdapterFailed").addParam("reason", MESSAGE_PREFIX + e.getLocalizedMessage()).getEvent();
        this.m_eventForwarder.sendNow(event);
        MapProvisioningAdapter.log().error(e.getMessage());
        throw new ProvisioningAdapterException(MESSAGE_PREFIX, e);
    }

    private EventBuilder buildEvent(String uei) {
        return new EventBuilder(uei, "Provisioner", new Date());
    }

    public String getSuitableIp(OnmsNode node) {
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        if (primaryInterface == null) {
            Set ipInterfaces = node.getIpInterfaces();
            Iterator i$ = ipInterfaces.iterator();
            if (i$.hasNext()) {
                OnmsIpInterface onmsIpInterface = (OnmsIpInterface)i$.next();
                return InetAddressUtils.str((InetAddress)onmsIpInterface.getIpAddress());
            }
            return "0.0.0.0";
        }
        return InetAddressUtils.str((InetAddress)primaryInterface.getIpAddress());
    }

    private String getLabel(String FQDN) {
        if (FQDN.indexOf(".") > 0 && !this.validate(FQDN)) {
            return FQDN.substring(0, FQDN.indexOf("."));
        }
        return FQDN;
    }

    private boolean validate(String ip) {
        Matcher matcher = m_pattern.matcher(ip);
        return matcher.matches();
    }

    static {
        m_pattern = Pattern.compile(IPADDRESS_PATTERN);
    }

    class MapSyncExecutor
    implements Runnable {
        MapSyncExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MapProvisioningAdapter.this.syncMaps();
            while (true) {
                try {
                    MapProvisioningAdapter.log().debug("Sleeping: 300000");
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    MapProvisioningAdapter.log().error("Cannot sleep:" + e.getLocalizedMessage());
                }
                if (MapProvisioningAdapter.this.doSync) {
                    MapProvisioningAdapter.log().debug("Synchronization started");
                    TreeSet<Integer> deletes = new TreeSet<Integer>();
                    TreeSet<Integer> adds = new TreeSet<Integer>();
                    TreeSet<Integer> updates = new TreeSet<Integer>();
                    MapProvisioningAdapter.log().info("acquiring lock...");
                    Object object = MapProvisioningAdapter.this.m_lock;
                    synchronized (object) {
                        for (Integer i : MapProvisioningAdapter.this.m_deletes) {
                            deletes.add(i);
                        }
                        for (Integer i : MapProvisioningAdapter.this.m_adds) {
                            adds.add(i);
                        }
                        for (Integer i : MapProvisioningAdapter.this.m_updates) {
                            updates.add(i);
                        }
                        MapProvisioningAdapter.this.m_deletes = new TreeSet();
                        MapProvisioningAdapter.this.m_updates = new TreeSet();
                        MapProvisioningAdapter.this.m_adds = new TreeSet();
                        MapProvisioningAdapter.this.doSync = false;
                    }
                    MapProvisioningAdapter.log().info("lock released.");
                    MapProvisioningAdapter.this.reSyncMap(deletes, adds, updates);
                    continue;
                }
                MapProvisioningAdapter.log().debug("No Synchronization required");
            }
        }
    }

    private class XY {
        int x;
        int y;

        protected XY() {
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
}

