/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.provision.adapters.link.DefaultLinkMatchResolverImpl;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath*:/META-INF/opennms/provisiond-extensions.xml", "classpath*:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/testConfigContext.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DefaultLinkMatchResolverTest {
    @Autowired
    private DefaultLinkMatchResolverImpl m_resolver;

    @Before
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("log4j.logger.org.springframework", "WARN");
        props.setProperty("log4j.logger.org.hibernate", "WARN");
        props.setProperty("log4j.logger.org.opennms", "DEBUG");
        props.setProperty("log4j.logger.org.opennms.netmgt.dao.castor", "WARN");
        MockLogAppender.setupLogging((Properties)props);
    }

    @Test
    public void testSimpleMatch() {
        Assert.assertEquals((Object)"nc-ral0002-to-ral0001-dwave", (Object)this.m_resolver.getAssociatedEndPoint("nc-ral0001-to-ral0002-dwave"));
    }

    @Test
    public void testMultiplePatterns() {
        Assert.assertEquals((Object)"middle-was-bar", (Object)this.m_resolver.getAssociatedEndPoint("foo-bar-baz"));
        Assert.assertEquals((Object)"middle-was-now", (Object)this.m_resolver.getAssociatedEndPoint("before-now-after"));
        Assert.assertNull((Object)this.m_resolver.getAssociatedEndPoint("after-wasn't-before"));
    }

    @Test
    public void testPatternsFromConfig() {
        Assert.assertEquals((Object)"middle-was-bar", (Object)this.m_resolver.getAssociatedEndPoint("foo-bar-baz"));
        Assert.assertEquals((Object)"middle-was-now", (Object)this.m_resolver.getAssociatedEndPoint("before-now-after"));
        Assert.assertNull((Object)this.m_resolver.getAssociatedEndPoint("after-wasn't-before"));
    }
}

