/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsLinkState;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.provision.adapters.link.LinkEventCorrelator;
import org.opennms.netmgt.provision.adapters.link.NodeLinkService;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.DefaultEndPointConfigurationDao;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.EndPointConfigurationDao;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class LinkEventCorrelatorTest {
    private Event m_unmanagedEvent = new EventBuilder("uei.opennms.org/internal/linkd/dataLinkUnmanaged", "Test").getEvent();
    private Event m_failedEvent = new EventBuilder("uei.opennms.org/internal/linkd/dataLinkFailed", "Test").getEvent();
    private Event m_regainedEvent = new EventBuilder("uei.opennms.org/internal/linkd/dataLinkRestored", "Test").getEvent();
    EasyMockUtils m_easyMock = new EasyMockUtils();
    private MockNetwork m_network;
    private MockNode m_node1;
    private MockNode m_node2;
    private MockEventIpcManager m_eventIpcManager;
    private EventAnticipator m_anticipator;
    private NodeLinkService m_nodeLinkService;
    private DataLinkInterface m_dataLinkInterface;
    private DefaultEndPointConfigurationDao m_endPointConfigDao;

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        this.m_eventIpcManager = new MockEventIpcManager();
        this.m_anticipator = this.m_eventIpcManager.getEventAnticipator();
        this.m_endPointConfigDao = new DefaultEndPointConfigurationDao();
        this.m_endPointConfigDao.setConfigResource((Resource)new ClassPathResource("/test-endpoint-configuration.xml"));
        this.m_endPointConfigDao.afterPropertiesSet();
        this.m_network = new MockNetwork();
        this.m_node1 = new MockNode(this.m_network, 1, "pittsboro-1");
        this.m_node1.addInterface("192.168.0.1").addService("EndPoint", 1);
        this.m_node2 = new MockNode(this.m_network, 2, "pittsboro-2");
        this.m_node2.addInterface("192.168.0.2").addService("EndPoint", 1);
        this.m_nodeLinkService = this.createMock(NodeLinkService.class);
        OnmsNode node = new OnmsNode(new OnmsDistPoller("localhost", "127.0.0.1"), "pittsboro-2");
        node.setId(Integer.valueOf(2));
        ArrayList<DataLinkInterface> dlis = new ArrayList<DataLinkInterface>();
        this.m_dataLinkInterface = new DataLinkInterface(node, 1, 1, 1, OnmsArpInterface.StatusType.UNKNOWN, new Date());
        dlis.add(this.m_dataLinkInterface);
        EasyMock.expect((Object)this.m_nodeLinkService.getLinkContainingNodeId(1)).andStubReturn(dlis);
        EasyMock.expect((Object)this.m_nodeLinkService.getLinkContainingNodeId(2)).andStubReturn(dlis);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeLabel(1)).andStubReturn((Object)"pittsboro-1");
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeLabel(2)).andStubReturn((Object)"pittsboro-2");
    }

    @Test
    public void testNodeDownEvent() {
        OnmsLinkState ls = new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_UP);
        EasyMock.expect((Object)this.m_nodeLinkService.getLinkStateForInterface(this.m_dataLinkInterface)).andStubReturn((Object)ls);
        EasyMock.expect((Object)this.m_nodeLinkService.nodeHasEndPointService(1)).andReturn((Object)true);
        Event e = this.m_node1.createDownEvent();
        e.setService("EndPoint");
        LinkEventCorrelator correlator = new LinkEventCorrelator();
        correlator.setEventForwarder((EventForwarder)this.m_eventIpcManager);
        correlator.setNodeLinkService(this.m_nodeLinkService);
        correlator.setEndPointConfigDao((EndPointConfigurationDao)this.m_endPointConfigDao);
        this.m_anticipator.anticipateEvent(this.m_failedEvent);
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_PARENT_NODE_DOWN));
        this.replay();
        correlator.handleNodeDown(e);
        this.m_eventIpcManager.finishProcessingEvents();
        this.m_anticipator.verifyAnticipated();
        this.verify();
    }

    @Test
    public void testCorrelator1NodeDown() {
        OnmsLinkState ls = new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_UP);
        EasyMock.expect((Object)this.m_nodeLinkService.getLinkStateForInterface(this.m_dataLinkInterface)).andStubReturn((Object)ls);
        EasyMock.expect((Object)this.m_nodeLinkService.nodeHasEndPointService(1)).andReturn((Object)true);
        Event e = this.m_node1.createDownEvent();
        e.setService("EndPoint");
        LinkEventCorrelator correlator = new LinkEventCorrelator();
        correlator.setEventForwarder((EventForwarder)this.m_eventIpcManager);
        correlator.setNodeLinkService(this.m_nodeLinkService);
        correlator.setEndPointConfigDao((EndPointConfigurationDao)this.m_endPointConfigDao);
        this.m_anticipator.anticipateEvent(this.m_failedEvent);
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_PARENT_NODE_DOWN));
        this.replay();
        correlator.handleNodeDown(e);
        this.m_eventIpcManager.finishProcessingEvents();
        this.m_anticipator.verifyAnticipated();
        List parms = ((Event)this.m_anticipator.getAnticipatedEventsRecieved().get(0)).getParmCollection();
        Assert.assertEquals((long)2L, (long)parms.size());
        int foundGood = 0;
        for (Parm p : parms) {
            if (!p.getParmName().contentEquals("endPoint1") && !p.getParmName().contentEquals("endPoint2") || !"pittsboro-1".equals(p.getValue().getContent()) && !"pittsboro-2".equals(p.getValue().getContent())) continue;
            ++foundGood;
        }
        Assert.assertEquals((String)"expect 2 endpoint parms", (long)2L, (long)foundGood);
        this.verify();
    }

    @Test
    public void testCorrelatorNodeFlap() {
        OnmsLinkState ls = new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_UP);
        EasyMock.expect((Object)this.m_nodeLinkService.getLinkStateForInterface(this.m_dataLinkInterface)).andStubReturn((Object)ls);
        EasyMock.expect((Object)this.m_nodeLinkService.nodeHasEndPointService(1)).andStubReturn((Object)true);
        EasyMock.expect((Object)this.m_nodeLinkService.nodeHasEndPointService(2)).andStubReturn((Object)true);
        LinkEventCorrelator correlator = new LinkEventCorrelator();
        correlator.setEventForwarder((EventForwarder)this.m_eventIpcManager);
        correlator.setNodeLinkService(this.m_nodeLinkService);
        correlator.setEndPointConfigDao((EndPointConfigurationDao)this.m_endPointConfigDao);
        EasyMock.expect((Object)this.m_nodeLinkService.getPrimaryAddress(1)).andStubReturn((Object)"192.168.0.1");
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_PARENT_NODE_DOWN));
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_PARENT_NODE_DOWN));
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_BOTH_DOWN));
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_NODE_DOWN));
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_NODE_DOWN));
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_UP));
        this.replay();
        this.m_anticipator.anticipateEvent(this.m_failedEvent);
        this.m_anticipator.anticipateEvent(this.m_regainedEvent);
        correlator.handleInterfaceDown(this.m_node1.getInterface("192.168.0.1").createDownEvent());
        correlator.handleNodeDown(this.m_node1.createDownEvent());
        correlator.handleNodeDown(this.m_node2.createDownEvent());
        correlator.handleInterfaceUp(this.m_node1.getInterface("192.168.0.1").createUpEvent());
        correlator.handleNodeUp(this.m_node1.createUpEvent());
        correlator.handleNodeUp(this.m_node2.createUpEvent());
        this.m_eventIpcManager.finishProcessingEvents();
        this.m_anticipator.verifyAnticipated();
        List parms = ((Event)this.m_anticipator.getAnticipatedEventsRecieved().get(0)).getParmCollection();
        Assert.assertEquals((long)2L, (long)parms.size());
        int foundGood = 0;
        for (Parm p : parms) {
            if (!p.getParmName().contentEquals("endPoint1") && !p.getParmName().contentEquals("endPoint2") || !"pittsboro-1".equals(p.getValue().getContent()) && !"pittsboro-2".equals(p.getValue().getContent())) continue;
            ++foundGood;
        }
        Assert.assertEquals((String)"expect 2 endpoint parms", (long)2L, (long)foundGood);
        this.verify();
    }

    @Test
    public void testCorrelatorUnmanagedNodeFlap() {
        OnmsLinkState ls = new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_BOTH_UNMANAGED);
        EasyMock.expect((Object)this.m_nodeLinkService.getLinkStateForInterface(this.m_dataLinkInterface)).andStubReturn((Object)ls);
        LinkEventCorrelator correlator = new LinkEventCorrelator();
        correlator.setEventForwarder((EventForwarder)this.m_eventIpcManager);
        correlator.setNodeLinkService(this.m_nodeLinkService);
        correlator.setEndPointConfigDao((EndPointConfigurationDao)this.m_endPointConfigDao);
        EasyMock.expect((Object)this.m_nodeLinkService.getPrimaryAddress(1)).andStubReturn((Object)"192.168.0.1");
        EasyMock.expect((Object)this.m_nodeLinkService.getPrimaryAddress(2)).andStubReturn((Object)"192.168.0.2");
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_NODE_UNMANAGED));
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_UP));
        this.m_nodeLinkService.saveLinkState(new OnmsLinkState(this.m_dataLinkInterface, OnmsLinkState.LinkState.LINK_PARENT_NODE_UNMANAGED));
        this.replay();
        this.m_anticipator.anticipateEvent(this.m_regainedEvent);
        this.m_anticipator.anticipateEvent(this.m_unmanagedEvent);
        correlator.handleNodeGainedService(this.m_node1.getInterface("192.168.0.1").getService("EndPoint").createNewEvent());
        correlator.handleNodeGainedService(this.m_node2.getInterface("192.168.0.2").getService("EndPoint").createNewEvent());
        correlator.handleServiceDeleted(this.m_node1.getInterface("192.168.0.1").getService("EndPoint").createDeleteEvent());
        this.m_eventIpcManager.finishProcessingEvents();
        this.m_anticipator.verifyAnticipated();
        List parms = ((Event)this.m_anticipator.getAnticipatedEventsRecieved().get(0)).getParmCollection();
        Assert.assertEquals((long)2L, (long)parms.size());
        int foundGood = 0;
        for (Parm p : parms) {
            if (!p.getParmName().contentEquals("endPoint1") && !p.getParmName().contentEquals("endPoint2") || !"pittsboro-1".equals(p.getValue().getContent()) && !"pittsboro-2".equals(p.getValue().getContent())) continue;
            ++foundGood;
        }
        Assert.assertEquals((String)"expect 2 endpoint parms", (long)2L, (long)foundGood);
        this.verify();
    }

    public <T> T createMock(Class<T> clazz) {
        return (T)this.m_easyMock.createMock(clazz);
    }

    public void verify() {
        this.m_easyMock.verifyAll();
    }

    public void replay() {
        this.m_easyMock.replayAll();
    }
}

