/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.util.Date;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.adapters.link.LinkMatchResolver;
import org.opennms.netmgt.provision.adapters.link.LinkProvisioningAdapter;
import org.opennms.netmgt.provision.adapters.link.NodeLinkService;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath*:/META-INF/opennms/provisiond-extensions.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:testConfigContext.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class LinkProvisioningAdapterTest
implements InitializingBean {
    public static final String END_POINT_1 = "nc-ral0001-to-ral0002-dwave";
    public static final String END_POINT_2 = "nc-ral0002-to-ral0001-dwave";
    public static final String UP_STATUS = "G";
    public static final String FAILED_STATUS = "B";
    @Autowired
    LinkProvisioningAdapter m_adapter;
    EasyMockUtils m_easyMock = new EasyMockUtils();
    private LinkMatchResolver m_matchResolver;
    private NodeLinkService m_nodeLinkService;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_matchResolver = this.createMock(LinkMatchResolver.class);
        this.m_nodeLinkService = this.createMock(NodeLinkService.class);
        EasyMock.expect((Object)this.m_matchResolver.getAssociatedEndPoint(END_POINT_1)).andStubReturn((Object)END_POINT_2);
        EasyMock.expect((Object)this.m_matchResolver.getAssociatedEndPoint(END_POINT_2)).andStubReturn((Object)END_POINT_1);
        EasyMock.expect((Object)this.m_matchResolver.getAssociatedEndPoint((String)EasyMock.not((Object)EasyMock.or((Object)EasyMock.eq((Object)END_POINT_1), (Object)EasyMock.eq((Object)END_POINT_2))))).andStubReturn(null);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeLabel(1)).andStubReturn((Object)END_POINT_1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeLabel(2)).andStubReturn((Object)END_POINT_2);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeLabel(EasyMock.not((int)EasyMock.or((int)EasyMock.eq((int)1), (int)EasyMock.eq((int)2))))).andStubReturn(null);
    }

    @Test
    public void dwoTestStubs() {
        this.replay();
        Assert.assertEquals((Object)END_POINT_2, (Object)this.m_matchResolver.getAssociatedEndPoint(END_POINT_1));
        Assert.assertEquals((Object)END_POINT_1, (Object)this.m_matchResolver.getAssociatedEndPoint(END_POINT_2));
        Assert.assertNull((Object)this.m_matchResolver.getAssociatedEndPoint("other"));
        Assert.assertEquals((Object)END_POINT_1, (Object)this.m_nodeLinkService.getNodeLabel(1));
        Assert.assertEquals((Object)END_POINT_2, (Object)this.m_nodeLinkService.getNodeLabel(2));
        Assert.assertNull((Object)this.m_nodeLinkService.getNodeLabel(17));
        this.verify();
    }

    @Test
    public void dwoAddLinkedNodes() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andReturn(null).andStubReturn((Object)2);
        this.m_nodeLinkService.createLink(1, 2);
        this.replay();
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.doAddNode(1);
        this.m_adapter.doAddNode(2);
        this.verify();
    }

    @Test
    public void dwoAddEndPoint2EndPoint1Exists() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andStubReturn((Object)2);
        this.m_nodeLinkService.createLink(1, 2);
        this.replay();
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.doAddNode(2);
        this.verify();
    }

    @Test
    public void dwoAddEndPoint1EndPoint2Exists() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andStubReturn((Object)2);
        this.m_nodeLinkService.createLink(1, 2);
        this.replay();
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.doAddNode(1);
        this.verify();
    }

    @Test
    public void dwoDataLinkFailedEventEndPoint1() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andStubReturn((Object)2);
        this.m_nodeLinkService.updateLinkStatus(1, 2, FAILED_STATUS);
        this.replay();
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/linkd/dataLinkFailed", null);
        eventBuilder.setParam("endPoint1", END_POINT_1);
        eventBuilder.setParam("endPoint2", END_POINT_2);
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.dataLinkFailed(eventBuilder.getEvent());
        this.verify();
    }

    @Test
    public void dwoDataLinkFailEventEndPoint2() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andStubReturn((Object)2);
        this.m_nodeLinkService.updateLinkStatus(1, 2, FAILED_STATUS);
        this.replay();
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/linkd/dataLinkFailed", null);
        eventBuilder.setParam("endPoint1", END_POINT_2);
        eventBuilder.setParam("endPoint2", END_POINT_1);
        eventBuilder.setCreationTime(new Date());
        eventBuilder.setDescription("nodeLinkFailed");
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.dataLinkFailed(eventBuilder.getEvent());
        this.verify();
    }

    @Test
    public void dwoDataLinkRestoredEventEndPoint1() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andStubReturn((Object)2);
        this.m_nodeLinkService.updateLinkStatus(1, 2, UP_STATUS);
        this.replay();
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/linkd/dataLinkRestored", null);
        eventBuilder.setParam("endPoint1", END_POINT_1);
        eventBuilder.setParam("endPoint2", END_POINT_2);
        eventBuilder.setCreationTime(new Date());
        eventBuilder.setDescription("nodeLinkFailed");
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.dataLinkRestored(eventBuilder.getEvent());
        this.verify();
    }

    @Test
    public void dwoDataLinkRestoredEventEndPoint2() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andStubReturn((Object)2);
        this.m_nodeLinkService.updateLinkStatus(1, 2, UP_STATUS);
        this.replay();
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/linkd/dataLinkRestored", null);
        eventBuilder.setParam("endPoint1", END_POINT_2);
        eventBuilder.setParam("endPoint2", END_POINT_1);
        eventBuilder.setCreationTime(new Date());
        eventBuilder.setDescription("nodeLinkFailed");
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.dataLinkRestored(eventBuilder.getEvent());
        this.verify();
    }

    @Test
    public void dwoTestUpdateEndPoint1() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andReturn(null).andStubReturn((Object)2);
        this.m_nodeLinkService.createLink(1, 2);
        this.replay();
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.doAddNode(1);
        this.m_adapter.doAddNode(2);
        this.verify();
    }

    @Test
    public void dwoUpdateEndPoint2EndPoint1Exists() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andStubReturn((Object)2);
        this.m_nodeLinkService.createLink(1, 2);
        this.replay();
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.doAddNode(2);
        this.verify();
    }

    @Test
    public void dwoUpdateEndPoint1EndPoint2Exists() {
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_1)).andStubReturn((Object)1);
        EasyMock.expect((Object)this.m_nodeLinkService.getNodeId(END_POINT_2)).andStubReturn((Object)2);
        this.m_nodeLinkService.createLink(1, 2);
        this.replay();
        this.m_adapter.setLinkMatchResolver(this.m_matchResolver);
        this.m_adapter.setNodeLinkService(this.m_nodeLinkService);
        this.m_adapter.doAddNode(1);
        this.verify();
    }

    public <T> T createMock(Class<T> clazz) {
        return (T)this.m_easyMock.createMock(clazz);
    }

    public void verify() {
        this.m_easyMock.verifyAll();
    }

    public void replay() {
        this.m_easyMock.replayAll();
    }

    @Test
    public void dwoAddNodeCallsDoAddNode() throws InterruptedException {
        this.m_adapter.addNode(1);
        Assert.assertEquals((long)1L, (long)this.m_adapter.getOperationQueue().getOperationQueueForNode(Integer.valueOf(1)).size());
        Thread.sleep(3000L);
        Assert.assertEquals((long)0L, (long)this.m_adapter.getOperationQueue().getOperationQueueForNode(Integer.valueOf(1)).size());
    }

    @Test
    public void dwoDeleteNodeCallsDoDeleteNode() throws InterruptedException {
        this.m_adapter.deleteNode(1);
        Assert.assertEquals((long)1L, (long)this.m_adapter.getOperationQueue().getOperationQueueForNode(Integer.valueOf(1)).size());
        Thread.sleep(3000L);
        Assert.assertEquals((long)0L, (long)this.m_adapter.getOperationQueue().getOperationQueueForNode(Integer.valueOf(1)).size());
    }

    @Test
    public void dwoUpdateNodeCallsDoUpdateNode() throws InterruptedException {
        this.m_adapter.updateNode(1);
        Assert.assertEquals((long)1L, (long)this.m_adapter.getOperationQueue().getOperationQueueForNode(Integer.valueOf(1)).size());
        Thread.sleep(3000L);
        Assert.assertEquals((long)0L, (long)this.m_adapter.getOperationQueue().getOperationQueueForNode(Integer.valueOf(1)).size());
    }

    @Test
    public void dwoNotifyConfigChangeCallsDoNotifyConfigChange() throws InterruptedException {
        this.m_adapter.nodeConfigChanged(1);
        Assert.assertEquals((long)1L, (long)this.m_adapter.getOperationQueue().getOperationQueueForNode(Integer.valueOf(1)).size());
        Thread.sleep(3000L);
        Assert.assertEquals((long)0L, (long)this.m_adapter.getOperationQueue().getOperationQueueForNode(Integer.valueOf(1)).size());
    }
}

