/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.endpoint;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.config.SnmpAgentConfigFactory;
import org.opennms.netmgt.provision.adapters.link.EndPointImpl;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointTypeValidator;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.EndPointConfigurationDao;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class EndPointDetector
extends SyncAbstractDetector
implements InitializingBean {
    protected static final String DEFAULT_SERVICE_NAME = "EndPoint";
    private static final String SYS_OBJECT_ID = ".1.3.6.1.2.1.1.2.0";
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_TIMEOUT = -1;
    private static final int DEFAULT_RETRIES = -1;
    private String m_forceVersion;
    @Autowired
    private SnmpAgentConfigFactory m_agentConfigFactory;
    @Autowired
    private EndPointConfigurationDao m_configDao;

    public EndPointDetector() {
        super(DEFAULT_SERVICE_NAME, -1, -1, -1);
    }

    public EndPointDetector(String serviceName, int port) {
        super(serviceName, port, -1, -1);
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)((Object)this));
    }

    public boolean isServiceDetected(InetAddress address) {
        try {
            SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(address);
            this.configureAgentPTR(agentConfig);
            this.configureAgentVersion(agentConfig);
            String retrievedValue = this.getValue(agentConfig, SYS_OBJECT_ID);
            EndPointTypeValidator validator = this.m_configDao.getValidator();
            EndPointImpl ep = new EndPointImpl();
            ep.setSysOid(retrievedValue);
            return validator.hasMatch(ep);
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    protected void configureAgentVersion(SnmpAgentConfig agentConfig) {
        if (this.getForceVersion() != null) {
            String version = this.getForceVersion();
            if (version.equalsIgnoreCase("snmpv1")) {
                agentConfig.setVersion(1);
            } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                agentConfig.setVersion(2);
            } else if (version.equalsIgnoreCase("snmpv3")) {
                agentConfig.setVersion(3);
            }
        }
    }

    protected void configureAgentPTR(SnmpAgentConfig agentConfig) {
        if (this.getPort() > 0) {
            agentConfig.setPort(this.getPort());
        }
        if (this.getTimeout() > 0) {
            agentConfig.setTimeout(this.getTimeout());
        }
        if (this.getRetries() > -1) {
            agentConfig.setRetries(this.getRetries());
        }
    }

    protected String getValue(SnmpAgentConfig agentConfig, String oid) {
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)SnmpObjId.get((String)oid));
        if (val == null || val.isNull() || val.isEndOfMib() || val.isError()) {
            return null;
        }
        return val.toString();
    }

    public void setForceVersion(String forceVersion) {
        this.m_forceVersion = forceVersion;
    }

    public String getForceVersion() {
        return this.m_forceVersion;
    }

    public void setAgentConfigFactory(SnmpAgentConfigFactory agentConfigFactory) {
        this.m_agentConfigFactory = agentConfigFactory;
    }

    public SnmpAgentConfigFactory getAgentConfigFactory() {
        return this.m_agentConfigFactory;
    }

    public void setEndPointConfigurationDao(EndPointConfigurationDao dao) {
        this.m_configDao = dao;
    }

    public EndPointConfigurationDao getEndPointConfigurationDao() {
        return this.m_configDao;
    }

    protected void onInit() {
    }

    public void dispose() {
    }
}

