/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link.config.dao;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.netmgt.provision.adapters.link.config.dao.LinkAdapterConfigurationDao;
import org.opennms.netmgt.provision.adapters.link.config.linkadapter.LinkAdapterConfiguration;
import org.opennms.netmgt.provision.adapters.link.config.linkadapter.LinkPattern;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public class DefaultLinkAdapterConfigurationDao
extends AbstractJaxbConfigDao<LinkAdapterConfiguration, LinkAdapterConfiguration>
implements LinkAdapterConfigurationDao {
    public DefaultLinkAdapterConfigurationDao() {
        super(LinkAdapterConfiguration.class, "Map Link Adapter Configuration");
    }

    public DefaultLinkAdapterConfigurationDao(Class<LinkAdapterConfiguration> entityClass, String description) {
        super(entityClass, description);
    }

    public LinkAdapterConfiguration translateConfig(LinkAdapterConfiguration config) {
        return config;
    }

    @Override
    public Set<LinkPattern> getPatterns() {
        Assert.notNull((Object)this.getContainer(), (String)"LinkAdapterConfigDao has no container!");
        Assert.notNull((Object)this.getContainer().getObject(), (String)"LinkAdapterConfigDao has no configuration loaded!");
        return ((LinkAdapterConfiguration)this.getContainer().getObject()).getPatterns();
    }

    @Override
    public void setPatterns(Set<LinkPattern> patterns) {
        Assert.notNull((Object)this.getContainer(), (String)"LinkAdapterConfigDao has no container!");
        Assert.notNull((Object)this.getContainer().getObject(), (String)"LinkAdapterConfigDao has no configuration loaded!");
        ((LinkAdapterConfiguration)this.getContainer().getObject()).setPatterns(patterns);
    }

    @Override
    public synchronized void saveCurrent() {
        File file;
        try {
            file = this.getConfigResource().getFile();
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("Unable to determine file for " + this.getConfigResource() + ": " + e, (Throwable)e);
        }
        if (file == null) {
            throw new DataAccessResourceFailureException("Unable to determine file for " + this.getConfigResource());
        }
        StringWriter stringWriter = new StringWriter();
        JaxbUtils.marshal((Object)this.getContainer().getObject(), (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            FileOutputStream os = null;
            OutputStreamWriter fileWriter = null;
            try {
                os = new FileOutputStream(file);
                fileWriter = new OutputStreamWriter((OutputStream)os, "UTF-8");
                fileWriter.write(stringWriter.toString());
            }
            catch (IOException e) {
                try {
                    throw new DataAccessResourceFailureException("Could not write resource " + this.getConfigResource() + " to file " + file.getPath() + ": " + e, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileWriter);
                    IOUtils.closeQuietly((OutputStream)os);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)fileWriter);
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    protected LinkAdapterConfiguration loadConfig(Resource resource) {
        long startTime = System.currentTimeMillis();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Loading " + this.getDescription() + " configuration from " + resource);
        }
        try {
            LinkAdapterConfiguration config = (LinkAdapterConfiguration)JaxbUtils.unmarshal(LinkAdapterConfiguration.class, (Resource)resource);
            long endTime = System.currentTimeMillis();
            this.log().info(this.createLoadedLogMessage(config, endTime - startTime));
            this.log().info(config.toString());
            return config;
        }
        catch (Throwable e) {
            throw new MarshallingResourceFailureException("Unable to unmarshal the link adapter configuration.", e);
        }
    }
}

