/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.io.Serializable;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.LinkStateDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLinkState;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.provision.adapters.link.NodeLinkService;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/provisiond-extensions.xml", "classpath:/testConfigContext.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DefaultNodeLinkServiceTest
implements InitializingBean {
    private int END_POINT1_ID;
    private int END_POINT2_ID;
    private int END_POINT3_ID;
    private String END_POINT1_LABEL = "node1";
    public String NO_SUCH_NODE_LABEL = "noSuchNode";
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    LinkStateDao m_linkStateDao;
    @Autowired
    DataLinkInterfaceDao m_dataLinkDao;
    @Autowired
    MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    JdbcTemplate m_jdbcTemplate;
    @Autowired
    NodeLinkService m_nodeLinkService;
    @Autowired
    ServiceTypeDao m_serviceTypeDao;
    @Autowired
    TransactionTemplate m_transactionTemplate;

    @Before
    public void setup() {
        this.m_dbPopulator.populateDatabase();
        this.END_POINT1_ID = this.m_dbPopulator.getNode1().getId();
        this.END_POINT1_LABEL = this.m_dbPopulator.getNode1().getLabel();
        this.END_POINT2_ID = this.m_dbPopulator.getNode2().getId();
        this.END_POINT3_ID = this.m_dbPopulator.getNode3().getId();
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    @Transactional
    public void dwoTestGetNodeLabel() {
        String nodeLabel = this.m_nodeLinkService.getNodeLabel(this.END_POINT1_ID);
        Assert.assertNotNull((Object)nodeLabel);
        Assert.assertEquals((Object)"node1", (Object)nodeLabel);
    }

    @Test
    @Transactional
    public void dwoTestNodeNotThere() {
        String nodeLabel = this.m_nodeLinkService.getNodeLabel(200);
        Assert.assertNull((Object)nodeLabel);
    }

    @Test
    @Transactional
    public void dwoTestGetNodeId() {
        Integer nodeId = this.m_nodeLinkService.getNodeId(this.END_POINT1_LABEL);
        Assert.assertNotNull((Object)nodeId);
        Assert.assertEquals((long)this.END_POINT1_ID, (long)nodeId.intValue());
    }

    @Test
    @Transactional
    public void dwoTestGetNodeIdNull() {
        Integer nodeId = this.m_nodeLinkService.getNodeId(this.NO_SUCH_NODE_LABEL);
        Assert.assertNull((Object)nodeId);
    }

    @Test
    @Transactional
    public void dwoTestCreateLink() {
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(this.END_POINT3_ID));
        Assert.assertEquals((long)0L, (long)dataLinks.size());
        this.m_nodeLinkService.createLink(this.END_POINT1_ID, this.END_POINT3_ID);
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(this.END_POINT3_ID));
        Assert.assertEquals((long)1L, (long)dataLinks.size());
    }

    @Test
    @Transactional
    public void dwoTestLinkAlreadyExists() {
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(this.END_POINT2_ID));
        Assert.assertEquals((long)1L, (long)dataLinks.size());
        this.m_nodeLinkService.createLink(this.END_POINT1_ID, this.END_POINT2_ID);
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(this.END_POINT2_ID));
        Assert.assertEquals((long)1L, (long)dataLinks.size());
    }

    @Test
    @Transactional
    public void dwoTestUpdateLinkStatus() {
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(this.END_POINT2_ID));
        Assert.assertEquals((Object)"A", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
        int parentNodeId = this.END_POINT1_ID;
        int nodeId = this.END_POINT2_ID;
        this.m_nodeLinkService.updateLinkStatus(parentNodeId, nodeId, "G");
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(this.END_POINT2_ID));
        Assert.assertEquals((Object)"G", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
    }

    @Test
    @Transactional
    public void dwoTestUpdateLinkFailedStatus() {
        int parentNodeId = this.END_POINT1_ID;
        int nodeId = this.END_POINT2_ID;
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"A", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
        this.m_nodeLinkService.updateLinkStatus(parentNodeId, nodeId, "B");
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"B", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
    }

    @Test
    @Transactional
    public void dwoTestUpdateLinkGoodThenFailedStatus() {
        int parentNodeId = this.END_POINT1_ID;
        int nodeId = this.END_POINT2_ID;
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"A", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
        this.m_nodeLinkService.updateLinkStatus(parentNodeId, nodeId, "G");
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"G", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
        this.m_nodeLinkService.updateLinkStatus(parentNodeId, nodeId, "B");
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"B", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
    }

    @Test
    @Transactional
    public void dwoTestGetLinkContainingNodeId() {
        int parentNodeId = this.END_POINT1_ID;
        Collection datalinks = this.m_nodeLinkService.getLinkContainingNodeId(parentNodeId);
        Assert.assertEquals((long)3L, (long)datalinks.size());
    }

    @Test
    @Transactional
    public void dwoTestGetLinkStateForInterface() {
        int nodeId = this.END_POINT2_ID;
        Collection dlis = this.m_nodeLinkService.getLinkContainingNodeId(nodeId);
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        Assert.assertNotNull((Object)dli);
        OnmsLinkState linkState = new OnmsLinkState();
        linkState.setDataLinkInterface(dli);
        this.m_linkStateDao.save((Object)linkState);
        this.m_linkStateDao.flush();
        linkState = this.m_nodeLinkService.getLinkStateForInterface(dli);
        Assert.assertNotNull((String)"linkState was null", (Object)linkState);
        Assert.assertEquals((Object)OnmsLinkState.LinkState.LINK_UP, (Object)linkState.getLinkState());
    }

    @Test
    @Transactional
    public void dwoTestSaveLinkState() {
        int nodeId = this.END_POINT2_ID;
        Collection dlis = this.m_nodeLinkService.getLinkContainingNodeId(nodeId);
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        OnmsLinkState linkState = new OnmsLinkState();
        linkState.setDataLinkInterface(dli);
        this.m_linkStateDao.save((Object)linkState);
        this.m_linkStateDao.flush();
        OnmsLinkState linkState2 = this.m_nodeLinkService.getLinkStateForInterface(dli);
        Assert.assertNotNull((String)"linkState was null", (Object)linkState2);
        Assert.assertEquals((Object)OnmsLinkState.LinkState.LINK_UP, (Object)linkState2.getLinkState());
        linkState2.setLinkState(OnmsLinkState.LinkState.LINK_NODE_DOWN);
        this.m_nodeLinkService.saveLinkState(linkState2);
        OnmsLinkState linkState3 = this.m_nodeLinkService.getLinkStateForInterface(dli);
        Assert.assertEquals((Object)OnmsLinkState.LinkState.LINK_NODE_DOWN, (Object)linkState3.getLinkState());
    }

    @Test
    @Transactional
    public void dwoTestSaveAllEnumStates() {
        int nodeId = this.END_POINT2_ID;
        Collection dlis = this.m_nodeLinkService.getLinkContainingNodeId(nodeId);
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        OnmsLinkState linkState = new OnmsLinkState();
        linkState.setDataLinkInterface(dli);
        for (OnmsLinkState.LinkState ls : OnmsLinkState.LinkState.values()) {
            linkState.setLinkState(ls);
            this.saveLinkState(linkState);
        }
    }

    @Test
    @Transactional
    public void dwoTestAddPrimaryServiceToNode() {
        String END_POINT_SERVICE_NAME = "EndPoint";
        this.addPrimaryServiceToNode(this.END_POINT1_ID, "EndPoint");
        OnmsMonitoredService service = this.m_monitoredServiceDao.getPrimaryService(Integer.valueOf(this.END_POINT1_ID), "ICMP");
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"ICMP", (Object)service.getServiceName());
        service = this.m_monitoredServiceDao.getPrimaryService(Integer.valueOf(this.END_POINT1_ID), "EndPoint");
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"EndPoint", (Object)service.getServiceName());
    }

    @Test
    @Transactional
    public void dwoTestNodeHasEndPointService() {
        Assert.assertFalse((boolean)this.m_nodeLinkService.nodeHasEndPointService(this.END_POINT1_ID));
        String END_POINT_SERVICE_NAME = "EndPoint";
        this.addPrimaryServiceToNode(this.END_POINT1_ID, "EndPoint");
        Assert.assertTrue((boolean)this.m_nodeLinkService.nodeHasEndPointService(this.END_POINT1_ID));
    }

    public void addPrimaryServiceToNode(final int nodeId, final String serviceName) {
        this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                OnmsServiceType svcType = DefaultNodeLinkServiceTest.this.m_serviceTypeDao.findByName(serviceName);
                if (svcType == null) {
                    svcType = new OnmsServiceType(serviceName);
                    DefaultNodeLinkServiceTest.this.m_serviceTypeDao.save((Object)svcType);
                    DefaultNodeLinkServiceTest.this.m_serviceTypeDao.flush();
                }
                OnmsNode node = (OnmsNode)DefaultNodeLinkServiceTest.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                OnmsIpInterface ipInterface = node.getPrimaryInterface();
                OnmsMonitoredService svc = new OnmsMonitoredService();
                svc.setIpInterface(ipInterface);
                svc.setServiceType(svcType);
                DefaultNodeLinkServiceTest.this.m_monitoredServiceDao.save((Object)svc);
                DefaultNodeLinkServiceTest.this.m_monitoredServiceDao.flush();
                return null;
            }
        });
    }

    public void saveLinkState(final OnmsLinkState linkState) {
        this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                DefaultNodeLinkServiceTest.this.m_linkStateDao.saveOrUpdate((Object)linkState);
                DefaultNodeLinkServiceTest.this.m_linkStateDao.flush();
                return null;
            }
        });
    }
}

