/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link.endpoint;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.adapters.link.EndPoint;
import org.opennms.netmgt.provision.adapters.link.EndPointStatusException;
import org.opennms.netmgt.provision.adapters.link.EndPointValidationExpression;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointValidationExpressionImpl;

@XmlRootElement(name="endpoint-type")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EndPointType {
    @XmlAttribute(name="name")
    private String m_name;
    @XmlElement(name="sysoid-mask")
    private String m_sysOid;
    @XmlElementRef
    private EndPointValidationExpressionImpl m_validator;

    public EndPointType() {
    }

    public EndPointType(String sysOid, EndPointValidationExpressionImpl validator) {
        this.setSysOid(sysOid);
        this.setValidator(validator);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public EndPointValidationExpression getValidator() {
        return this.m_validator;
    }

    public void setValidator(EndPointValidationExpressionImpl validator) {
        this.m_validator = validator;
    }

    public String getSysOid() {
        return this.m_sysOid;
    }

    public void setSysOid(String sysOid) {
        this.m_sysOid = sysOid;
    }

    public boolean matches(EndPoint ep) {
        if (ep == null) {
            LogUtils.debugf((Object)this, (String)"EndPoint is null!", (Object[])new Object[0]);
            return false;
        }
        if (ep.getSysOid() == null) {
            LogUtils.debugf((Object)this, (String)"sysObjectId for endpoint %s is null", (Object[])new Object[]{ep});
            return false;
        }
        return ep.getSysOid().startsWith(this.getSysOid());
    }

    public void validate(EndPoint ep) throws EndPointStatusException {
        this.m_validator.validate(ep);
    }
}

