/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsLinkState;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.provision.adapters.link.LinkProvisioningAdapter;
import org.opennms.netmgt.provision.adapters.link.NodeLinkService;
import org.opennms.netmgt.xml.event.Event;

public class LinkEventSendingStateTransition
implements OnmsLinkState.LinkStateTransition {
    private DataLinkInterface m_dataLinkInterface;
    private EventForwarder m_eventForwarder;
    private NodeLinkService m_nodeLinkService;

    public LinkEventSendingStateTransition(DataLinkInterface dataLinkInterface, EventForwarder eventForwarder, NodeLinkService nodeLinkService) {
        this.m_dataLinkInterface = dataLinkInterface;
        this.m_eventForwarder = eventForwarder;
        this.m_nodeLinkService = nodeLinkService;
    }

    public void onLinkDown() {
        this.sendDataLinkEvent("uei.opennms.org/internal/linkd/dataLinkFailed");
    }

    private void sendDataLinkEvent(String uei) {
        String endPoint1 = this.m_dataLinkInterface.getNode().getLabel();
        String endPoint2 = this.m_nodeLinkService.getNodeLabel(this.m_dataLinkInterface.getNodeParentId());
        Event e = new EventBuilder(uei, "EventCorrelator").addParam("endPoint1", LinkProvisioningAdapter.min(endPoint1, endPoint2)).addParam("endPoint2", LinkProvisioningAdapter.max(endPoint1, endPoint2)).getEvent();
        this.m_eventForwarder.sendNow(e);
    }

    public void onLinkUp() {
        this.sendDataLinkEvent("uei.opennms.org/internal/linkd/dataLinkRestored");
    }

    public void onLinkUnknown() {
        this.sendDataLinkEvent("uei.opennms.org/internal/linkd/dataLinkUnmanaged");
    }
}

