/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jetty;

import java.io.File;
import java.util.Properties;
import org.eclipse.jetty.ajp.Ajp13SocketConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServer.class);
    private static final String LOG4J_CATEGORY = "jetty-server";
    int m_port = 8080;
    private Server m_server;

    protected JettyServer() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        Integer https_port;
        Integer requestHeaderSize;
        Properties p = System.getProperties();
        File homeDir = new File(p.getProperty("opennms.home"));
        File webappsDir = new File(homeDir, "jetty-webapps");
        this.m_server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setStatsOn(true);
        Integer port = Integer.getInteger("org.opennms.netmgt.jetty.port", this.m_port);
        connector.setPort(port.intValue());
        String host = System.getProperty("org.opennms.netmgt.jetty.host");
        if (host != null) {
            connector.setHost(host);
        }
        if ((requestHeaderSize = Integer.getInteger("org.opennms.netmgt.jetty.requestHeaderSize")) != null) {
            connector.setRequestHeaderSize(requestHeaderSize.intValue());
        }
        this.m_server.addConnector((Connector)connector);
        Integer ajp_port = Integer.getInteger("org.opennms.netmgt.jetty.ajp-port");
        if (ajp_port != null) {
            Ajp13SocketConnector ajpConnector = new Ajp13SocketConnector();
            ajpConnector.setStatsOn(true);
            ajpConnector.setPort(ajp_port.intValue());
            ajpConnector.setRequestHeaderSize(8096);
            this.m_server.addConnector((Connector)ajpConnector);
        }
        if ((https_port = Integer.getInteger("org.opennms.netmgt.jetty.https-port")) != null) {
            String keyStorePath = System.getProperty("org.opennms.netmgt.jetty.https-keystore", homeDir + File.separator + "etc" + File.separator + "examples" + File.separator + "jetty.keystore");
            String keyStorePassword = System.getProperty("org.opennms.netmgt.jetty.https-keystorepassword", "changeit");
            String keyManagerPassword = System.getProperty("org.opennms.netmgt.jetty.https-keypassword", "changeit");
            String certificateAlias = System.getProperty("org.opennms.netmgt.jetty.https-cert-alias", null);
            SslContextFactory contextFactory = new SslContextFactory(keyStorePath);
            contextFactory.setKeyStorePassword(keyStorePassword);
            contextFactory.setKeyManagerPassword(keyManagerPassword);
            if (certificateAlias != null && !"".equals(certificateAlias.trim())) {
                contextFactory.setCertAlias(certificateAlias);
            }
            this.excludeCipherSuites(contextFactory, https_port);
            SslSocketConnector sslConnector = new SslSocketConnector(contextFactory);
            sslConnector.setStatsOn(true);
            sslConnector.setPort(https_port.intValue());
            String httpsHost = System.getProperty("org.opennms.netmgt.jetty.https-host");
            if (httpsHost != null) {
                sslConnector.setHost(httpsHost);
            }
            this.m_server.addConnector((Connector)sslConnector);
        }
        HandlerCollection handlers = new HandlerCollection();
        boolean enableRequestLogging = Boolean.getBoolean("org.opennms.netmgt.jetty.enableRequestLogging");
        if (enableRequestLogging) {
            File logsDir = new File(homeDir, "logs");
            String logFileTemplate = new File(logsDir, "jetty-yyyy_mm_dd.request.log").getAbsolutePath();
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            NCSARequestLog requestLog = new NCSARequestLog(logFileTemplate);
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            handlers.addHandler((Handler)requestLogHandler);
        }
        if (webappsDir.exists()) {
            File rootDir = null;
            for (File file : webappsDir.listFiles()) {
                if (!file.isDirectory()) continue;
                if ("ROOT".equals(file.getName())) {
                    rootDir = file;
                    continue;
                }
                String contextPath = "/" + file.getName();
                this.addContext(handlers, file, contextPath);
            }
            if (rootDir != null) {
                this.addContext(handlers, rootDir, "/");
            }
        }
        this.m_server.setHandler((Handler)handlers);
        this.m_server.setStopAtShutdown(true);
    }

    protected void addContext(HandlerCollection handlers, File name, String contextPath) {
        LOG.warn("adding context: {} -> {}", (Object)contextPath, (Object)name.getAbsolutePath());
        WebAppContext wac = new WebAppContext();
        wac.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*\\.jar$");
        wac.setWar(name.getAbsolutePath());
        wac.setContextPath(contextPath);
        handlers.addHandler((Handler)wac);
    }

    protected void excludeCipherSuites(SslContextFactory contextFactory, Integer port) {
        String[] exclSuites;
        String[] defaultExclSuites = new String[]{"SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_RSA_WITH_DES_CBC_SHA"};
        String exclSuitesString = System.getProperty("org.opennms.netmgt.jetty.https-exclude-cipher-suites");
        if (exclSuitesString == null) {
            LOG.warn("No excluded SSL/TLS cipher suites specified, using hard-coded defaults");
            exclSuites = defaultExclSuites;
        } else {
            exclSuites = exclSuitesString.split("\\s*:\\s*");
            LOG.warn("Excluding {} user-specified SSL/TLS cipher suites", (Object)exclSuites.length);
        }
        contextFactory.setExcludeCipherSuites(exclSuites);
        for (String suite : exclSuites) {
            LOG.info("Excluded SSL/TLS cipher suite {} for connector on port {}", (Object)suite, (Object)port);
        }
    }

    protected void onStart() {
        try {
            this.m_server.start();
        }
        catch (Throwable t) {
            LOG.error("Error starting Jetty Server", t);
        }
    }

    protected void onStop() {
        try {
            this.m_server.stop();
        }
        catch (Throwable t) {
            LOG.error("Error stopping Jetty Server", t);
        }
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }

    public long getHttpsConnectionsTotal() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SslSocketConnector)) continue;
            retval += (long)conn.getConnections();
        }
        return retval;
    }

    public long getHttpsConnectionsOpen() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SslSocketConnector)) continue;
            retval += (long)conn.getConnectionsOpen();
        }
        return retval;
    }

    public long getHttpsConnectionsOpenMax() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SslSocketConnector)) continue;
            retval += (long)conn.getConnectionsOpenMax();
        }
        return retval;
    }

    public long getHttpConnectionsTotal() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SelectChannelConnector)) continue;
            retval += (long)conn.getConnections();
        }
        return retval;
    }

    public long getHttpConnectionsOpen() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SelectChannelConnector)) continue;
            retval += (long)conn.getConnectionsOpen();
        }
        return retval;
    }

    public long getHttpConnectionsOpenMax() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SelectChannelConnector)) continue;
            retval += (long)conn.getConnectionsOpenMax();
        }
        return retval;
    }
}

