/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.javamail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.javamail.JavaMailerConfig;
import org.opennms.javamail.JavaMailerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JavaMailer {
    private static final Logger LOG = LoggerFactory.getLogger(JavaMailer.class);
    private static final String DEFAULT_FROM_ADDRESS = "root@[127.0.0.1]";
    private static final String DEFAULT_MAIL_HOST = "127.0.0.1";
    private static final boolean DEFAULT_AUTHENTICATE = false;
    private static final String DEFAULT_AUTHENTICATE_USER = "opennms";
    private static final String DEFAULT_AUTHENTICATE_PASSWORD = "opennms";
    private static final String DEFAULT_MAILER = "smtpsend";
    private static final String DEFAULT_TRANSPORT = "smtp";
    private static final boolean DEFAULT_MAILER_DEBUG = false;
    private static final boolean DEFAULT_USE_JMTA = true;
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private static final String DEFAULT_CHARSET = "us-ascii";
    private static final String DEFAULT_ENCODING = "Q";
    private static final boolean DEFAULT_STARTTLS_ENABLE = false;
    private static final boolean DEFAULT_QUIT_WAIT = true;
    private static final int DEFAULT_SMTP_PORT = 25;
    private static final boolean DEFAULT_SMTP_SSL_ENABLE = false;
    private Session m_session = null;
    private Properties m_mailProps;
    private boolean m_debug;
    private String m_mailHost;
    private boolean m_useJMTA;
    private String m_mailer;
    private String m_transport;
    private String m_from;
    private boolean m_authenticate;
    private String m_user;
    private String m_password;
    private String m_contentType;
    private String m_charSet;
    private String m_encoding;
    private boolean m_startTlsEnabled;
    private boolean m_quitWait;
    private int m_smtpPort;
    private boolean m_smtpSsl;
    private String m_to;
    private String m_subject;
    private String m_messageText;
    private String m_fileName;
    private InputStream m_inputStream;
    private String m_inputStreamName;
    private String m_inputStreamContentType;
    private Map<String, String> m_extraHeaders = new HashMap<String, String>();

    public JavaMailer(Properties javamailProps) throws JavaMailerException {
        try {
            this.configureProperties(javamailProps);
        }
        catch (IOException e) {
            throw new JavaMailerException("Failed to construct mailer", e);
        }
        this.m_session = Session.getInstance((Properties)this.getMailProps(), (Authenticator)this.createAuthenticator());
    }

    public JavaMailer() throws JavaMailerException {
        this(new Properties());
    }

    private void configureProperties(Properties javamailProps) throws IOException {
        this.m_mailProps = JavaMailerConfig.getProperties();
        this.m_mailProps.putAll((Map<?, ?>)javamailProps);
        this.m_debug = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.debug", (boolean)false);
        this.m_mailHost = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.mailHost", (String)DEFAULT_MAIL_HOST);
        this.m_useJMTA = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.useJMTA", (boolean)true);
        this.m_mailer = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.mailer", (String)DEFAULT_MAILER);
        this.m_transport = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.transport", (String)DEFAULT_TRANSPORT);
        this.m_from = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.fromAddress", (String)DEFAULT_FROM_ADDRESS);
        this.m_authenticate = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.authenticate", (boolean)false);
        this.m_user = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.authenticateUser", (String)"opennms");
        this.m_password = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.authenticatePassword", (String)"opennms");
        this.m_contentType = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.messageContentType", (String)DEFAULT_CONTENT_TYPE);
        this.m_charSet = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.charset", (String)DEFAULT_CHARSET);
        this.m_encoding = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.encoding", (String)DEFAULT_ENCODING);
        this.m_startTlsEnabled = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.starttls.enable", (boolean)false);
        this.m_quitWait = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.quitwait", (boolean)true);
        this.m_smtpPort = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.smtpport", (int)25);
        this.m_smtpSsl = PropertiesUtils.getProperty((Properties)this.m_mailProps, (String)"org.opennms.core.utils.smtpssl.enable", (boolean)false);
        if (!this.m_mailProps.containsKey("mail.smtp.auth")) {
            this.m_mailProps.setProperty("mail.smtp.auth", String.valueOf(this.isAuthenticate()));
        }
        if (!this.m_mailProps.containsKey("mail.smtp.starttls.enable")) {
            this.m_mailProps.setProperty("mail.smtp.starttls.enable", String.valueOf(this.isStartTlsEnabled()));
        }
        if (!this.m_mailProps.containsKey("mail.smtp.quitwait")) {
            this.m_mailProps.setProperty("mail.smtp.quitwait", String.valueOf(this.isQuitWait()));
        }
        if (!this.m_mailProps.containsKey("mail.smtp.port")) {
            this.m_mailProps.setProperty("mail.smtp.port", String.valueOf(this.getSmtpPort()));
        }
        if (this.isSmtpSsl()) {
            if (!this.m_mailProps.containsKey("mail.smtps.auth")) {
                this.m_mailProps.setProperty("mail.smtps.auth", String.valueOf(this.isAuthenticate()));
            }
            if (!this.m_mailProps.containsKey("mail.smtps.socketFactory.class")) {
                this.m_mailProps.setProperty("mail.smtps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            if (!this.m_mailProps.containsKey("mail.smtps.socketFactory.port")) {
                this.m_mailProps.setProperty("mail.smtps.socketFactory.port", String.valueOf(this.getSmtpPort()));
            }
        }
        if (!this.m_mailProps.containsKey("mail.smtp.quitwait")) {
            this.m_mailProps.setProperty("mail.smtp.quitwait", "true");
        }
    }

    public void mailSend() throws JavaMailerException {
        LOG.debug(this.createSendLogMsg());
        this.sendMessage(this.buildMessage());
    }

    public Authenticator createAuthenticator() {
        Authenticator auth = this.isAuthenticate() ? new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(JavaMailer.this.getUser(), JavaMailer.this.getPassword());
            }
        } : null;
        return auth;
    }

    public Message buildMessage() throws JavaMailerException {
        try {
            this.checkEnvelopeAndContents();
            MimeMessage message = this.initializeMessage();
            String encodedText = this.getMessageText();
            if (this.getFileName() == null && this.getInputStream() == null) {
                message.setContent((Object)encodedText, this.m_contentType + "; charset=" + this.m_charSet);
            } else if (this.getFileName() == null) {
                MimeBodyPart streamBodyPart = new MimeBodyPart();
                streamBodyPart.setDataHandler(new DataHandler((DataSource)new InputStreamDataSource(this.m_inputStreamName, this.m_inputStreamContentType, this.m_inputStream)));
                streamBodyPart.setFileName(this.m_inputStreamName);
                streamBodyPart.setHeader("Content-Transfer-Encoding", "base64");
                streamBodyPart.setDisposition("attachment");
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)streamBodyPart);
                message.setContent((Multipart)mp);
            } else {
                MimeBodyPart bp = new MimeBodyPart();
                bp.setContent((Object)encodedText, this.m_contentType + "; charset=" + this.m_charSet);
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)bp);
                mp.addBodyPart((BodyPart)this.createFileAttachment(new File(this.getFileName())));
                message.setContent((Multipart)mp);
            }
            message.setHeader("X-Mailer", this.getMailer());
            message.setSentDate(new Date());
            message.saveChanges();
            return message;
        }
        catch (AddressException e) {
            LOG.error("Java Mailer Addressing exception: ", (Throwable)e);
            throw new JavaMailerException("Java Mailer Addressing exception: ", e);
        }
        catch (MessagingException e) {
            LOG.error("Java Mailer messaging exception: ", (Throwable)e);
            throw new JavaMailerException("Java Mailer messaging exception: ", e);
        }
    }

    private MimeMessage initializeMessage() throws MessagingException, AddressException {
        MimeMessage message = new MimeMessage(this.getSession());
        message.setFrom((Address)new InternetAddress(this.getFrom()));
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getTo(), (boolean)false));
        message.setSubject(this.getSubject(), this.m_charSet);
        for (String key : this.getExtraHeaders().keySet()) {
            message.setHeader(key, this.m_extraHeaders.get(key));
        }
        return message;
    }

    private String createSendLogMsg() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\tTo: ");
        sb.append(this.getTo());
        sb.append("\n\tFrom: ");
        sb.append(this.getFrom());
        sb.append("\n\tSubject is: ");
        sb.append(this.getSubject());
        sb.append("\n\tFile: ");
        sb.append(this.getFileName() != null ? this.getFileName() : "no file attached");
        sb.append("\n\n");
        sb.append(this.getMessageText());
        sb.append("\n");
        return sb.toString();
    }

    public MimeBodyPart createFileAttachment(File file) throws MessagingException, JavaMailerException {
        if (!file.exists()) {
            LOG.error("File attachment '{}' does not exist.", (Object)file.getAbsolutePath());
            throw new JavaMailerException("File attachment '" + file.getAbsolutePath() + "' does not exist.");
        }
        if (!file.canRead()) {
            LOG.error("File attachment '{}' is not readable.", (Object)file.getAbsolutePath());
            throw new JavaMailerException("File attachment '" + file.getAbsolutePath() + "' is not readable.");
        }
        MimeBodyPart bodyPart = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(file);
        bodyPart.setDataHandler(new DataHandler((DataSource)fds));
        bodyPart.setFileName(fds.getName());
        return bodyPart;
    }

    private void checkEnvelopeAndContents() throws JavaMailerException {
        if (this.getFrom() == null) {
            throw new JavaMailerException("Cannot have a null from address.");
        }
        if ("".equals(this.getFrom())) {
            throw new JavaMailerException("Cannot have an empty from address.");
        }
        if (this.getTo() == null) {
            throw new JavaMailerException("Cannot have a null to address.");
        }
        if ("".equals(this.getTo())) {
            throw new JavaMailerException("Cannot have an empty to address.");
        }
        if (this.getSubject() == null) {
            throw new JavaMailerException("Cannot have a null subject.");
        }
        if ("".equals(this.getSubject())) {
            throw new JavaMailerException("Cannot have an empty subject.");
        }
        if (this.getMessageText() == null) {
            throw new JavaMailerException("Cannot have a null messageText.");
        }
        if ("".equals(this.getMessageText())) {
            throw new JavaMailerException("Cannot have an empty messageText.");
        }
    }

    public void sendMessage(Message message) throws JavaMailerException {
        Transport t = null;
        try {
            t = this.getSession().getTransport(this.getTransport());
            LOG.debug("for transport name '{}' got: {}@{}", new Object[]{this.getTransport(), t.getClass().getName(), Integer.toHexString(t.hashCode())});
            LoggingTransportListener listener = new LoggingTransportListener();
            t.addTransportListener((TransportListener)listener);
            if (t.getURLName().getProtocol().equals("mta")) {
                LOG.debug("transport is 'mta', not trying to connect()");
            } else if (this.isAuthenticate()) {
                LOG.debug("authenticating to {}", (Object)this.getMailHost());
                t.connect(this.getMailHost(), this.getSmtpPort(), this.getUser(), this.getPassword());
            } else {
                LOG.debug("not authenticating to {}", (Object)this.getMailHost());
                t.connect(this.getMailHost(), this.getSmtpPort(), null, null);
            }
            t.sendMessage(message, message.getAllRecipients());
            listener.assertAllMessagesDelivered();
        }
        catch (NoSuchProviderException e) {
            LOG.error("Couldn't get a transport: {}", (Object)e, (Object)e);
            throw new JavaMailerException("Couldn't get a transport: " + (Object)((Object)e), e);
        }
        catch (MessagingException e) {
            LOG.error("Java Mailer messaging exception: {}", (Object)e, (Object)e);
            throw new JavaMailerException("Java Mailer messaging exception: " + (Object)((Object)e), e);
        }
        finally {
            try {
                if (t != null && t.isConnected()) {
                    t.close();
                }
            }
            catch (MessagingException e) {
                throw new JavaMailerException("Java Mailer messaging exception on transport close: " + (Object)((Object)e), e);
            }
        }
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public boolean isUseJMTA() {
        return this.m_useJMTA;
    }

    public void setUseJMTA(boolean useMTA) {
        this.m_useJMTA = useMTA;
    }

    public String getFrom() {
        return this.m_from;
    }

    public void setFrom(String from) {
        this.m_from = from;
    }

    public boolean isAuthenticate() {
        return this.m_authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.m_authenticate = authenticate;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public InputStream getInputStream() {
        return this.m_inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.m_inputStream = inputStream;
    }

    public String getInputStreamName() {
        return this.m_inputStreamName;
    }

    public void setInputStreamName(String inputStreamName) {
        this.m_inputStreamName = inputStreamName;
    }

    public String getInputStreamContentType() {
        return this.m_inputStreamContentType;
    }

    public void setInputStreamContentType(String inputStreamContentType) {
        this.m_inputStreamContentType = inputStreamContentType;
    }

    public String getMailHost() {
        return this.m_mailHost;
    }

    public void setMailHost(String mail_host) {
        this.m_mailHost = mail_host;
    }

    public String getMailer() {
        return this.m_mailer;
    }

    public void setMailer(String mailer) {
        this.m_mailer = mailer;
    }

    public String getMessageText() {
        return this.m_messageText;
    }

    public void setMessageText(String messageText) {
        this.m_messageText = messageText;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public String getTo() {
        return this.m_to;
    }

    public void setTo(String to) {
        this.m_to = to;
    }

    public String getTransport() {
        if (this.isUseJMTA()) {
            return "mta";
        }
        return this.m_transport;
    }

    public void setTransport(String transport) {
        this.m_transport = transport;
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
        if (this.isDebug()) {
            this.m_session.setDebugOut(new PrintStream(new LoggingByteArrayOutputStream()));
        }
        this.m_session.setDebug(this.isDebug());
    }

    public Session getSession() {
        return this.m_session;
    }

    public void setSession(Session session) {
        this.m_session = session;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    public String getCharSet() {
        return this.m_charSet;
    }

    public void setCharSet(String charSet) {
        this.m_charSet = charSet;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    public boolean isStartTlsEnabled() {
        return this.m_startTlsEnabled;
    }

    public void setStartTlsEnabled(boolean startTlsEnabled) {
        this.m_startTlsEnabled = startTlsEnabled;
    }

    public boolean isQuitWait() {
        return this.m_quitWait;
    }

    public void setQuitWait(boolean quitWait) {
        this.m_quitWait = quitWait;
    }

    public int getSmtpPort() {
        return this.m_smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.m_smtpPort = smtpPort;
    }

    public boolean isSmtpSsl() {
        return this.m_smtpSsl;
    }

    public void setSmtpSsl(boolean smtpSsl) {
        this.m_smtpSsl = smtpSsl;
    }

    public Properties getMailProps() {
        return this.m_mailProps;
    }

    public Map<String, String> getExtraHeaders() {
        return this.m_extraHeaders;
    }

    public void setExtraHeaders(Map<String, String> headers) {
        this.m_extraHeaders = headers;
    }

    public void addExtraHeader(String key, String value) {
        this.m_extraHeaders.put(key, value);
    }

    public static class LoggingTransportListener
    implements TransportListener {
        private static final Logger LOG = LoggerFactory.getLogger(LoggingTransportListener.class);
        private List<Address> m_invalidAddresses = new ArrayList<Address>();
        private List<Address> m_validSentAddresses = new ArrayList<Address>();
        private List<Address> m_validUnsentAddresses = new ArrayList<Address>();

        public void messageDelivered(TransportEvent event) {
            this.logEvent("message delivered", event);
        }

        public void messageNotDelivered(TransportEvent event) {
            this.logEvent("message not delivered", event);
        }

        public void messagePartiallyDelivered(TransportEvent event) {
            this.logEvent("message partially delivered", event);
        }

        private void logEvent(String message, TransportEvent event) {
            if (event.getInvalidAddresses() != null && event.getInvalidAddresses().length > 0) {
                this.m_invalidAddresses.addAll(Arrays.asList(event.getInvalidAddresses()));
                LOG.error("{}: invalid addresses: {}", (Object)message, (Object)StringUtils.arrayToDelimitedString((Object[])event.getInvalidAddresses(), (String)", "));
            }
            if (event.getValidSentAddresses() != null && event.getValidSentAddresses().length > 0) {
                this.m_validSentAddresses.addAll(Arrays.asList(event.getValidSentAddresses()));
                LOG.debug("{}: valid sent addresses: {}", (Object)message, (Object)StringUtils.arrayToDelimitedString((Object[])event.getValidSentAddresses(), (String)", "));
            }
            if (event.getValidUnsentAddresses() != null && event.getValidUnsentAddresses().length > 0) {
                this.m_validUnsentAddresses.addAll(Arrays.asList(event.getValidUnsentAddresses()));
                LOG.error("{}: valid unsent addresses: {}", (Object)message, (Object)StringUtils.arrayToDelimitedString((Object[])event.getValidUnsentAddresses(), (String)", "));
            }
        }

        public boolean hasAnythingBeenReceived() {
            return this.m_invalidAddresses.size() != 0 || this.m_validSentAddresses.size() != 0 || this.m_validUnsentAddresses.size() != 0;
        }

        public void assertAllMessagesDelivered() throws JavaMailerException {
            for (int i = 0; i < 10 && !this.hasAnythingBeenReceived(); ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_invalidAddresses.size() == 0 && this.m_validUnsentAddresses.size() == 0) {
                return;
            }
            throw new JavaMailerException("Not all messages delivered:\n\t" + this.m_validSentAddresses.size() + " messages were sent to valid addresses: " + StringUtils.collectionToDelimitedString(this.m_validSentAddresses, (String)", ") + "\n\t" + this.m_validUnsentAddresses.size() + " messages were not sent to valid addresses: " + StringUtils.collectionToDelimitedString(this.m_validUnsentAddresses, (String)", ") + "\n\t" + this.m_invalidAddresses.size() + " messages had invalid addresses: " + StringUtils.collectionToDelimitedString(this.m_invalidAddresses, (String)", "));
        }
    }

    public static class LoggingByteArrayOutputStream
    extends ByteArrayOutputStream {
        private static final Logger LOG = LoggerFactory.getLogger(LoggingByteArrayOutputStream.class);

        @Override
        public void flush() throws IOException {
            super.flush();
            String buffer = this.toString().replaceAll("\n", "");
            if (buffer.length() > 0) {
                LOG.debug(buffer);
            }
            this.reset();
        }
    }

    private static class InputStreamDataSource
    implements DataSource {
        private String name;
        private String contentType;
        private ByteArrayOutputStream baos;

        InputStreamDataSource(String name, String contentType, InputStream inputStream) throws JavaMailerException {
            this.name = name;
            this.contentType = contentType;
            LOG.debug("setting contentType {}", (Object)this.contentType);
            this.baos = new ByteArrayOutputStream();
            byte[] buff = new byte[256];
            try {
                int read;
                while ((read = inputStream.read(buff)) != -1) {
                    this.baos.write(buff, 0, read);
                }
            }
            catch (IOException e) {
                LOG.error("Could not read attachment from input stream: {}", (Object)e, (Object)e);
                throw new JavaMailerException("Could not read attachment from input stream: " + e, e);
            }
        }

        public String getContentType() {
            LOG.debug("getContentType: {}", (Object)this.contentType);
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.baos.toByteArray());
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Cannot write to this read-only resource");
        }
    }
}

