/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.codehaus.jackson.annotate.JsonProperty;
import org.opennms.netmgt.measurements.model.QueryMetadata;

@XmlRootElement(name="query-response")
public class QueryResponse {
    private long step;
    private long start;
    private long end;
    private long[] timestamps;
    private String[] labels;
    private WrappedPrimitive[] columns;
    private List<QueryConstant> constants;
    private QueryMetadata metadata;

    @XmlAttribute(name="step")
    public long getStep() {
        return this.step;
    }

    public void setStep(long step) {
        this.step = step;
    }

    @XmlAttribute(name="start")
    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    @XmlAttribute(name="end")
    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    @XmlElement(name="timestamps")
    public long[] getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(ArrayList<Long> timestamps) {
        int N = timestamps.size();
        this.timestamps = new long[N];
        for (int i = 0; i < N; ++i) {
            this.timestamps[i] = timestamps.get(i);
        }
    }

    public void setTimestamps(long[] timestamps) {
        this.timestamps = timestamps;
    }

    @XmlElement(name="labels")
    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    @XmlElement(name="columns")
    @JsonProperty(value="columns")
    public WrappedPrimitive[] getColumns() {
        return this.columns;
    }

    public void setColumns(WrappedPrimitive[] columns) {
        this.columns = columns;
    }

    public void setColumns(List<double[]> doubles) {
        int N = doubles.size();
        this.columns = new WrappedPrimitive[N];
        for (int i = 0; i < N; ++i) {
            this.columns[i] = new WrappedPrimitive(doubles.get(i));
        }
    }

    public void setColumns(Map<String, double[]> columns) {
        int N = columns.keySet().size();
        this.labels = new String[N];
        this.columns = new WrappedPrimitive[N];
        int k = 0;
        for (Map.Entry<String, double[]> entry : columns.entrySet()) {
            this.labels[k] = entry.getKey();
            this.columns[k++] = new WrappedPrimitive(entry.getValue());
        }
    }

    @XmlElement(name="constants")
    public List<QueryConstant> getConstants() {
        return this.constants;
    }

    public void setConstants(List<QueryConstant> constants) {
        this.constants = constants;
    }

    public void setConstants(Map<String, Object> constants) {
        ArrayList<QueryConstant> c = new ArrayList<QueryConstant>();
        for (Map.Entry<String, Object> entry : constants.entrySet()) {
            c.add(new QueryConstant(entry.getKey(), entry.getValue().toString()));
        }
        this.constants = c;
    }

    @XmlElement(name="metadata")
    public QueryMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(QueryMetadata metadata) {
        this.metadata = metadata;
    }

    public Map<String, double[]> columnsWithLabels() {
        HashMap<String, double[]> mappedValues = Maps.newHashMap();
        for (int i = 0; i < this.labels.length; ++i) {
            mappedValues.put(this.labels[i], this.columns[i].getList());
        }
        return mappedValues;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryResponse other = (QueryResponse)obj;
        return Objects.equal(this.step, other.step) && Objects.equal(this.start, other.start) && Objects.equal(this.end, other.end) && Objects.equal(this.constants, other.constants) && Objects.equal(this.metadata, other.metadata) && Arrays.equals(this.timestamps, other.timestamps) && Arrays.equals(this.labels, other.labels) && Arrays.equals(this.columns, other.columns);
    }

    public int hashCode() {
        return Objects.hashCode(this.step, this.start, this.end, this.timestamps, this.labels, this.columns, this.constants, this.metadata);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("Step", this.step).add("Start", this.start).add("End", this.end).add("Timestamps", Arrays.toString(this.timestamps)).add("Labels", Arrays.toString(this.labels)).add("Columns", Arrays.toString(this.columns)).add("Constants", this.constants).add("Metadata", this.metadata).toString();
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlRootElement(name="constant")
    public static class QueryConstant {
        @XmlAttribute
        private final String key;
        @XmlValue
        private final String value;

        public QueryConstant() {
            this.key = null;
            this.value = null;
        }

        public QueryConstant(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    @XmlRootElement
    public static class WrappedPrimitive {
        private double[] values;

        public WrappedPrimitive() {
        }

        public WrappedPrimitive(double[] values) {
            this.values = values;
        }

        @XmlElement(name="values")
        @JsonProperty(value="values")
        public double[] getList() {
            return this.values;
        }

        public void setList(double[] values) {
            this.values = values;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WrappedPrimitive other = (WrappedPrimitive)obj;
            return Arrays.equals(this.values, other.values);
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.values});
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("Values", Arrays.toString(this.values)).toString();
        }
    }
}

