/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.config;

import java.util.Map;
import java.util.Set;
import org.opennms.core.soa.support.ServiceFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String REF_ATTR = "ref";
    public static final String DEPENDS_ON_ATTR = "depends-on";
    public static final String INTERFACE_ATTR = "interface";
    public static final String INTERFACES_ELEM = "interfaces";
    public static final String PROPS_ELEM = "service-properties";

    @Override
    protected Class<?> getBeanClass(Element element) {
        return ServiceFactoryBean.class;
    }

    @Override
    public void doParse(Element element, ParserContext context, BeanDefinitionBuilder bean) {
        String serviceInterface;
        String ref = element.getAttribute(REF_ATTR);
        bean.addPropertyReference("target", ref);
        bean.addPropertyReference("serviceRegistry", "serviceRegistry");
        String dependsOn = element.getAttribute(DEPENDS_ON_ATTR);
        if (dependsOn != null && !"".equals(dependsOn.trim())) {
            bean.addDependsOn(dependsOn.trim());
        }
        if (StringUtils.hasText(serviceInterface = element.getAttribute(INTERFACE_ATTR))) {
            bean.addPropertyValue(INTERFACES_ELEM, serviceInterface);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!(n instanceof Element)) continue;
            Element child = (Element)n;
            if (INTERFACES_ELEM.equals(child.getLocalName())) {
                if (element.hasAttribute(INTERFACE_ATTR)) {
                    context.getReaderContext().error("either 'interface' attribute or <interfaces> sub-element has to be specified", element);
                }
                Set<Object> interfaces = context.getDelegate().parseSetElement(child, bean.getBeanDefinition());
                bean.addPropertyValue(INTERFACES_ELEM, interfaces);
                continue;
            }
            if (!PROPS_ELEM.equals(child.getLocalName())) continue;
            Map<Object, Object> svcProps = context.getDelegate().parseMapElement(child, bean.getBeanDefinition());
            bean.addPropertyValue("serviceProperties", svcProps);
        }
    }

    @Override
    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

