/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.config;

import java.util.List;
import org.opennms.core.soa.support.ReferenceListFactoryBean;
import org.opennms.core.soa.support.RegistrationListenerBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ReferenceListBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String INTERFACE_ATTR = "interface";
    private static final String FILTER_ATTR = "filter";
    private String m_serviceInterface = null;

    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        List<Element> childElements;
        String filter;
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ReferenceListFactoryBean.class);
        factory.addPropertyReference("serviceRegistry", "serviceRegistry");
        String serviceInterface = element.getAttribute(INTERFACE_ATTR);
        if (StringUtils.hasText(serviceInterface)) {
            this.m_serviceInterface = serviceInterface;
            factory.addPropertyValue("serviceInterface", serviceInterface);
        }
        if (StringUtils.hasText(filter = element.getAttribute(FILTER_ATTR))) {
            factory.addPropertyValue(FILTER_ATTR, filter);
        }
        if ((childElements = DomUtils.getChildElementsByTagName(element, "listener")) != null && childElements.size() > 0) {
            this.parseList(childElements, factory);
        }
        return factory.getBeanDefinition();
    }

    private void parseList(List<Element> childElements, BeanDefinitionBuilder factory) {
        BeanDefinitionBuilder listener = this.parseListener(childElements.get(0));
        factory.addPropertyValue("listener", listener.getBeanDefinition());
    }

    private BeanDefinitionBuilder parseListener(Element element) {
        BeanDefinitionBuilder listener = BeanDefinitionBuilder.rootBeanDefinition(RegistrationListenerBean.class);
        listener.addPropertyReference("target", element.getAttribute("ref"));
        listener.addPropertyValue("serviceInterface", this.m_serviceInterface);
        listener.addPropertyValue("bindMethod", element.getAttribute("bind-method"));
        listener.addPropertyValue("unbindMethod", element.getAttribute("unbind-method"));
        return listener;
    }
}

