/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.grafana;

import com.google.common.base.Throwables;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.opennms.core.sysprops.SystemProperties;

public class ExceptionToPngRenderer {
    private static final String MAX_STACKTRACE_LINES_SYS_PROP = "org.opennms.netmgt.jasper.grafana.maxStackTraceLines";
    private static final int MAX_STACKTRACE_LINES = SystemProperties.getInteger((String)"org.opennms.netmgt.jasper.grafana.maxStackTraceLines", (int)5);
    private static final Font font = new Font(null, 0, 48);

    public static byte[] renderExceptionToPng(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Exception occurred: ");
        String stack = Throwables.getStackTraceAsString(e);
        sb.append(ExceptionToPngRenderer.getFirstNLines(stack, MAX_STACKTRACE_LINES));
        String text = sb.toString();
        String[] lines = text.split("\n");
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(font);
        int lineWidth = 0;
        int lineHeight = 0;
        FontMetrics fm = g2d.getFontMetrics();
        for (String line : lines) {
            lineWidth = Math.max(lineWidth, fm.stringWidth(line));
            lineHeight = Math.max(lineHeight, fm.getHeight());
        }
        g2d.dispose();
        int paddingLeft = 10;
        int paddingTop = 10;
        int imgWidth = 10 + lineWidth;
        int imgHeight = 10 + lineHeight * lines.length;
        img = new BufferedImage(imgWidth, imgHeight, 1);
        g2d = img.createGraphics();
        g2d.setFont(font);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, imgWidth, imgHeight);
        fm = g2d.getFontMetrics();
        g2d.setColor(Color.BLACK);
        int yOffset = 0;
        for (String line : lines) {
            g2d.drawString(line, 10, yOffset + fm.getAscent());
            yOffset += lineHeight;
        }
        g2d.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", baos);
        }
        catch (IOException ex) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    private static String getFirstNLines(String s, int N) {
        String[] lines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(lines.length, N); ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(lines[i]);
        }
        return sb.toString();
    }
}

