/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.api;

import java.util.HashMap;
import java.util.List;
import org.opennms.netmgt.measurements.api.exceptions.ValidationException;
import org.opennms.netmgt.measurements.model.Expression;
import org.opennms.netmgt.measurements.model.FilterDef;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.model.Source;

public class QueryRequestValidator {
    public void validate(QueryRequest request) throws ValidationException {
        if (request.getEnd() < 0L) {
            throw new ValidationException("Query end must be >= 0: {}", request.getEnd());
        }
        if (request.getStep() <= 0L) {
            throw new ValidationException("Query step must be > 0: {}", request.getStep());
        }
        if (request.getHeartbeat() == null && request.getInterval() != null || request.getHeartbeat() != null && request.getInterval() == null) {
            throw new ValidationException("If either the heartbeat or the interval are set, then both must be set.", new Object[0]);
        }
        if (request.getHeartbeat() != null && request.getInterval() != null) {
            if (request.getHeartbeat() <= 0L) {
                throw new ValidationException("Heartbeat must be positive: {}", request.getHeartbeat());
            }
            if (request.getInterval() <= 0L) {
                throw new ValidationException("Interval must be positive: {}", request.getInterval());
            }
            if (request.getStep() % request.getInterval() != 0L) {
                throw new ValidationException("Step must be a multiple of the interval. Step: {}, Interval: {}", request.getStep(), request.getInterval());
            }
            if (request.getHeartbeat() % request.getInterval() != 0L) {
                throw new ValidationException("Heartbeat must be a multiple of the interval. Interval: {} Heartbeat: {}", request.getInterval(), request.getHeartbeat());
            }
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (Source source : request.getSources()) {
            if (source.getResourceId() == null || source.getAttribute() == null || source.getLabel() == null || source.getAggregation() == null) {
                throw new ValidationException("Query source fields must be set: {}", source);
            }
            if (labels.containsKey(source.getLabel())) {
                throw new ValidationException("Query source label '{}' conflict: source with that label is already defined.", source.getLabel());
            }
            labels.put(source.getLabel(), "source");
        }
        for (Expression expression : request.getExpressions()) {
            if (expression.getExpression() == null || expression.getLabel() == null) {
                throw new ValidationException("Query expression fields must be set: {}", expression);
            }
            if (labels.containsKey(expression.getLabel())) {
                String type = (String)labels.get(expression.getLabel());
                throw new ValidationException("Query expression label '{}' conflict: {} with that label is already defined.", expression.getLabel(), type);
            }
            labels.put(expression.getLabel(), "expression");
        }
        List<FilterDef> filters = request.getFilters();
        if (filters.size() > 0) {
            for (FilterDef filter : filters) {
                if (filter.getName() != null) continue;
                throw new ValidationException("Filter name must be set: {}", filter);
            }
        }
    }
}

